/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.utils;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.AgentRegressingUpdateWarningUtil;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.InstallJob;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.preferences.ICicPreferenceConstants;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.Statuses;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

public class AgentUIRegressingUpdateWarningUtil {
    public static IStatus checkRegressingUpdateWarning(AgentJob[] profileJobs) {
        if (profileJobs == null || profileJobs.length == 0) {
            return Status.OK_STATUS;
        }
        Profile installProfile = profileJobs[0].getProfile();
        if (installProfile != null) {
            profileJobs = AgentUtil.addUninstallFixJobs((AgentJob[])profileJobs, (boolean)false);
        }
        boolean showInternalVersion = AgentUI.getDefault().getAgentPreferenceStore().getBoolean(ICicPreferenceConstants.DISPLAY_INTERNAL_VERSION.key());
        CicMultiStatus warning = (CicMultiStatus)AgentRegressingUpdateWarningUtil.checkRegressingUpdateWarning((Agent)Agent.getInstance(), (AgentJob[])profileJobs, (boolean)false, (boolean)showInternalVersion);
        warning.setMessage(Messages.RegressingUpdateWarning_viewDetailMsgNoLink);
        return warning;
    }

    public static IStatus checkRegressingUpdateWarningWithRecommendedFixes(AgentJob[] profileJobs, IProgressMonitor monitor) {
        if (profileJobs == null || profileJobs.length == 0) {
            return Status.OK_STATUS;
        }
        Profile installProfile = profileJobs[0].getProfile();
        SubProgressMonitor sm = new SubProgressMonitor(monitor, profileJobs.length);
        ArrayList<Object> newJobs = new ArrayList<Object>();
        CicMultiStatus status = Statuses.ST.createMultiStatus();
        AgentJob[] agentJobArray = profileJobs;
        int n = profileJobs.length;
        int n2 = 0;
        while (n2 < n) {
            AgentJob job = agentJobArray[n2];
            newJobs.add(job);
            IOffering offering = job.getOffering();
            if (offering != null) {
                List recommendedFixes = Agent.getInstance().getRecommendedFixes(offering, status, (IProgressMonitor)sm);
                for (IFix fix : recommendedFixes) {
                    newJobs.add(new InstallJob(installProfile, (IOfferingOrFix)fix));
                }
                sm.worked(1);
            }
            ++n2;
        }
        sm.done();
        return AgentUIRegressingUpdateWarningUtil.checkRegressingUpdateWarning(AgentJob.toArray(newJobs));
    }

    public static IStatus checkRegressingUpdateWarningWithFixes(AgentJob[] profileJobs, List fixJobs) {
        if (profileJobs == null || profileJobs.length == 0) {
            return Status.OK_STATUS;
        }
        ArrayList<AgentJob> newJobs = new ArrayList<AgentJob>();
        AgentJob[] agentJobArray = profileJobs;
        int n = profileJobs.length;
        int n2 = 0;
        while (n2 < n) {
            AgentJob profileJob = agentJobArray[n2];
            newJobs.add(profileJob);
            ++n2;
        }
        newJobs.addAll(fixJobs);
        return AgentUIRegressingUpdateWarningUtil.checkRegressingUpdateWarning(AgentJob.toArray(newJobs));
    }

    public static IStatus checkRegressingUpdateWarningForMultiProfilesJobs(AgentJob[] allJobs) {
        if (allJobs == null || allJobs.length == 0) {
            return Status.OK_STATUS;
        }
        boolean showInternalVersion = AgentUI.getDefault().getAgentPreferenceStore().getBoolean(ICicPreferenceConstants.DISPLAY_INTERNAL_VERSION.key());
        Collection profileJobsList = AgentUtil.groupByProfile((AgentJob[])allJobs, (boolean)true);
        CicMultiStatus regressingUpdateWarning = Statuses.ST.createMultiStatus();
        Iterator i = profileJobsList.iterator();
        while (i.hasNext()) {
            IStatus[] children;
            CicMultiStatus warning;
            AgentJob[] profileJobs = (AgentJob[])i.next();
            Profile installProfile = profileJobs[0].getProfile();
            if (installProfile != null) {
                profileJobs = AgentUtil.addUninstallFixJobs((AgentJob[])profileJobs, (boolean)false);
            }
            if (!(warning = (CicMultiStatus)AgentRegressingUpdateWarningUtil.checkRegressingUpdateWarning((Agent)Agent.getInstance(), (AgentJob[])profileJobs, (boolean)true, (boolean)showInternalVersion)).matches(2)) continue;
            IStatus[] iStatusArray = children = warning.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus element = iStatusArray[n2];
                regressingUpdateWarning.add(element);
                ++n2;
            }
            if (!i.hasNext()) continue;
            regressingUpdateWarning.add((IStatus)new Status(2, Agent.PI_AGENT, ""));
        }
        if (regressingUpdateWarning.matches(2)) {
            regressingUpdateWarning.setMessage(Messages.RegressingUpdateWarning_viewDetailMsgNoLink);
        }
        return regressingUpdateWarning;
    }
}

