/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.utils;

import com.ibm.cic.agent.core.AgentDependencyCheckerUtil;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.sharedUI.SharedUIDependenciesCheckUtils;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.ui.internal.CicCommonUiPlugin;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class AgentUIDependenciesCheckUtils {
    public static final AgentDependencyCheckerUtil.DependencyCheckerFlags UI_CHECK_FLAGS_PRELIMINARY = AgentDependencyCheckerUtil.FLAGS_FAKE_PROFILE;

    public static Map checkDependencies(final List selectedJobs, final List profiles) {
        final HashMap returnResult = new HashMap();
        try {
            CicCommonUiPlugin.getDefault().runWithSocketMonitor(true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    SplitProgressMonitor sm = new SplitProgressMonitor(monitor, profiles.size());
                    AgentJob[] selectedJobArray = selectedJobs.toArray(new AgentJob[selectedJobs.size()]);
                    int i = 0;
                    while (i < profiles.size()) {
                        Profile profile = (Profile)profiles.get(i);
                        IStatus dependencyStatus = Status.OK_STATUS;
                        try {
                            dependencyStatus = AgentUIDependenciesCheckUtils.checkDependenciesProfilePrepareUnprepareFinal(selectedJobArray, profile, sm.next());
                        }
                        catch (CoreException e) {
                            dependencyStatus = new Status(4, "com.ibm.cic.agent.ui", Messages.AvailableOfferingPage_dependencyException, (Throwable)e);
                        }
                        if (dependencyStatus != null) {
                            if (!dependencyStatus.isOK()) {
                                returnResult.put(profile, AgentUIDependenciesCheckUtils.processDependencyStatus(dependencyStatus, false));
                            } else {
                                returnResult.put(profile, dependencyStatus);
                            }
                        }
                        ++i;
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            AgentUI.reportException(e);
        }
        catch (InterruptedException e) {
            AgentUI.reportException(e);
        }
        return returnResult;
    }

    public static IStatus checkDependenciesFinalProfile(AgentJob[] profileJobs, IProgressMonitor monitor) {
        if (profileJobs == null || profileJobs.length == 0) {
            return Status.OK_STATUS;
        }
        Status returnStatus = null;
        try {
            Profile installProfile = profileJobs[0].getProfile();
            if (installProfile != null) {
                profileJobs = AgentUtil.addUninstallFixJobs((AgentJob[])profileJobs, (boolean)false);
            }
            returnStatus = AgentDependencyCheckerUtil.checkOfferingFixDependenciesProfile((AgentDependencyCheckerUtil.DependencyCheckerFlags)SharedUIDependenciesCheckUtils.UI_CHECK_FLAGS_FINAL, (AgentJob[])profileJobs, (IProgressMonitor)monitor);
        }
        catch (CoreException e) {
            returnStatus = new Status(4, "com.ibm.cic.agent.ui", Messages.AvailableOfferingPage_dependencyException, (Throwable)e);
        }
        return returnStatus;
    }

    public static Map checkDependenciesPeerInstall(final List selectedJobs) {
        final HashMap returnResult = new HashMap();
        try {
            CicCommonUiPlugin.getDefault().runWithSocketMonitor(true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    Collection profileJobsList = AgentUtil.groupByProfile((AgentJob[])AgentJob.toArray((Collection)selectedJobs), (boolean)false);
                    SplitProgressMonitor sm = new SplitProgressMonitor(monitor, profileJobsList.size());
                    for (AgentJob[] profileJobs : profileJobsList) {
                        Profile profile = profileJobs[0].getProfile();
                        IStatus dependencyStatus = Status.OK_STATUS;
                        try {
                            dependencyStatus = AgentDependencyCheckerUtil.checkOfferingFixDependenciesProfilePrepareUnprepare((AgentDependencyCheckerUtil.DependencyCheckerFlags)SharedUIDependenciesCheckUtils.UI_CHECK_FLAGS_FINAL, (AgentJob[])profileJobs, (IProgressMonitor)sm.next());
                        }
                        catch (CoreException e) {
                            dependencyStatus = new Status(4, "com.ibm.cic.agent.ui", Messages.AvailableOfferingPage_dependencyException, (Throwable)e);
                        }
                        if (dependencyStatus == null) continue;
                        if (!dependencyStatus.isOK()) {
                            returnResult.put(profile, AgentUIDependenciesCheckUtils.processDependencyStatus(dependencyStatus, false));
                            continue;
                        }
                        returnResult.put(profile, dependencyStatus);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            AgentUI.reportException(e);
        }
        catch (InterruptedException e) {
            AgentUI.reportException(e);
        }
        return returnResult;
    }

    public static IStatus checkDependenciesPreliminaryProfile(AgentJob[] jobs, IProgressMonitor monitor) {
        if (jobs == null || jobs.length == 0) {
            return Status.OK_STATUS;
        }
        IStatus returnStatus = null;
        try {
            returnStatus = AgentDependencyCheckerUtil.checkOfferingFixDependenciesProfile((AgentDependencyCheckerUtil.DependencyCheckerFlags)UI_CHECK_FLAGS_PRELIMINARY, (AgentJob[])jobs, (IProgressMonitor)monitor);
        }
        catch (CoreException e) {
            returnStatus = new Status(4, "com.ibm.cic.agent.ui", Messages.AvailableOfferingPage_dependencyException, (Throwable)e);
        }
        return returnStatus;
    }

    public static IStatus checkDependenciesProfilePrepareUnprepareFinal(AgentJob[] profileJobs, IProgressMonitor monitor) throws CoreException {
        return AgentDependencyCheckerUtil.checkOfferingFixDependenciesProfilePrepareUnprepare((AgentDependencyCheckerUtil.DependencyCheckerFlags)SharedUIDependenciesCheckUtils.UI_CHECK_FLAGS_FINAL, (AgentJob[])profileJobs, (IProgressMonitor)monitor);
    }

    private static IStatus checkDependenciesProfilePrepareUnprepareFinal(AgentJob[] profileJobs, Profile overrideProfile, IProgressMonitor monitor) throws CoreException {
        SetRestoreJobProfileHelper setRestoreJobsProfile = new SetRestoreJobProfileHelper(overrideProfile, profileJobs);
        try {
            IStatus iStatus = AgentDependencyCheckerUtil.checkOfferingFixDependenciesProfilePrepareUnprepare((AgentDependencyCheckerUtil.DependencyCheckerFlags)SharedUIDependenciesCheckUtils.UI_CHECK_FLAGS_FINAL, (AgentJob[])profileJobs, (IProgressMonitor)monitor);
            return iStatus;
        }
        finally {
            setRestoreJobsProfile.restore();
        }
    }

    public static IStatus checkDependenciesProfilePrepareUnpreparePreliminary(AgentJob[] profileJobs, Profile overrideProfile, IProgressMonitor monitor) throws CoreException {
        SetRestoreJobProfileHelper setRestoreJobsProfile = new SetRestoreJobProfileHelper(overrideProfile, profileJobs);
        try {
            IStatus iStatus = AgentDependencyCheckerUtil.checkOfferingFixDependenciesProfilePrepareUnprepare((AgentDependencyCheckerUtil.DependencyCheckerFlags)UI_CHECK_FLAGS_PRELIMINARY, (AgentJob[])profileJobs, (IProgressMonitor)monitor);
            return iStatus;
        }
        finally {
            setRestoreJobsProfile.restore();
        }
    }

    public static IStatus processDependencyStatus(IStatus dependencyStatus, boolean twoLevel) {
        if (!dependencyStatus.isMultiStatus()) {
            return dependencyStatus;
        }
        IStatus[] childrenStatus = dependencyStatus.getChildren();
        if (childrenStatus != null && childrenStatus.length == 1) {
            IStatus childStatus = childrenStatus[0];
            if (twoLevel) {
                if (childStatus.isMultiStatus()) {
                    IStatus[] children = childStatus.getChildren();
                    if (children != null && children.length == 1) {
                        return children[0];
                    }
                    return dependencyStatus;
                }
                return childStatus;
            }
            return childStatus;
        }
        return dependencyStatus;
    }

    public static class SetRestoreJobProfileHelper {
        private ArrayList remember;

        public SetRestoreJobProfileHelper(Profile profile, AgentJob[] jobs) {
            this.remember = new ArrayList(jobs != null ? jobs.length : 0);
            if (jobs == null) {
                return;
            }
            AgentJob[] agentJobArray = jobs;
            int n = jobs.length;
            int n2 = 0;
            while (n2 < n) {
                AgentJob agentJob = agentJobArray[n2];
                this.remember.add(new Object[]{agentJob, agentJob.getProfile()});
                agentJob.setProfile(profile);
                ++n2;
            }
        }

        public void restore() {
            for (Object[] a : this.remember) {
                AgentJob agentJob = (AgentJob)a[0];
                Profile profile = (Profile)a[1];
                agentJob.setProfile(profile);
            }
        }
    }
}

