/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.preferences;

import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.preferences.AgentMainPreferencePage;
import com.ibm.cic.common.core.preferences.ICicPreferenceConstants;
import com.ibm.cic.common.downloads.DownloadTrace;
import com.ibm.cic.common.downloads.FileCacheManager;
import com.ibm.cic.common.downloads.PreferencesHolder;
import com.ibm.cic.common.downloads.ProxyInfo;
import com.ibm.cic.common.downloads.ProxyProtocol;
import com.ibm.cic.common.downloads.ProxySupport;
import com.ibm.cic.common.downloads.TransferManager;
import com.ibm.cic.common.logging.Logger;
import com.ibm.cic.common.ui.internal.preferences.HostFieldEditor;
import com.ibm.cic.common.ui.internal.preferences.PortFieldEditor;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public abstract class AbstractProxyPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    static final Logger log = DownloadTrace.traceProxySettings.getLog();
    private final String protocol;
    private final ProxyProtocol proxyProtocol;
    private BooleanFieldEditor feEnableProxy;
    private HostFieldEditor feHost;
    private PortFieldEditor fePort;
    private BooleanFieldEditor feUseSocks;
    private HostFieldEditor feSocksHost;
    private PortFieldEditor feSocksPort;

    public AbstractProxyPreferencePage(IPreferenceStore store, String protocol, ProxyProtocol proxyProtocol, String descr) {
        super(1);
        this.protocol = protocol;
        this.proxyProtocol = proxyProtocol;
        this.setPreferenceStore(store);
        this.setDescription(descr);
    }

    protected StringFieldEditor addStringField(Composite parent, String name, String labelText, boolean enabled) {
        StringFieldEditor fieldEditor = new StringFieldEditor(name, labelText, parent);
        if (!enabled) {
            fieldEditor.getTextControl(parent).setEnabled(enabled);
        }
        this.addField((FieldEditor)fieldEditor);
        return fieldEditor;
    }

    protected StringFieldEditor addStringField(Composite parent, ICicPreferenceConstants.PreferenceTag tag, boolean editable) {
        return this.addStringField(parent, tag.key(), tag.label(), editable);
    }

    protected HostFieldEditor addHostField(Composite parent, String name, String labelText, boolean enabled) {
        HostFieldEditor fieldEditor = new HostFieldEditor(name, labelText, parent);
        if (!enabled) {
            fieldEditor.getTextControl(parent).setEnabled(enabled);
        }
        this.addField((FieldEditor)fieldEditor);
        return fieldEditor;
    }

    protected HostFieldEditor addHostField(Composite parent, ICicPreferenceConstants.PreferenceTag tag, boolean editable) {
        return this.addHostField(parent, tag.key(), tag.label(), editable);
    }

    protected BooleanFieldEditor addBooleanField(Composite parent, String name, String labelText) {
        BooleanFieldEditor fieldEditor = new BooleanFieldEditor(name, labelText, parent);
        this.addField((FieldEditor)fieldEditor);
        return fieldEditor;
    }

    protected BooleanFieldEditor addBooleanField(Composite parent, ICicPreferenceConstants.PreferenceTag tag) {
        return this.addBooleanField(parent, tag.key(), tag.label());
    }

    protected PortFieldEditor addPortField(Composite parent, ICicPreferenceConstants.PreferenceTag pref, boolean enabled) {
        PortFieldEditor fieldEditor = new PortFieldEditor(pref.key(), pref.label(), parent);
        if (!enabled) {
            fieldEditor.getTextControl(parent).setEnabled(enabled);
        }
        this.addField((FieldEditor)fieldEditor);
        return fieldEditor;
    }

    public void createFieldEditors() {
        Composite top = this.getFieldEditorParent();
        ProxySupport proxySupport = TransferManager.INSTANCE.getProxySupport(this.protocol);
        if (proxySupport == null) {
            return;
        }
        this.feEnableProxy = this.addBooleanField(top, ICicPreferenceConstants.ProxyPreferences.getProxyEnabled((String)this.protocol));
        boolean editable = this.feEnableProxy.getBooleanValue();
        if (this.proxyProtocol != null && proxySupport.supportsProtocolProxy()) {
            this.feHost = this.addHostField(top, ICicPreferenceConstants.ProxyPreferences.getProxyHost((String)this.proxyProtocol.getKey()), editable);
            this.fePort = this.addPortField(top, ICicPreferenceConstants.ProxyPreferences.getProxyPort((String)this.proxyProtocol.getKey()), editable);
        }
        if (proxySupport.supportsSocksProxy()) {
            if (this.proxyProtocol != null && proxySupport.supportsProtocolProxy()) {
                this.feUseSocks = this.addBooleanField(top, ICicPreferenceConstants.ProxyPreferences.getProxyUseSocks((String)this.proxyProtocol.getKey()));
                editable = this.feUseSocks.getBooleanValue();
            }
            this.feSocksHost = this.addHostField(top, ICicPreferenceConstants.ProxyPreferences.getSocksProxyHost(), editable);
            this.feSocksPort = this.addPortField(top, ICicPreferenceConstants.ProxyPreferences.getSocksProxyPort(), editable);
        }
    }

    public void init(IWorkbench workbench) {
    }

    protected void initialize() {
        super.initialize();
        this.updateFieldEnablement();
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.updateFieldEnablement();
        if (event.getProperty().equals("field_editor_value")) {
            if (event.getSource() == this.feEnableProxy) {
                if (this.feHost != null && this.fePort != null) {
                    this.setValid(this.feHost.checkState() && this.fePort.checkState() && this.feSocksHost.checkState() && this.feSocksPort.checkState());
                } else {
                    this.setValid(this.feSocksHost.checkState() && this.feSocksPort.checkState());
                }
            }
            if (event.getSource() == this.feUseSocks) {
                if (this.feHost != null && this.fePort != null) {
                    this.setValid(this.feHost.checkState() && this.fePort.checkState() && this.feSocksHost.checkState() && this.feSocksPort.checkState());
                } else {
                    this.setValid(this.feSocksHost.checkState() && this.feSocksPort.checkState());
                }
            }
            if (event.getSource() == this.feHost || event.getSource() == this.fePort) {
                this.setValid(this.feHost.checkState() && this.fePort.checkState() && this.feSocksHost.checkState() && this.feSocksPort.checkState());
            }
            if (event.getSource() == this.feSocksHost || event.getSource() == this.feSocksPort) {
                if (this.feHost != null && this.fePort != null) {
                    this.setValid(this.feHost.checkState() && this.fePort.checkState() && this.feSocksHost.checkState() && this.feSocksPort.checkState());
                } else {
                    this.setValid(this.feSocksHost.checkState() && this.feSocksPort.checkState());
                }
            }
        } else {
            super.propertyChange(event);
        }
    }

    private void updateFieldEnablement() {
        if (this.feEnableProxy == null) {
            return;
        }
        boolean enableProxy = this.feEnableProxy.getBooleanValue();
        if (!enableProxy) {
            this.enableField((FieldEditor)this.feHost, false);
            this.enableField((FieldEditor)this.fePort, false);
            this.enableField((FieldEditor)this.feUseSocks, false);
            this.enableField((FieldEditor)this.feSocksHost, false);
            this.enableField((FieldEditor)this.feSocksPort, false);
        } else if (this.feUseSocks == null) {
            this.enableField((FieldEditor)this.feHost, true);
            this.enableField((FieldEditor)this.fePort, true);
            this.enableField((FieldEditor)this.feUseSocks, true);
            this.enableField((FieldEditor)this.feSocksHost, true);
            this.enableField((FieldEditor)this.feSocksPort, true);
        } else {
            boolean useSocks = this.feUseSocks.getBooleanValue();
            this.enableField((FieldEditor)this.feHost, !useSocks);
            this.enableField((FieldEditor)this.fePort, !useSocks);
            this.enableField((FieldEditor)this.feUseSocks, true);
            this.enableField((FieldEditor)this.feSocksHost, useSocks);
            this.enableField((FieldEditor)this.feSocksPort, useSocks);
        }
    }

    private void enableField(FieldEditor fieldEditor, boolean enabled) {
        if (fieldEditor != null) {
            fieldEditor.setEnabled(enabled, this.getFieldEditorParent());
        }
    }

    protected void performDefaults() {
        super.performDefaults();
        this.getPreferenceStore();
        this.updateFieldEnablement();
    }

    public boolean performOk() {
        boolean retVal = super.performOk();
        this.logProxyInfo();
        return retVal;
    }

    private void logProxyInfo() {
        if (log.isDebugLoggable()) {
            log.debug("Determining active proxy for download layer");
            this.logDownloadHandlerProxyInfo(this.protocol);
            if ("http".equals(this.protocol)) {
                this.logDownloadHandlerProxyInfo("https");
            }
        }
    }

    private void logDownloadHandlerProxyInfo(String targetProtocol) {
        ProxyInfo proxyInfo = PreferencesHolder.INSTANCE.getProxyInfo(targetProtocol);
        log.debug("{0} via PrefencesHolder :{1}", new Object[]{targetProtocol, proxyInfo});
    }

    public void performApply() {
        super.performApply();
        this.checkRepositoryStatus();
        AgentUI.getDefault().getAgent().resetPassportAdvantageRepository();
    }

    private void checkRepositoryStatus() {
        IPreferencePage page;
        FileCacheManager.getInstance().reset();
        PreferenceDialog prefDialog = (PreferenceDialog)this.getContainer();
        IPreferenceNode repositoryNode = prefDialog.getPreferenceManager().find("com.ibm.cic.agent.internal.ui.preferences.AgentMainPreferencePage");
        if (repositoryNode != null && (page = repositoryNode.getPage()) != null && page instanceof AgentMainPreferencePage) {
            ((AgentMainPreferencePage)page).resetAccessibility();
            ((AgentMainPreferencePage)page).updateRepositoryTableViewer();
        }
    }
}

