/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.parts;

import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.utils.AgentUIUtils;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.utils.LicenseUtils;
import com.ibm.cic.licensing.common.util.LicenseStatus;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class LicenseTable {
    private Table table;
    private final Map offeringLicenseMap = new HashMap();

    public void createControl(Composite container, FormToolkit toolkit) {
        String[] columnTitles;
        int style = 101124;
        this.table = toolkit.createTable(container, style);
        String[] stringArray = columnTitles = new String[]{Messages.LicenseTableColumnTitle_Name, Messages.LicenseTableColumnTitle_License, Messages.LicenseTableColumnTitle_Expiration};
        int n = columnTitles.length;
        int n2 = 0;
        while (n2 < n) {
            String columnTitle = stringArray[n2];
            TableColumn tableColumn = new TableColumn(this.table, 0);
            tableColumn.setText(columnTitle);
            ++n2;
        }
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 310, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, 140, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, 200, true));
        this.table.setLayout((Layout)tableLayout);
    }

    public Control getControl() {
        return this.table;
    }

    public void setInput(IOffering offering) {
        this.table.clearAll();
        this.table.removeAll();
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        LicenseStatus[] licenseStatus = (LicenseStatus[])this.offeringLicenseMap.get(offering);
        if (licenseStatus == null) {
            licenseStatus = LicenseUtils.getRuntimeLicenseStatusArray((IOffering)offering);
            this.offeringLicenseMap.put(offering, licenseStatus);
        }
        LicenseStatus[] licenseStatusArray = licenseStatus;
        int n = licenseStatus.length;
        int n2 = 0;
        while (n2 < n) {
            LicenseStatus ls = licenseStatusArray[n2];
            String expirationDataLabel = AgentUIUtils.getLicenseExpirationDateLabel(ls);
            TableItem item = new TableItem(this.table, 0);
            item.setText(new String[]{ls.getOfferingName(), ls.getLocalizedLicenseType(), expirationDataLabel});
            ++n2;
        }
    }
}

