/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.factories;

import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.common.core.internal.BoundToOfferingOrFixFactory;
import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.Statuses;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class MoreInfoFactory
extends BoundToOfferingOrFixFactory {
    private static final String TAG_MORE_INFO = "moreInfo";
    private static final String TAG_MOREINFO_OFFERING_BINDING = "moreInfoOfferingBinding";
    private static final String TAG_MOREINFO_FIX_BINDING = "moreInfoFixBinding";
    private static final String ATT_FILE = "file";
    private static final String ATT_MORE_INFO_ID = "moreInfoId";
    private static MoreInfoFactory instance;

    public static MoreInfoFactory getInstance() {
        if (instance == null) {
            instance = new MoreInfoFactory();
        }
        return instance;
    }

    public MoreInfo[] findMoreInfoFor(IOfferingOrFix offeringOrFix) {
        IExtensionPoint moreInfoPoint = Platform.getExtensionRegistry().getExtensionPoint(ComIbmCicCommonCorePlugin.getPluginId(), TAG_MORE_INFO);
        IExtension[] extensions = moreInfoPoint.getExtensions();
        SortedMap moreInfoBindings = this.findOfferingOrFixBindings(offeringOrFix, TAG_MOREINFO_OFFERING_BINDING, TAG_MOREINFO_FIX_BINDING, extensions);
        CicMultiStatus status = Statuses.ST.createMultiStatus();
        ArrayList<MoreInfo> infoList = new ArrayList<MoreInfo>();
        for (Map.Entry entry : moreInfoBindings.entrySet()) {
            IExtension extension;
            String moreInfoId = (String)entry.getKey();
            IConfigurationElement[] elements = this.findByTagAndAttr(TAG_MORE_INFO, ATT_MORE_INFO_ID, moreInfoId, extension = (IExtension)entry.getValue());
            if (elements.length == 0) {
                status.add((IStatus)new Status(2, "com.ibm.cic.agent.ui", moreInfoId));
                continue;
            }
            IConfigurationElement[] iConfigurationElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                MoreInfo info = this.createMoreInfo(element);
                if (info != null) {
                    infoList.add(info);
                }
                ++n2;
            }
        }
        if (!status.isOK()) {
            status.setMessage(NLS.bind((String)Messages.MoreInfo_error, (Object)offeringOrFix.getIdentity(), (Object)offeringOrFix.getVersion()));
            AgentUI.reportStatus((IStatus)status, false);
        }
        return infoList.toArray(new MoreInfo[infoList.size()]);
    }

    private MoreInfo createMoreInfo(IConfigurationElement element) {
        String file = element.getAttribute(ATT_FILE);
        if (file == null) {
            return null;
        }
        String namespace = element.getContributor().getName();
        Bundle bundle = Platform.getBundle((String)namespace);
        if (bundle == null) {
            return null;
        }
        return new MoreInfo(bundle, file);
    }

    protected Comparable createBindingEntry(IConfigurationElement element) {
        return element.getAttribute(ATT_MORE_INFO_ID);
    }

    public static final class MoreInfo {
        private final String file;
        private final Bundle bundle;

        MoreInfo(Bundle bundle, String file) {
            this.bundle = bundle;
            this.file = file;
        }

        public URL getURL(Locale locale) {
            Map<String, String> overrideMap;
            Path path = new Path("$nl$/" + this.file);
            URL url = FileLocator.find((Bundle)this.bundle, (IPath)path, overrideMap = Collections.singletonMap("$nl$", locale.toString()));
            if (url == null) {
                return null;
            }
            try {
                url = FileLocator.toFileURL((URL)url);
            }
            catch (IOException e) {
                AgentUI.reportException(e);
                return null;
            }
            return url;
        }
    }
}

