/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui.dialogs;

import com.ibm.cic.agent.core.utils.AgentUserOptions;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.common.ui.services.UiServices;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class EnterpriseDeploymentToolsDialog
extends TitleAreaDialog {
    private static final int DEFAULT_WIDTH = 550;
    private IDialogSettings dialogSettings;
    private Button portableInstallButton;
    private Button responseFileButton;
    private Button responseFileSkipInstallButton;
    private Label responseFileSkipInstallDirLabel;
    private Combo responseFileSkipInstallDirCombo;
    private Button responseFileSkipInstallDirButton;
    private Label responseFileSkipInstallFileLabel;
    private Combo responseFileSkipInstallFileCombo;
    private Button responseFileSkipInstallFileButton;
    private Label responseFileSkipInstallFileExp;
    private Button responseFileInstalledPkgButton;
    private Button responseFilePkgButton;
    private boolean portableInstall;
    private boolean genResponseFile;
    private boolean genResponseFileSkipInstall;
    private String genResponseFileSkipInstDir;
    private String genResponseFileSkipInstFile;
    private boolean genResponseFileInstalledPkg;
    private boolean genResponseFilePkg;
    private String[] skipInstallDirArray;
    private String[] responseFileArray;
    private static final String SETTING_SKIP_INSTALL_DIR = "SkipInstallDirSettings";
    private static final String SETTING_RESPONSE_FILE = "ResponseFileSettings";
    private static final int MAX_SETTING_LENGTH = 10;
    private final boolean showPortableInstallOption = AgentUserOptions.CIC_SHOW_PORTABLE_INSTALL.isSet();

    public EnterpriseDeploymentToolsDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.EnterpriseDeploymentToolsDlg_Title_2);
        this.setMessage(Messages.EnterpriseDeploymentToolsDlg_Des);
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        new Label(parentComposite, 0);
        Composite comp = new Composite(parentComposite, 0);
        GridLayout compLayout = new GridLayout();
        compLayout.verticalSpacing = 10;
        comp.setLayout((Layout)compLayout);
        GridData gridData = new GridData(1808);
        gridData.widthHint = 550;
        comp.setLayoutData((Object)gridData);
        if (this.showPortableInstallOption) {
            this.portableInstallButton = new Button(comp, 16);
            this.portableInstallButton.setText(Messages.EnterpriseDeploymentToolsDlg_PortableButton);
            this.responseFileButton = new Button(comp, 16);
            this.responseFileButton.setText(Messages.EnterpriseDeploymentToolsDlg_RFButton);
            this.responseFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean selected = EnterpriseDeploymentToolsDialog.this.responseFileButton.getSelection();
                    EnterpriseDeploymentToolsDialog.this.responseFileSkipInstallButton.setEnabled(selected);
                    EnterpriseDeploymentToolsDialog.this.responseFileInstalledPkgButton.setEnabled(selected);
                    EnterpriseDeploymentToolsDialog.this.responseFilePkgButton.setEnabled(selected);
                    boolean skipInstallSelected = EnterpriseDeploymentToolsDialog.this.responseFileSkipInstallButton.getSelection();
                    EnterpriseDeploymentToolsDialog.this.setSkipInstallSectionEnabled(selected && skipInstallSelected);
                }
            });
        }
        Composite responseFileComp = new Composite(comp, this.showPortableInstallOption ? 2048 : 0);
        responseFileComp.setLayout((Layout)new GridLayout());
        GridData responseFileCompData = new GridData(4, 4, true, true);
        if (this.showPortableInstallOption) {
            responseFileCompData.horizontalIndent = 15;
            responseFileCompData.verticalIndent = 5;
        }
        responseFileComp.setLayoutData((Object)responseFileCompData);
        this.responseFileSkipInstallButton = new Button(responseFileComp, 16);
        this.responseFileSkipInstallButton.setText(Messages.EnterpriseDeploymentToolsDlg_RFSkipInstallBtn);
        this.responseFileSkipInstallButton.setSelection(true);
        this.responseFileSkipInstallButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = EnterpriseDeploymentToolsDialog.this.responseFileSkipInstallButton.getSelection();
                EnterpriseDeploymentToolsDialog.this.setSkipInstallSectionEnabled(selected);
            }
        });
        Composite skipInstallComp = new Composite(responseFileComp, 0);
        GridLayout skipInstallCompLayout = new GridLayout();
        skipInstallCompLayout.numColumns = 2;
        skipInstallComp.setLayout((Layout)skipInstallCompLayout);
        GridData skipInstallCompData = new GridData(4, 0x1000000, true, false);
        skipInstallCompData.horizontalIndent = 15;
        skipInstallComp.setLayoutData((Object)skipInstallCompData);
        this.responseFileSkipInstallDirLabel = new Label(skipInstallComp, 0);
        this.responseFileSkipInstallDirLabel.setText(Messages.EnterpriseDeploymentToolsDlg_RFSkipInstallDir);
        GridData skipInstallDirLabelData = new GridData();
        skipInstallDirLabelData.horizontalSpan = 2;
        this.responseFileSkipInstallDirLabel.setLayoutData((Object)skipInstallDirLabelData);
        this.responseFileSkipInstallDirCombo = new Combo(skipInstallComp, 0);
        this.responseFileSkipInstallDirCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.readSettings();
        this.responseFileSkipInstallDirCombo.setItems(this.skipInstallDirArray);
        this.responseFileSkipInstallDirCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EnterpriseDeploymentToolsDialog.this.genResponseFileSkipInstDir = EnterpriseDeploymentToolsDialog.this.responseFileSkipInstallDirCombo.getText();
                EnterpriseDeploymentToolsDialog.this.verifySkipInstallDirFile(true);
            }
        });
        this.responseFileSkipInstallDirButton = new Button(skipInstallComp, 8);
        this.responseFileSkipInstallDirButton.setText(Messages.LicenseImportPage_browse);
        this.responseFileSkipInstallDirButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String directory = UiServices.getInstance().getDirectoryDialog(EnterpriseDeploymentToolsDialog.this.responseFileSkipInstallDirButton.getShell()).title(Messages.EnterpriseDeploymentToolsDlg_RFSkipInstallDir_dlg_title).message(Messages.EnterpriseDeploymentToolsDlg_RFSkipInstallDir_dlg_des).filterPath(TextProcessor.deprocess((String)EnterpriseDeploymentToolsDialog.this.responseFileSkipInstallDirCombo.getText())).run();
                if (directory != null) {
                    EnterpriseDeploymentToolsDialog.this.responseFileSkipInstallDirCombo.setText(TextProcessor.process((String)directory.trim()));
                }
            }
        });
        Composite container = new Composite(skipInstallComp, 0);
        GridLayout containerLayout = new GridLayout();
        containerLayout.verticalSpacing = 2;
        containerLayout.horizontalSpacing = 0;
        containerLayout.numColumns = 2;
        containerLayout.marginWidth = 0;
        container.setLayout((Layout)containerLayout);
        GridData containerData = new GridData(4, 0x1000000, true, false);
        containerData.horizontalSpan = 2;
        container.setLayoutData((Object)containerData);
        this.responseFileSkipInstallFileLabel = new Label(container, 0);
        this.responseFileSkipInstallFileLabel.setText(Messages.EnterpriseDeploymentToolsDlg_RFSkipInstallFile);
        GridData responseFileLabelData = new GridData();
        responseFileLabelData.horizontalSpan = 2;
        this.responseFileSkipInstallFileLabel.setLayoutData((Object)responseFileLabelData);
        this.responseFileSkipInstallFileCombo = new Combo(container, 0);
        this.responseFileSkipInstallFileCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.responseFileSkipInstallFileCombo.setItems(this.responseFileArray);
        this.responseFileSkipInstallFileCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EnterpriseDeploymentToolsDialog.this.genResponseFileSkipInstFile = EnterpriseDeploymentToolsDialog.this.responseFileSkipInstallFileCombo.getText();
                EnterpriseDeploymentToolsDialog.this.verifySkipInstallDirFile(false);
            }
        });
        this.responseFileSkipInstallFileButton = new Button(container, 8);
        this.responseFileSkipInstallFileButton.setText(Messages.AgentInstallLocationPage_browseButton);
        GridData responseFileButtonData = new GridData();
        responseFileButtonData.horizontalIndent = 5;
        this.responseFileSkipInstallFileButton.setLayoutData((Object)responseFileButtonData);
        this.responseFileSkipInstallFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String fullPathName = UiServices.getInstance().getFileDialog(EnterpriseDeploymentToolsDialog.this.responseFileSkipInstallFileButton.getShell()).title(Messages.EnterpriseDeploymentToolsDlg_RFSkipInstallFile_dlg_title).run();
                if (fullPathName != null) {
                    EnterpriseDeploymentToolsDialog.this.responseFileSkipInstallFileCombo.setText(TextProcessor.process((String)fullPathName));
                }
            }
        });
        this.responseFileSkipInstallFileExp = new Label(container, 64);
        this.responseFileSkipInstallFileExp.setText(Messages.EnterpriseDeploymentToolsDlg_RFSkipInstallFile_Des);
        GridData responseFileExpLabelData = new GridData(4, 1, true, false);
        responseFileExpLabelData.horizontalIndent = 2;
        responseFileExpLabelData.widthHint = 450;
        this.responseFileSkipInstallFileExp.setLayoutData((Object)responseFileExpLabelData);
        new Label(container, 0);
        this.responseFileInstalledPkgButton = new Button(responseFileComp, 16);
        this.responseFileInstalledPkgButton.setText(Messages.EnterpriseDeploymentToolsDlg_RFInstalledPkg);
        this.responseFilePkgButton = new Button(responseFileComp, 16);
        this.responseFilePkgButton.setText(Messages.EnterpriseDeploymentToolsDlg_RFPkgs);
        Label separatorLabel = new Label(parentComposite, 258);
        GridData separatorData = new GridData(4, 0x1000000, true, false);
        separatorData.verticalIndent = 15;
        separatorLabel.setLayoutData((Object)separatorData);
        return parentComposite;
    }

    protected Control createContents(Composite parent) {
        Control contentsControl = super.createContents(parent);
        this.setControlInitialStatus();
        if (!this.showPortableInstallOption) {
            this.getButton(0).setEnabled(false);
        }
        return contentsControl;
    }

    private void setControlInitialStatus() {
        this.responseFileSkipInstallButton.setEnabled(!this.showPortableInstallOption);
        this.setSkipInstallSectionEnabled(!this.showPortableInstallOption, true);
        this.responseFileInstalledPkgButton.setEnabled(!this.showPortableInstallOption);
        this.responseFilePkgButton.setEnabled(!this.showPortableInstallOption);
    }

    private void setSkipInstallSectionEnabled(boolean enabled, boolean skipValidation) {
        this.responseFileSkipInstallDirLabel.setEnabled(enabled);
        this.responseFileSkipInstallDirCombo.setEnabled(enabled);
        this.responseFileSkipInstallDirButton.setEnabled(enabled);
        this.responseFileSkipInstallFileLabel.setEnabled(enabled);
        this.responseFileSkipInstallFileCombo.setEnabled(enabled);
        this.responseFileSkipInstallFileButton.setEnabled(enabled);
        this.responseFileSkipInstallFileExp.setEnabled(enabled);
        if (!skipValidation) {
            if (enabled) {
                if (this.verifySkipInstallDir(true)) {
                    if (this.verifySkipInstallFile(true)) {
                        this.getButton(0).setEnabled(true);
                    } else {
                        this.getButton(0).setEnabled(false);
                    }
                } else {
                    this.getButton(0).setEnabled(false);
                }
            } else {
                this.setErrorMessage(null);
                this.getButton(0).setEnabled(true);
            }
        }
    }

    private void setSkipInstallSectionEnabled(boolean enabled) {
        this.setSkipInstallSectionEnabled(enabled, false);
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(Messages.EnterpriseDeploymentToolsDlg_Title);
        super.configureShell(newShell);
    }

    protected void okPressed() {
        this.portableInstall = this.portableInstallButton != null && this.portableInstallButton.getSelection();
        this.genResponseFile = this.responseFileButton == null ? true : this.responseFileButton.getSelection();
        this.genResponseFileSkipInstall = this.genResponseFile && this.responseFileSkipInstallButton.getSelection();
        this.genResponseFileSkipInstDir = this.responseFileSkipInstallDirCombo.getText();
        this.genResponseFileSkipInstFile = this.responseFileSkipInstallFileCombo.getText();
        this.genResponseFileInstalledPkg = this.genResponseFile && this.responseFileInstalledPkgButton.getSelection();
        this.genResponseFilePkg = this.genResponseFile && this.responseFilePkgButton.getSelection();
        super.okPressed();
    }

    private boolean verifySkipInstallDir(boolean displayMsg) {
        if (this.genResponseFileSkipInstDir == null || this.genResponseFileSkipInstDir.trim().length() == 0) {
            this.setErrorMessage(displayMsg ? Messages.EnterpriseDeploymentToolsDlg_RFSkipInstallDir_Error : null);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private boolean verifySkipInstallFile(boolean displayMsg) {
        if (this.genResponseFileSkipInstFile == null || this.genResponseFileSkipInstFile.trim().length() == 0) {
            this.setErrorMessage(displayMsg ? Messages.EnterpriseDeploymentToolsDlg_RFSkipInstallFile_Error : null);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private void verifySkipInstallDirFile(boolean verifyDir) {
        if (verifyDir) {
            if (this.verifySkipInstallDir(true)) {
                if (!this.verifySkipInstallFile(true)) {
                    this.getButton(0).setEnabled(false);
                } else {
                    this.getButton(0).setEnabled(true);
                }
            } else {
                this.getButton(0).setEnabled(false);
            }
        } else if (this.verifySkipInstallFile(true)) {
            if (!this.verifySkipInstallDir(true)) {
                this.getButton(0).setEnabled(false);
            } else {
                this.getButton(0).setEnabled(true);
            }
        } else {
            this.getButton(0).setEnabled(false);
        }
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings settings = AgentUI.getDefault().getDialogSettings();
        this.dialogSettings = settings.getSection(((Object)((Object)this)).getClass().getName());
        if (this.dialogSettings == null) {
            this.dialogSettings = settings.addNewSection(((Object)((Object)this)).getClass().getName());
        }
        return this.dialogSettings;
    }

    private void readSettings() {
        IDialogSettings s = this.getDialogSettings();
        this.skipInstallDirArray = s.getArray(SETTING_SKIP_INSTALL_DIR);
        if (this.skipInstallDirArray == null) {
            this.skipInstallDirArray = new String[0];
        }
        this.responseFileArray = s.getArray(SETTING_RESPONSE_FILE);
        if (this.responseFileArray == null) {
            this.responseFileArray = new String[0];
        }
    }

    private boolean arrayContains(String[] arr, String checkedString) {
        String[] stringArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (element.equals(checkedString)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void writeSettings() {
        IDialogSettings s = this.getDialogSettings();
        String currentDir = this.responseFileSkipInstallDirCombo.getText();
        String[] dirs = this.responseFileSkipInstallDirCombo.getItems();
        if (currentDir != null && currentDir.trim().length() > 0 && !this.arrayContains(dirs, currentDir)) {
            int size = dirs.length;
            int arraySize = 10;
            if (size < 10) {
                arraySize = size + 1;
            }
            String[] newDirs = new String[arraySize];
            if (size < 10) {
                System.arraycopy(dirs, 0, newDirs, 1, size);
            } else {
                System.arraycopy(dirs, 0, newDirs, 1, 9);
            }
            newDirs[0] = currentDir;
            s.put(SETTING_SKIP_INSTALL_DIR, newDirs);
        }
        String[] responseFiles = this.responseFileSkipInstallFileCombo.getItems();
        String currentResponseFile = this.responseFileSkipInstallFileCombo.getText();
        if (currentResponseFile != null && currentResponseFile.trim().length() > 0 && !this.arrayContains(responseFiles, currentResponseFile)) {
            int size = responseFiles.length;
            int arraySize = 10;
            if (size < 10) {
                arraySize = size + 1;
            }
            String[] newResponseFiles = new String[arraySize];
            if (size < 10) {
                System.arraycopy(responseFiles, 0, newResponseFiles, 1, size);
            } else {
                System.arraycopy(responseFiles, 0, newResponseFiles, 1, 9);
            }
            newResponseFiles[0] = currentResponseFile;
            s.put(SETTING_RESPONSE_FILE, newResponseFiles);
        }
    }

    public boolean isPortableInstall() {
        return this.portableInstall;
    }

    public boolean isGenResponseFile() {
        return this.genResponseFile;
    }

    public boolean isGenResponseFileSkipInstall() {
        return this.genResponseFileSkipInstall;
    }

    public String getGenResponseFileSkipInstDir() {
        return this.genResponseFileSkipInstDir;
    }

    public String getGenResponseFileSkipInstFile() {
        return this.genResponseFileSkipInstFile;
    }

    public boolean isGenResponseFileInstalledPkg() {
        return this.genResponseFileInstalledPkg;
    }

    public boolean isGenResponseFilePkg() {
        return this.genResponseFilePkg;
    }

    public boolean close() {
        this.writeSettings();
        AgentUI.getDefault().flushDialogSettings();
        return super.close();
    }
}

