/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.CacheLocationManager;
import com.ibm.cic.agent.core.StartupManager;
import com.ibm.cic.agent.core.cmd.CmdLine;
import com.ibm.cic.agent.core.internal.headless.AgentInput;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.AgentUIWorkbenchAdvisorListener;
import com.ibm.cic.agent.internal.ui.AgentUIWorkbenchWindowAdvisor;
import com.ibm.cic.agent.internal.ui.licenses.Messages;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.ui.internal.CicCommonUiPlugin;
import com.ibm.cic.common.ui.internal.CommonImages;
import com.ibm.cic.common.ui.internal.dialogs.WrapDetailUIDErrorDialog;
import com.ibm.cic.common.ui.utils.DisplayKeeper;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;

public class AgentUIWorkbenchAdvisor
extends WorkbenchAdvisor {
    private final List listeners = new ArrayList();
    private boolean isPostStartup = false;
    private String initialWindowPerspectiveId = null;

    public AgentUIWorkbenchAdvisor() {
        AgentUI.getDefault().setWorkbenchAdvisor(this);
    }

    public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        return new AgentUIWorkbenchWindowAdvisor(configurer);
    }

    public void initialize(IWorkbenchConfigurer configurer) {
        super.initialize(configurer);
        configurer.setSaveAndRestore(false);
        ImageRegistry reg = JFaceResources.getImageRegistry();
        reg.put("dialog_help_image", CommonImages.DESC_HELP_ELCL);
    }

    public void preStartup() {
        super.preStartup();
        AgentUI ui = AgentUI.getDefault();
        if (ui != null) {
            ui.initializeDiskPrompterAndAuthenticationDialog();
            ui.processArguments();
        }
    }

    public void postStartup() {
        this.isPostStartup = true;
    }

    private void doAgentStartup() {
        if (AgentUI.getDefault() == null) {
            return;
        }
        AgentUI.getDefault().getAgent();
        DisplayKeeper.INSTANCE.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                boolean noProductInstalled;
                IStatus agentStartStatus = AgentUI.getDefault().getAgentStartStatus();
                if (!agentStartStatus.isOK()) {
                    WrapDetailUIDErrorDialog.openError((Shell)AgentUI.getActiveWorkbenchShell(), (String)com.ibm.cic.agent.internal.ui.Messages.AgentUIWorkbenchWindowAdvisor_windowTitle, null, (IStatus)agentStartStatus, (int)15);
                    AgentUIWorkbenchAdvisor.this.getWorkbenchConfigurer().getWorkbench().close();
                    return;
                }
                if (agentStartStatus.isOK() && AgentUI.getDefault().isOnlyUninstallAgentCommand() && !(noProductInstalled = CacheLocationManager.getInstance().isCacheLocationChangeable())) {
                    MessageDialog.openWarning((Shell)AgentUI.getActiveWorkbenchShell(), (String)com.ibm.cic.agent.internal.ui.Messages.AgentUIWorkbenchWindowAdvisor_windowTitle, (String)com.ibm.cic.agent.internal.ui.Messages.InstalledOfferingPage_uninstallIM_msg);
                    AgentUIWorkbenchAdvisor.this.getWorkbenchConfigurer().getWorkbench().close();
                    return;
                }
                AgentInput agentInput = AgentInput.getInstance();
                if (agentInput.getMode() == 0 && agentInput.getQuickStartMessage() != null && CmdLine.CL.isLiveInput()) {
                    MessageDialog.openInformation((Shell)AgentUI.getActiveWorkbenchShell(), (String)Messages.ManageLicanseWizardTitle, (String)agentInput.getQuickStartMessage());
                }
                AgentUI.getDefault().preprocessInputCommands();
                agentStartStatus = AgentUI.getDefault().getAgentStartStatus();
                if (StatusUtil.isErrorOrCancel((IStatus)agentStartStatus)) {
                    WrapDetailUIDErrorDialog.openError((Shell)AgentUI.getActiveWorkbenchShell(), (String)com.ibm.cic.agent.internal.ui.Messages.AgentUIWorkbenchWindowAdvisor_windowTitle, null, (IStatus)agentStartStatus, (int)15);
                    AgentUIWorkbenchAdvisor.this.getWorkbenchConfigurer().getWorkbench().close();
                    return;
                }
                IStatus status = Status.OK_STATUS;
                try {
                    status = AgentUIWorkbenchAdvisor.this.runStartupWithProgressMonitor();
                }
                catch (Exception e) {
                    status = new Status(4, Agent.PI_AGENT, 0, e.getLocalizedMessage(), (Throwable)e);
                }
                if (!status.isOK()) {
                    WrapDetailUIDErrorDialog.openError((Shell)CicCommonUiPlugin.getActiveWorkbenchShell(), (String)com.ibm.cic.agent.internal.ui.Messages.AgentUIWorkbenchWindowAdvisor_windowTitle, null, (IStatus)status, (int)15);
                }
                boolean isWizardMode = false;
                if (agentInput.getMode() == 1) {
                    isWizardMode = true;
                    int subMode = agentInput.getWizardSubMode();
                    if (subMode != 7 && subMode != 8) {
                        AgentUI.getDefault().setWizardJobs();
                    }
                    String finalPerspectiveId = agentInput.getMode() == 1 ? "com.ibm.cic.agent.ui.wizards" : "com.ibm.cic.agent.ui.quickstart";
                    for (AgentUIWorkbenchAdvisorListener listener : AgentUIWorkbenchAdvisor.this.listeners) {
                        listener.prePerspectiveChange(finalPerspectiveId);
                    }
                    AgentUI.showPerspective(finalPerspectiveId, PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                } else {
                    Shell shell = CicCommonUiPlugin.getActiveWorkbenchShell();
                    if (shell != null) {
                        shell.redraw(0, 0, shell.getSize().x, shell.getSize().y, true);
                    }
                }
                IStatus wizardStatus = agentInput.getWizardStatus();
                if (wizardStatus != null && !wizardStatus.isOK()) {
                    if (CmdLine.CL.isLiveInput()) {
                        AgentUI.reportStatus(wizardStatus, false);
                    } else {
                        AgentUI.reportStatus(wizardStatus, true);
                    }
                    if (isWizardMode && wizardStatus.matches(4)) {
                        AgentUIWorkbenchAdvisor.this.getWorkbenchConfigurer().getWorkbench().close();
                    }
                }
            }
        });
    }

    public String getInitialWindowPerspectiveId() {
        if (this.initialWindowPerspectiveId == null) {
            this.doAgentStartup();
            this.initialWindowPerspectiveId = AgentInput.getInstance().getMode() == 1 ? "com.ibm.cic.agent.ui.init" : "com.ibm.cic.agent.ui.quickstart";
        }
        return this.initialWindowPerspectiveId;
    }

    public void postShutdown() {
        AgentUI ui = AgentUI.getDefault();
        if (ui != null) {
            ui.stopAgent();
        }
    }

    private IStatus runStartup(IProgressMonitor monitor) {
        return StartupManager.getInstance().runStartups(monitor);
    }

    public String getMainPreferencePageId() {
        return "com.ibm.cic.agent.internal.ui.preferences.AgentMainPreferencePage";
    }

    private IStatus runStartupWithProgressMonitor() {
        final IStatus[] status = new IStatus[]{Status.OK_STATUS};
        try {
            CicCommonUiPlugin.getDefault().runWithSocketMonitor(true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    status[0] = AgentUIWorkbenchAdvisor.this.runStartup(monitor);
                }
            }, 1000);
        }
        catch (Exception e) {
            status[0] = new Status(4, Agent.PI_AGENT, 0, e.getLocalizedMessage(), (Throwable)e);
        }
        return status[0];
    }

    public void addListener(AgentUIWorkbenchAdvisorListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public boolean isPostStartup() {
        return this.isPostStartup;
    }
}

