/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.ui;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.IAgentEventManager;
import com.ibm.cic.agent.core.internal.headless.AgentInput;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.Messages;
import com.ibm.cic.agent.internal.ui.actions.ExportDataAction;
import com.ibm.cic.agent.internal.ui.actions.IMAboutAction;
import com.ibm.cic.agent.internal.ui.actions.InstallAction;
import com.ibm.cic.agent.internal.ui.actions.LicenseManagementAction;
import com.ibm.cic.agent.internal.ui.actions.ModifyAction;
import com.ibm.cic.agent.internal.ui.actions.OpenPreferenceDlgAction;
import com.ibm.cic.agent.internal.ui.actions.RollbackAction;
import com.ibm.cic.agent.internal.ui.actions.StopServerAction;
import com.ibm.cic.agent.internal.ui.actions.UninstallAction;
import com.ibm.cic.agent.internal.ui.actions.UpdateAction;
import com.ibm.cic.agent.internal.ui.factories.ImportWizardFactory;
import com.ibm.cic.agent.internal.ui.utils.AgentUIUtils;
import com.ibm.cic.agent.ui.extensions.AbstractAgentUIAction;
import com.ibm.cic.common.core.preferences.CicPreferenceManager;
import com.ibm.cic.common.core.preferences.ICicPreferenceConstants;
import com.ibm.cic.common.ui.CICImages;
import com.ibm.cic.common.ui.services.UiServices;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.Util;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;

public class AgentUIActionBarAdvisor
extends ActionBarAdvisor {
    private static final String COM_IBM_CIC_AGENT_UI_ABOUT = "com.ibm.cic.agent.ui.about";
    private static final String COM_IBM_CIC_AGENT_UI_MENU_OPEN_PREFERENCES = "com.ibm.cic.agent.ui.menu.openPreferences";
    private ActionFactory.IWorkbenchAction quitAction;
    private ActionFactory.IWorkbenchAction helpContentsAction;
    private ActionFactory.IWorkbenchAction searchHelpAction;
    private IAction aboutAction;
    private IAction preferencesAction;
    private ExportDataAction exportAction;
    private IAction installAction;
    private IAction updateAction;
    private IAction modifyAction;
    private IAction licenseAction;
    private IAction importAction;
    private IAction rollbackAction;
    private IAction uninstallAction;
    private IAction stopServerAction;
    private static final String ViewLogsGroupMarker = "ViewLogsGroup";
    private static final String InstallActionId = "com.ibm.cic.agent.ui.menu.installpkg";
    private static final String ModifyActionId = "com.ibm.cic.agent.ui.menu.modifyPkg";
    private static final String UpdateActionId = "com.ibm.cic.agent.ui.menu.updatepkg";
    private static final String RollbackActionId = "com.ibm.cic.agent.ui.menu.rollbackPkg";
    private static final String UninstallActionId = "com.ibm.cic.agent.ui.menu.uninstallPkg";
    private static final String ManangeLicenseActionId = "com.ibm.cic.agent.ui.menu.manageLicense";

    public AgentUIActionBarAdvisor(IActionBarConfigurer configurer) {
        super(configurer);
    }

    private void makeEclipseActions(IWorkbenchWindow window) {
        this.preferencesAction = new OpenPreferenceDlgAction(window);
        if (Util.isMac()) {
            this.preferencesAction.setId(ActionFactory.PREFERENCES.getId());
            this.preferencesAction.setActionDefinitionId(ActionFactory.PREFERENCES.getCommandId());
        } else {
            this.preferencesAction.setId(COM_IBM_CIC_AGENT_UI_MENU_OPEN_PREFERENCES);
        }
        this.preferencesAction.setText(Messages.MenuItem_OpenPreferences);
        this.preferencesAction.setToolTipText(Messages.MenuItem_Tooltip_OpenPreferences);
        this.register(this.preferencesAction);
        this.aboutAction = new IMAboutAction(window);
        if (Util.isMac()) {
            if (!UiServices.getInstance().isWebPlatformActive()) {
                this.aboutAction.setId(ActionFactory.ABOUT.getId());
                this.aboutAction.setActionDefinitionId(ActionFactory.ABOUT.getCommandId());
            }
        } else {
            this.aboutAction.setId(COM_IBM_CIC_AGENT_UI_ABOUT);
        }
        IProduct product = Platform.getProduct();
        String productName = "";
        if (product != null) {
            productName = product.getName();
        }
        this.aboutAction.setText(NLS.bind((String)Messages.Agent_AboutMenu, (Object)productName));
        this.aboutAction.setToolTipText(NLS.bind((String)com.ibm.cic.agent.core.sharedUI.Messages.Agent_AboutDlgTitle, (Object)productName));
        this.register(this.aboutAction);
        if (Util.isMac() && !UiServices.getInstance().isWebPlatformActive()) {
            return;
        }
        this.quitAction = ActionFactory.QUIT.create(window);
        this.register((IAction)this.quitAction);
        if (UiServices.getInstance().isWebPlatformActive()) {
            this.quitAction.setText(Messages.AgentUIActionBarAdvisor_StopServerLabel);
            this.stopServerAction = new StopServerAction(window);
            this.stopServerAction.setId(this.quitAction.getId());
            this.stopServerAction.setActionDefinitionId(this.quitAction.getActionDefinitionId());
            this.register(this.stopServerAction);
        }
    }

    protected void makeActions(IWorkbenchWindow window) {
        this.makeEclipseActions(window);
        this.helpContentsAction = ActionFactory.HELP_CONTENTS.create(window);
        this.searchHelpAction = ActionFactory.HELP_SEARCH.create(window);
        this.register((IAction)this.helpContentsAction);
        this.register((IAction)this.searchHelpAction);
        this.exportAction = new ExportDataAction(window);
        this.exportAction.setText(Messages.ExportDataMenuItem);
        this.exportAction.setToolTipText(Messages.LogSection_zip_tooltip);
        this.exportAction.setImageDescriptor(CICImages.LOG_ZIP_FILE);
        this.exportAction.setDisabledImageDescriptor(CICImages.LOG_ZIP_FILE_DISABLED);
        this.exportAction.setId("com.ibm.cic.agent.ui.exportData");
        this.register((IAction)this.exportAction);
        if (AgentInput.getInstance().getMode() == 0) {
            this.installAction = new InstallAction(window);
            this.installAction.setId(InstallActionId);
            this.installAction.setText(Messages.MenuItem_InstallPackages);
            this.installAction.setToolTipText(Messages.MenuItem_Tooltip_InstallPackages);
            this.installAction.setImageDescriptor(CICImages.MENU_INSTALL);
            this.installAction.setDisabledImageDescriptor(CICImages.MENU_INSTALL_DISABLED);
            this.register(this.installAction);
            this.updateAction = new UpdateAction(window);
            this.updateAction.setId(UpdateActionId);
            this.updateAction.setText(Messages.MenuItem_CheckForUpdates);
            this.updateAction.setToolTipText(Messages.MenuItem_Tooltip_CheckForUpdates);
            this.updateAction.setImageDescriptor(CICImages.MENU_UPDATE);
            this.updateAction.setDisabledImageDescriptor(CICImages.MENU_UPDATE_DISABLED);
            this.register(this.updateAction);
            this.modifyAction = new ModifyAction(window);
            this.modifyAction.setId(ModifyActionId);
            this.modifyAction.setText(Messages.MenuItem_ModifyPackages);
            this.modifyAction.setToolTipText(Messages.MenuItem_Tooltip_ModifyPackages);
            this.modifyAction.setImageDescriptor(CICImages.MENU_MODIFY);
            this.modifyAction.setDisabledImageDescriptor(CICImages.MENU_MODIFY_DISABLED);
            this.register(this.modifyAction);
            this.licenseAction = new LicenseManagementAction(window);
            this.licenseAction.setId(ManangeLicenseActionId);
            this.licenseAction.setText(Messages.MenuItem_LicenseManagement);
            this.licenseAction.setToolTipText(Messages.MenuItem_Tooltip_LicenseManagement);
            this.licenseAction.setImageDescriptor(CICImages.MENU_LICENSE);
            this.licenseAction.setDisabledImageDescriptor(CICImages.MENU_LICENSE_DISABLED);
            this.register(this.licenseAction);
            this.rollbackAction = new RollbackAction(window);
            this.rollbackAction.setId(RollbackActionId);
            this.rollbackAction.setText(Messages.MenuItem_Rollback);
            this.rollbackAction.setToolTipText(Messages.MenuItem_Tooltip_Rollback);
            this.rollbackAction.setImageDescriptor(CICImages.MENU_ROLLBACK);
            this.rollbackAction.setDisabledImageDescriptor(CICImages.MENU_ROLLBACK_DISABLED);
            this.register(this.rollbackAction);
            this.uninstallAction = new UninstallAction(window);
            this.uninstallAction.setId(UninstallActionId);
            this.uninstallAction.setText(Messages.MenuItem_Uninstall);
            this.uninstallAction.setToolTipText(Messages.MenuItem_Tooltip_Uninstall);
            this.uninstallAction.setImageDescriptor(CICImages.MENU_UNINSTALL);
            this.uninstallAction.setDisabledImageDescriptor(CICImages.MENU_UNINSTALL_DISABLED);
            this.register(this.uninstallAction);
            ImportWizardFactory.ImportWizardExtension[] extensions = ImportWizardFactory.getInstance().createImportWizards();
            if (extensions.length > 0) {
                this.importAction = extensions[0].getImportWizard();
                if (this.importAction != null) {
                    this.importAction.setId(extensions[0].getActionId());
                    this.importAction.setText(extensions[0].getActionLabel());
                    this.importAction.setToolTipText(extensions[0].getActionTooltip());
                    this.importAction.setImageDescriptor(extensions[0].getActionImage());
                    this.importAction.setDisabledImageDescriptor(extensions[0].getActionDisableImage());
                    ((AbstractAgentUIAction)this.importAction).setWorkbenchWindow(window);
                    this.register(this.importAction);
                }
            }
        }
    }

    protected void fillMenuBar(IMenuManager menuBar) {
        MenuManager fileMenu = new MenuManager(Messages.AgentUIActionBarAdvisor_menubar_file, "file");
        if (AgentInput.getInstance().getMode() == 0) {
            final MenuManager openMenu = new MenuManager(Messages.MenuOpenLabel, null);
            fileMenu.add((IContributionItem)openMenu);
            openMenu.add(this.installAction);
            openMenu.add(this.updateAction);
            openMenu.add(this.modifyAction);
            if (AgentUIUtils.containUseIMManageLicenseOffering()) {
                openMenu.add(this.licenseAction);
            }
            IAgentEventManager eventManager = Agent.getInstance().getEventManager();
            eventManager.addInstallOfferingOrFixListener(new IAgentEventManager.AgentJobListener(){

                public void afterInstallOfferingOrFix(IAgentEventManager.AgentJobEvent event) {
                    AgentUIActionBarAdvisor.this.showOrHideLicenseMenu(openMenu);
                }

                public void afterUninstallOfferingOrFix(IAgentEventManager.AgentJobEvent event) {
                    AgentUIActionBarAdvisor.this.showOrHideLicenseMenu(openMenu);
                }

                public IStatus beforeInstallOfferingOrFix(IAgentEventManager.AgentJobEvent event) {
                    return null;
                }

                public IStatus beforeUninstallOfferingOrFix(IAgentEventManager.AgentJobEvent event) {
                    return null;
                }
            });
            eventManager.addUninstallOfferingOrFixListener(new IAgentEventManager.AgentJobListener(){

                public void afterInstallOfferingOrFix(IAgentEventManager.AgentJobEvent event) {
                    AgentUIActionBarAdvisor.this.showOrHideLicenseMenu(openMenu);
                }

                public void afterUninstallOfferingOrFix(IAgentEventManager.AgentJobEvent event) {
                    AgentUIActionBarAdvisor.this.showOrHideLicenseMenu(openMenu);
                }

                public IStatus beforeInstallOfferingOrFix(IAgentEventManager.AgentJobEvent event) {
                    return null;
                }

                public IStatus beforeUninstallOfferingOrFix(IAgentEventManager.AgentJobEvent event) {
                    return null;
                }
            });
            if (this.importAction != null) {
                AgentUI.getDefault().getAgentPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent event) {
                        String property = event.getProperty();
                        if (property.equals(ICicPreferenceConstants.IMPORT_ENABLED.key())) {
                            IContributionItem item = openMenu.find(AgentUIActionBarAdvisor.this.importAction.getId());
                            if (Boolean.valueOf(event.getNewValue().toString()).booleanValue()) {
                                if (item == null) {
                                    openMenu.insertBefore(AgentUIActionBarAdvisor.this.rollbackAction.getId(), AgentUIActionBarAdvisor.this.importAction);
                                } else {
                                    item.setVisible(true);
                                }
                            } else if (item != null) {
                                item.setVisible(false);
                            }
                            openMenu.markDirty();
                        }
                    }
                });
                if (CicPreferenceManager.getInstance().getBoolean(ICicPreferenceConstants.IMPORT_ENABLED.key())) {
                    openMenu.add(this.importAction);
                }
            }
            openMenu.add(this.rollbackAction);
            openMenu.add(this.uninstallAction);
        }
        fileMenu.add((IContributionItem)new Separator());
        fileMenu.add((IContributionItem)new GroupMarker(ViewLogsGroupMarker));
        fileMenu.add((IContributionItem)new Separator());
        ActionContributionItem preferencesActionItem = new ActionContributionItem(this.preferencesAction);
        fileMenu.add((IContributionItem)preferencesActionItem);
        fileMenu.add((IContributionItem)new Separator());
        preferencesActionItem.setVisible(!Util.isMac());
        if (!Util.isMac()) {
            fileMenu.add((IAction)this.quitAction);
        }
        menuBar.add((IContributionItem)fileMenu);
        MenuManager helpMenu = new MenuManager(Messages.AgentUIActionBarAdvisor_menubar_help, "help");
        helpMenu.add((IAction)this.helpContentsAction);
        helpMenu.add((IAction)this.searchHelpAction);
        helpMenu.add((IContributionItem)new Separator());
        helpMenu.add((IAction)this.exportAction);
        ActionContributionItem aboutActionItem = new ActionContributionItem(this.aboutAction);
        helpMenu.add((IContributionItem)new Separator());
        helpMenu.add((IContributionItem)aboutActionItem);
        aboutActionItem.setVisible(!Util.isMac());
        menuBar.add((IContributionItem)helpMenu);
    }

    protected void disposeActions() {
        super.disposeActions();
    }

    private void showOrHideLicenseMenu(MenuManager openMenu) {
        IContributionItem item = openMenu.find(this.licenseAction.getId());
        if (AgentUIUtils.containUseIMManageLicenseOffering()) {
            if (item == null) {
                openMenu.insertAfter(this.modifyAction.getId(), this.licenseAction);
            } else {
                item.setVisible(true);
            }
        } else if (item != null) {
            item.setVisible(false);
        }
        openMenu.markDirty();
    }
}

