/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.logging;

import com.ibm.cic.common.core.internal.utils.RefCount;
import com.ibm.cic.common.logging.Logger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SupplementaryLoggerRunIfLastManager {
    public static final SupplementaryLoggerRunIfLastManager INSTANCE = new SupplementaryLoggerRunIfLastManager();
    private final SupplementaryLoggerRefCounted rcLogs = new SupplementaryLoggerRefCounted();

    private SupplementaryLoggerRunIfLastManager() {
    }

    private synchronized RefCount remove(String slogName) {
        RefCount rc = this.rcLogs.removeRef(slogName);
        return rc;
    }

    public synchronized SupplementaryLoggerRunIfLastContext openRunIfLastContext(String slogName) {
        RefCount rc = this.rcLogs.addRef(slogName);
        return new SupplementaryLoggerRunIfLastContext(slogName, rc);
    }

    public static interface ISupplementaryLoggerRunnable {
        public void run(Logger.SupplementaryLogger var1);
    }

    private static class SupplementaryLoggerRefCounted {
        private final Map<String, RefCount> slogs = Collections.synchronizedMap(new HashMap());

        private SupplementaryLoggerRefCounted() {
        }

        public synchronized RefCount addRef(String slogName) {
            RefCount ref = this.slogs.get(slogName);
            if (ref != null) {
                ref.incrRefCount();
            } else {
                Logger.SupplementaryLogger slog = Logger.getSupplementaryLogger(slogName);
                ref = new RefCount(slog);
                this.slogs.put(slogName, ref);
            }
            return ref;
        }

        public synchronized RefCount removeRef(String slogName) {
            RefCount ref = this.slogs.get(slogName);
            if (ref != null) {
                ref.decrRefCount();
                if (ref.isZeroRefCount()) {
                    this.slogs.remove(slogName);
                }
                return ref;
            }
            return null;
        }
    }

    public static class SupplementaryLoggerRunIfLastContext {
        private final String slogName;
        private final RefCount refCount;
        public static final int USE_IF_WARNINGS_OR_ERRORS = 1;
        public static final int USE_IF_ERRORS = 2;

        protected SupplementaryLoggerRunIfLastContext(String slogName, RefCount refCount) {
            this.slogName = slogName;
            this.refCount = refCount;
        }

        public boolean hasCreatedLog() {
            return this.refCount.getRefCount() == 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runIfLastSupplementaryLogger(ISupplementaryLoggerRunnable slogCheckRunnable) {
            SupplementaryLoggerRunIfLastManager supplementaryLoggerRunIfLastManager = INSTANCE;
            synchronized (supplementaryLoggerRunIfLastManager) {
                RefCount rc = INSTANCE.remove(this.slogName);
                if (rc == null) {
                    return;
                }
                if (rc.isZeroRefCount()) {
                    Logger.SupplementaryLogger slog = (Logger.SupplementaryLogger)rc.getObject();
                    slogCheckRunnable.run(slog);
                }
            }
        }

        public Logger.SupplementaryLogger getSlog() {
            return (Logger.SupplementaryLogger)this.refCount.getObject();
        }

        public static boolean checkUsed(Logger.SupplementaryLogger slog) {
            return SupplementaryLoggerRunIfLastContext.checkUsed(slog, 2, true);
        }

        public static boolean checkUsed(Logger.SupplementaryLogger slog, int useFlags) {
            return SupplementaryLoggerRunIfLastContext.checkUsed(slog, useFlags, true);
        }

        public static boolean checkUsed(Logger.SupplementaryLogger slog, int useFlags, boolean resetCheckpoint) {
            if (useFlags == 1 && (slog.getErrorCount() > 0 || slog.getWarningCount() > 0)) {
                return true;
            }
            return useFlags == 2 && slog.getErrorCount() > 0;
        }
    }
}

