/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.logging;

import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.internal.utils.CicCommonCoreTrace;
import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.logging.ExceptionUtil;
import com.ibm.cic.common.logging.LogManager;
import com.ibm.cic.common.logging.Logger;
import com.ibm.icu.util.GregorianCalendar;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import org.eclipse.core.runtime.IStatus;
import sun.security.action.GetPropertyAction;

public class LogUtil {
    public static final String NEWLINE = LogUtil.getNewLine();
    public static final String INDENT = "  ";
    public static final int STACK_TRACE_LIMIT = 4;
    public static final int STACK_TRACE_NO_LIMIT = -1;
    private static final String PACKAGE = String.valueOf(LogUtil.class.getPackage().getName()) + '.';
    private static final String RUNTIME = "org.eclipse.core.internal.runtime.";
    private static final String COMMON_CORE_TRACE_PACKAGE = CicCommonCoreTrace.class.getPackage().getName();

    private LogUtil() {
        throw new AssertionError((Object)"Instances of Util should not be created");
    }

    public static String getSimpleName(String name) {
        return name.substring(name.lastIndexOf(46) + 1);
    }

    public static String fixNewlines(String string) {
        if (NEWLINE.equals("\r\n") && string.indexOf(10) >= 0) {
            int length = string.length();
            StringBuffer sb = new StringBuffer(11 * length / 10);
            int i = 0;
            while (i < length) {
                char c = string.charAt(i);
                if (c == '\n' && (i == 0 || string.charAt(i - 1) != '\r')) {
                    sb.append('\r');
                }
                sb.append(c);
                ++i;
            }
            return sb.length() > length ? sb.toString() : string;
        }
        return string;
    }

    public static String toString(Object obj) {
        StringBuffer sb = new StringBuffer();
        LogUtil.appendObject(sb, 0, obj);
        return sb.toString();
    }

    public static File createLogFile(File dir, long startTime, String ext) {
        return LogUtil.createLogFile(dir, "", startTime, ext);
    }

    public static File createLogFile(File dir, String prefix, long startTime, String ext) {
        int simpleLen;
        StringBuffer name;
        block10: {
            name = new StringBuffer(prefix);
            LogUtil.appendDateTime(name, startTime);
            simpleLen = name.length();
            name.append(ext);
            File logFile = new File(dir, name.toString());
            try {
                dir.mkdirs();
                if (logFile.createNewFile()) {
                    return logFile;
                }
            }
            catch (IOException iOException) {
                if (!CicCommonSettings.getAccessRightsMode().isGroupMode()) break block10;
                Logger.getGlobalLogger().error(Messages.LogUtil_Failed_To_Create_Log_File_Group_Mode, logFile.getPath());
                return null;
            }
        }
        int errorCount = 0;
        int n = 0;
        while (n < 10000) {
            name.setLength(name.length() - ext.length());
            LogUtil.incr(name, simpleLen);
            name.append(ext);
            File file2 = new File(dir, name.toString());
            try {
                if (file2.createNewFile()) {
                    return file2;
                }
            }
            catch (IOException e) {
                String parentFileDetails;
                if (++errorCount <= 10) {
                    file2.getParentFile().mkdirs();
                }
                String logFileDetails = FileUtil.getFileDetails(file2);
                if (logFileDetails != null && !logFileDetails.isEmpty()) {
                    LogManager.reportError(logFileDetails);
                }
                if ((parentFileDetails = FileUtil.getFileDetails(file2.getParentFile())) != null && !parentFileDetails.isEmpty()) {
                    LogManager.reportError(parentFileDetails);
                }
                LogManager.reportError(e);
                return null;
            }
            ++n;
        }
        Logger.getGlobalLogger().error(Messages.LogUtil_Failed_To_Create_Log_File, dir, prefix, ext);
        return null;
    }

    private static void incr(StringBuffer sb, int baseLen) {
        int length = sb.length();
        if (length == baseLen) {
            sb.append('a');
            return;
        }
        char last = sb.charAt(length - 1);
        sb.setLength(length - 1);
        if (last != 'z') {
            sb.append((char)(last + '\u0001'));
        } else {
            LogUtil.incr(sb, baseLen);
            sb.append('a');
        }
    }

    public static void appendObject(StringBuffer sb, int indent, Object obj) {
        if (obj == null) {
            LogUtil.appendIndent(sb, indent);
            sb.append("null");
        } else if (obj instanceof Object[]) {
            LogUtil.appendIndent(sb, indent);
            Object[] array = (Object[])obj;
            sb.append('[');
            Object[] objectArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                LogUtil.appendObject(sb, 0, element);
                sb.append(',');
                ++n2;
            }
            if (array.length == 0) {
                sb.append(' ');
            } else {
                sb.setLength(sb.length() - 1);
            }
            sb.append(']');
        } else if (obj instanceof IStatus) {
            LogUtil.appendStatus(sb, indent, (IStatus)obj);
        } else if (obj instanceof Throwable) {
            LogUtil.appendStackTrace(sb, indent, (Throwable)obj);
        } else {
            LogUtil.appendIndent(sb, indent);
            try {
                if (obj instanceof String) {
                    sb.append(LogUtil.replaceBadCharacters((String)obj));
                } else {
                    sb.append(obj);
                }
            }
            catch (Throwable t) {
                sb.append(Messages.Util_Unexpected_Exception_In_ToString).append(NEWLINE);
                LogUtil.appendObject(sb, indent + 1, t);
            }
        }
    }

    private static void appendStackTrace(StringBuffer sb, int indent, Throwable e) {
        LogUtil.appendStackTrace(4, sb, indent, e);
    }

    public static void appendStackTrace(int limit, StringBuffer sb, int indent, Throwable e) {
        StackTraceElement[] stack = e.getStackTrace();
        int length = stack.length;
        if (limit > 0 && limit < length) {
            length = limit;
        }
        LogUtil.appendIndent(sb, indent);
        sb.append(e);
        int i = 0;
        while (i < length) {
            StackTraceElement s = stack[i];
            sb.append(NEWLINE);
            LogUtil.appendIndent(sb, indent + 1);
            sb.append("at ").append(s);
            ++i;
        }
        if (length < stack.length) {
            sb.append(NEWLINE);
            LogUtil.appendIndent(sb, indent + 1);
            sb.append("...");
        }
    }

    public static StackTraceElement getCaller(Logger logger) {
        StackTraceElement[] stack = new Throwable().getStackTrace();
        int i = 0;
        while (i < stack.length) {
            if (logger.isLogger(stack[i])) break;
            ++i;
        }
        while (i < stack.length) {
            String methodName;
            if (!(logger.isLogger(stack[i]) || (methodName = stack[i].getMethodName()).startsWith("log") || methodName.startsWith("access$"))) {
                return stack[i];
            }
            ++i;
        }
        return null;
    }

    static boolean isLogger(String className) {
        return className.startsWith(PACKAGE) || className.startsWith(RUNTIME) || className.startsWith(COMMON_CORE_TRACE_PACKAGE) && className.endsWith("Trace");
    }

    public static String toISO8601(long millis) {
        StringBuffer sb = new StringBuffer(20);
        LogUtil.appendISO8601(sb, millis);
        return sb.toString();
    }

    public static void appendISO8601(StringBuffer sb, long millis) {
        LogUtil.appendDate(sb, millis);
        sb.append('T');
        LogUtil.appendTime(sb, millis);
        LogUtil.appendTimeZone(sb, millis);
    }

    public static void appendDate(StringBuffer sb, long millis) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(millis);
        sb.append(calendar.get(1)).append('-');
        LogUtil.appendInt2(sb, calendar.get(2) + 1).append('-');
        LogUtil.appendInt2(sb, calendar.get(5));
    }

    public static void appendTime(StringBuffer sb, long millis) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(millis);
        LogUtil.appendInt2(sb, calendar.get(11)).append(':');
        LogUtil.appendInt2(sb, calendar.get(12)).append(':');
        LogUtil.appendInt2(sb, calendar.get(13));
    }

    public static void appendTimeZone(StringBuffer sb, long millis) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(millis);
        int offset = calendar.getTimeZone().getOffset(millis) / 1000 / 60;
        if (offset >= 0) {
            sb.append('+');
        } else {
            sb.append('-');
            offset = -offset;
        }
        LogUtil.appendInt2(sb, offset / 60).append(':');
        LogUtil.appendInt2(sb, offset % 60);
    }

    public static void appendDateTime(StringBuffer sb, long millis) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(millis);
        sb.append(calendar.get(1));
        LogUtil.appendInt2(sb, calendar.get(2) + 1);
        LogUtil.appendInt2(sb, calendar.get(5));
        sb.append('_');
        LogUtil.appendInt2(sb, calendar.get(11));
        LogUtil.appendInt2(sb, calendar.get(12));
    }

    public static String toElapsedTime(long millis) {
        StringBuffer sb = new StringBuffer(10);
        LogUtil.appendElapsed(sb, millis);
        return sb.toString();
    }

    public static void appendElapsed(StringBuffer sb, long millis) {
        long x = millis / 10L;
        int cs = (int)(x % 100L);
        int sec = (int)((x /= 100L) % 60L);
        int min = (int)((x /= 60L) % 60L);
        int hr = (int)((x /= 60L) % 24L);
        int day = (int)(x /= 24L);
        if (day != 0) {
            sb.append(day).append('-');
        }
        if (hr != 0 || day != 0) {
            LogUtil.appendInt2(sb, hr).append(':');
        }
        LogUtil.appendInt2(sb, min).append(':');
        LogUtil.appendInt2(sb, sec).append('.');
        LogUtil.appendInt2(sb, cs);
    }

    private static StringBuffer appendInt2(StringBuffer sb, int i) {
        if (i < 10) {
            sb.append('0');
        }
        sb.append(i);
        return sb;
    }

    private static String getNewLine() {
        try {
            return AccessController.doPrivileged(new GetPropertyAction("line.separator"));
        }
        catch (Throwable t) {
            ExceptionUtil.debugLogToReview(t);
            return "\n";
        }
    }

    public static String toString(IStatus status) {
        StringBuffer sb = new StringBuffer(256);
        LogUtil.appendStatus(sb, 0, status);
        return sb.toString();
    }

    private static void appendStatus(StringBuffer sb, int indent, IStatus status) {
        IStatus[] children;
        String message = status.getMessage();
        if (message != null && message.length() > 0) {
            LogUtil.appendIndent(sb, indent);
            sb.append(message);
            sb.append(NEWLINE);
            ++indent;
        }
        if (status.getException() != null) {
            LogUtil.appendIndent(sb, indent);
            sb.append(status.getException());
            sb.append(NEWLINE);
            ++indent;
        }
        IStatus[] iStatusArray = children = status.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus element = iStatusArray[n2];
            LogUtil.appendStatus(sb, indent, element);
            sb.append(NEWLINE);
            ++n2;
        }
        if (sb.length() > 0) {
            LogUtil.stripOffTrailingNewLine(sb);
        } else {
            LogUtil.appendIndent(sb, indent);
            sb.append(status.toString());
        }
    }

    private static void appendIndent(StringBuffer sb, int indent) {
        int i = 0;
        while (i < indent) {
            sb.append(INDENT);
            ++i;
        }
    }

    public static void stripOffTrailingNewLine(StringBuffer sb) {
        if (sb.lastIndexOf(NEWLINE) == sb.length() - NEWLINE.length()) {
            sb.setLength(sb.length() - NEWLINE.length());
        }
    }

    public static String stripOffTrailingNewLine(String s) {
        if (s.endsWith(NEWLINE)) {
            int endIndex = s.length() - NEWLINE.length();
            return s.substring(0, endIndex);
        }
        return s;
    }

    public static String replaceBadCharacters(String s) {
        StringBuffer sb = null;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c < ' ' && c != '\n' && c != '\r' && c != '\t') {
                if (sb == null) {
                    sb = new StringBuffer(s.length() * 11 / 10);
                    sb.append(s.substring(0, i));
                }
                sb.append("&#").append((int)c).append(';');
            } else if (sb != null) {
                sb.append(c);
            }
            ++i;
        }
        return sb == null ? s : sb.toString();
    }

    public static String escape(String x) {
        return x.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    public static String indent(String string) {
        return LogUtil.indent(string, INDENT);
    }

    public static String indent(String string, String indent) {
        if (indent == null || indent.length() == 0) {
            return string;
        }
        return string.replaceAll("(?m)^", indent);
    }
}

