/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.downloads.handlerImpl;

import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.internal.downloads.DownloadUnexpectedTotalSizeException;
import com.ibm.cic.common.core.internal.downloads.Messages;
import com.ibm.cic.common.core.internal.utils.CicCommonCoreDateTrace;
import com.ibm.cic.common.core.internal.utils.CicCommonCoreDebugOptions;
import com.ibm.cic.common.core.internal.utils.CicCommonCorePluginTrace;
import com.ibm.cic.common.core.internal.utils.CicCommonCoreTrace;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.UserOptions;
import com.ibm.cic.common.downloads.ByteRange;
import com.ibm.cic.common.downloads.DownloadHandler;
import com.ibm.cic.common.downloads.DownloadHandlerRequest;
import com.ibm.cic.common.downloads.DownloadTrace;
import com.ibm.cic.common.downloads.ICanOpenStreamAtRange;
import com.ibm.cic.common.downloads.IContentInfo;
import com.ibm.cic.common.downloads.IDownloadSink;
import com.ibm.cic.common.downloads.IDownloadStream;
import com.ibm.cic.common.downloads.IHasIsCanceled;
import com.ibm.cic.common.downloads.ITransferMonitor;
import com.ibm.cic.common.downloads.SimpleContentInfo;
import com.ibm.cic.common.downloads.TransferMonitor;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.UnknownHostException;

public class DownloadHandlerUtil {
    public static final Logger dlTrace = DownloadTrace.traceIssues.getLog();
    public static final CicCommonCoreDateTrace dlTraceHappy = DownloadTrace.traceHappy;
    public static final CicCommonCoreDateTrace traceHeartBeat = DownloadTrace.traceHeartBeat;
    public static final CicCommonCorePluginTrace pluginTrace = ComIbmCicCommonCorePlugin.getTrace();
    public static final CicCommonCoreTrace traceProxySettings = DownloadTrace.traceProxySettings;
    public static final CicCommonCoreTrace debugProgress = new CicCommonCoreTrace(ComIbmCicCommonCorePlugin.getDefault(), CicCommonCoreDebugOptions.DEBUG_PROGRESS_DOWNLOAD);

    public static void rethrowExpectedException(IOException e) throws FileNotFoundException, UnknownHostException {
        DownloadHandlerUtil.rethrowExpectedException(null, e, false);
    }

    public static void rethrowExpectedException(String urlString, IOException e, boolean log) throws FileNotFoundException, UnknownHostException {
        if (e instanceof FileNotFoundException) {
            if (log) {
                dlTraceHappy.println("NOT FOUND: Resource {0}: {1}", urlString, e.getMessage());
            }
            throw (FileNotFoundException)e;
        }
        if (e instanceof UnknownHostException) {
            if (log) {
                dlTraceHappy.println("HOST UNKNOWN: Resource {0}: {1}", urlString, e.getMessage());
            }
            throw (UnknownHostException)e;
        }
    }

    public static void rethrowOpenStreamException(IOException e) throws IOException {
        DownloadHandlerUtil.rethrowOpenStreamException(null, e, false);
    }

    public static void rethrowExistsException(IOException e) throws IOException {
        DownloadHandlerUtil.rethrowOpenStreamException(null, e, false);
    }

    private static void rethrowOpenStreamException(String urlString, IOException e, boolean log) throws IOException {
        DownloadHandlerUtil.rethrowExpectedException(e);
        throw e;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isSize(ICanOpenStreamAtRange canOpenStreamAtRange, DownloadHandlerRequest.DownloadSinkRequest dlr, String urlString, long size) throws IOException {
        ByteRange range = ByteRange.remainingRange(size - 1L, size);
        DownloadHandlerRequest.OpenStreamForRangeRequest openAtRequest = DownloadHandlerRequest.FACTORY.createOpenStreamForRange(dlr.getDownloadContext(), urlString, range);
        openAtRequest.setParentRequest(dlr);
        IHasIsCanceled cancelMonitor = DownloadHandler.getCancelMonitor(dlr);
        TransferMonitor transferPerformance = new TransferMonitor(cancelMonitor);
        IContentInfo[] outOpenStreamContentInfo = new IContentInfo[1];
        IDownloadStream dlStream = canOpenStreamAtRange.openStreamAtRange(openAtRequest, transferPerformance, outOpenStreamContentInfo);
        InputStream is = dlStream.getInputStream();
        try {
            int rc = is.read();
            if (rc == -1) {
                return false;
            }
            rc = is.read();
            if (rc == -1) return true;
            return false;
        }
        finally {
            FileUtil.close(is);
        }
    }

    private static boolean isStartEOF(ICanOpenStreamAtRange canOpenStreamAtRange, DownloadHandlerRequest.DownloadSinkRequest dlr, String urlString, ByteRange range, long actualSize) throws IOException {
        if (range.getEnd() == -1L || range.isEofRange()) {
            if (actualSize == range.getStart()) {
                return true;
            }
            if (actualSize == -1L) {
                return DownloadHandlerUtil.isSize(canOpenStreamAtRange, dlr, urlString, range.getStart());
            }
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    public static IContentInfo downloadUsingOpenStreamAtRange(ICanOpenStreamAtRange canOpenStreamAtRange, DownloadHandlerRequest.DownloadSinkRequest dlr, ITransferMonitor transferPerformance, long[] outBytesRead) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[CATCHBLOCK], 0[TRYBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void verifyExpectedSizeNotLessThanSize(String urlString, long expectedSize, long alreadyDownloadSize) throws DownloadUnexpectedTotalSizeException {
        if (expectedSize != -1L && alreadyDownloadSize != -1L && expectedSize < alreadyDownloadSize) {
            String msg = NLS.bind(Messages.DownloadHandlerUtil_moreBytesDownloadedThanExpected, urlString, alreadyDownloadSize, expectedSize);
            throw new DownloadUnexpectedTotalSizeException(msg, -1L, null);
        }
    }

    public static IContentInfo downloadUsingOpenStreamAtRange(ICanOpenStreamAtRange canOpenStreamAtRange, DownloadHandlerRequest.DownloadRequest dlr, ITransferMonitor transferPerformance, long[] outBytesRead) throws IOException {
        DownloadHandlerRequest.DownloadSinkRequest downloadSinkRequest = DownloadHandlerRequest.FACTORY.createDownloadSinkRequest(dlr.getDownloadContext(), dlr.getUrlString(), new FileDownloadSink(new File(dlr.getDestination())), dlr.getExpectedSize());
        downloadSinkRequest.setParentRequest(dlr);
        return DownloadHandlerUtil.downloadUsingOpenStreamAtRange(canOpenStreamAtRange, downloadSinkRequest, transferPerformance, outBytesRead);
    }

    private static IContentInfo returnDestinationContentInfo(String urlString, IDownloadSink downloadSink) {
        SimpleContentInfo ci = new SimpleContentInfo();
        ci.setSize(downloadSink.getLength());
        dlTraceHappy.getLog().debug("SUCCESS: Downloaded {0} to {1}", urlString, downloadSink);
        return ci;
    }

    private static void deleteFileForRetryWithoutRange(IDownloadSink downloadSink) throws IOException {
        try {
            downloadSink.delete();
        }
        catch (IOException e) {
            dlTrace.debug("Failed to delete destination {0} for retry download with full range after range request failed. {1}", downloadSink, e);
            throw e;
        }
        dlTrace.debug(".. deleted destination {0} and retry without range", downloadSink.toString());
    }

    private static IDownloadStream getFullRangeDownloadStream(ICanOpenStreamAtRange canOpenStreamAtRange, DownloadHandlerRequest.DownloadSinkRequest dlr, ITransferMonitor transferPerformance, String urlString, IContentInfo[] outOpenStreamContentInfo) throws IOException {
        ByteRange range = dlr.getExpectedSize() == -1L ? ByteRange.RANGE_ALL_BYTES : ByteRange.remainingRange(0L, dlr.getExpectedSize());
        DownloadHandlerRequest.OpenStreamForRangeRequest openAtRequest = DownloadHandlerRequest.FACTORY.createOpenStreamForRange(dlr.getDownloadContext(), urlString, range);
        openAtRequest.setParentRequest(dlr);
        IDownloadStream dlStream = canOpenStreamAtRange.openStreamAtRange(openAtRequest, transferPerformance, outOpenStreamContentInfo);
        return dlStream;
    }

    public static class FileDownloadSink
    implements IDownloadSink {
        private final File file;

        public FileDownloadSink(File file) {
            this.file = file;
        }

        @Override
        public long getLength() {
            return this.file.length();
        }

        @Override
        public void delete() throws IOException {
            if (!this.file.delete()) {
                throw new IOException(NLS.bind(Messages.DownloadHandlerUtil_failedToDeleteInProgressFile, (Object)this.file));
            }
        }

        @Override
        public String toString() {
            return this.file.toString();
        }

        private OutputStream openStream(boolean forceOverwrite) throws IOException {
            try {
                boolean append;
                if (!this.file.exists()) {
                    this.file.getParentFile().mkdirs();
                }
                boolean bl = append = forceOverwrite ? false : this.file.exists();
                if (UserOptions.getDownloadSyncOnClose()) {
                    return new FileUtil.SyncOnCloseFileOutputStream(this.file.getAbsolutePath(), append);
                }
                return new FileUtil.NoFinalizeCloseFileOutputStream(this.file.getAbsolutePath(), append);
            }
            catch (FileNotFoundException e) {
                IOException ioe = new IOException(NLS.bind(Messages.DownloadHandlerUtil_openFileOutputStreamFailed, (Object)this.file, (Object)e));
                ioe.initCause(e);
                throw ioe;
            }
        }

        @Override
        public OutputStream openContinuationStream() throws IOException {
            return this.openStream(false);
        }

        @Override
        public OutputStream openOverwriteStream() throws IOException {
            return this.openStream(true);
        }
    }
}

