/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.downloads;

import com.ibm.cic.common.core.internal.preferences.ProxyPreferenceInternalUtil;
import com.ibm.cic.common.core.preferences.ICicPreferenceConstants;
import com.ibm.cic.common.core.preferences.PreferenceUtil;
import com.ibm.cic.common.core.preferences.ProxyPreferenceUtil;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.downloads.Messages;
import com.ibm.cic.common.downloads.ProxyInfo;
import com.ibm.cic.common.logging.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.osgi.util.NLS;

public class PreferencesHolder {
    private static final Logger log = Logger.getLogger(PreferencesHolder.class);
    private final List preferences = Collections.synchronizedList(new ArrayList());
    public static final PreferencesHolder INSTANCE = new PreferencesHolder();

    private PreferencesHolder() {
    }

    public IStatus checkValidPreferenceValue(String key, String value) {
        assert (value != null);
        IStatus result = Status.OK_STATUS;
        if (PreferenceUtil.isKey(key, ICicPreferenceConstants.CONNECT_TIMEOUT)) {
            result = PreferenceUtil.checkInteger(key, value);
            return result;
        }
        if (PreferenceUtil.isKey(key, ICicPreferenceConstants.READ_TIMEOUT)) {
            result = PreferenceUtil.checkInteger(key, value);
            return result;
        }
        if (PreferenceUtil.isKey(key, ICicPreferenceConstants.SSL_NONSECURE_MODE)) {
            result = PreferenceUtil.checkBoolean(key, value);
            return result;
        }
        if (PreferenceUtil.isKey(key, ICicPreferenceConstants.DOWNLOAD_AUTO_RETRY_COUNT)) {
            result = PreferenceUtil.checkInteger(key, value);
            return result;
        }
        if (PreferenceUtil.isKey(key, ICicPreferenceConstants.HTTP_DISABLE_PREEMPTIVE_AUTHENTICATION)) {
            result = PreferenceUtil.checkBoolean(key, value);
            return result;
        }
        if (PreferenceUtil.isKey(key, ICicPreferenceConstants.HTTP_ENABLE_GZIP_ACCEPT_ENCODING)) {
            result = PreferenceUtil.checkBoolean(key, value);
            return result;
        }
        result = ProxyPreferenceUtil.INSTANCE.checkValidPreferenceValue(key, value);
        return result;
    }

    public ProxyInfo getProxyInfo(IEclipsePreferences prefs, String targetProtocol) {
        ProxyPreferenceUtil pu = ProxyPreferenceUtil.INSTANCE;
        ProxyPreferenceUtil.ProxyForProtocol proxy = pu.getActiveProxy(prefs, targetProtocol);
        if (proxy == null) {
            return null;
        }
        if (proxy.getProxyProtocol().equals("NO_PROXY")) {
            return ProxyInfo.NO_PROXY;
        }
        String host = proxy.getProxyServer().getHost();
        String strPort = proxy.getProxyServer().getPort();
        ProxyPreferenceInternalUtil.ProxyTags proxyTags = (ProxyPreferenceInternalUtil.ProxyTags)proxy.getTags();
        int port = this.convertStringToInt(proxyTags.getPortTag(), strPort, -1);
        boolean useSocks = proxy.getProxyProtocol().equals("SOCKS");
        ProxyInfo proxyInfo = new ProxyInfo();
        proxyInfo.setHost(host);
        proxyInfo.setPort(port);
        proxyInfo.setUseSocks(useSocks);
        return proxyInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProxyInfo getProxyInfo(Collection listPrefs, String targetProtocol) {
        if (listPrefs != null) {
            Collection collection = listPrefs;
            synchronized (collection) {
                for (IEclipsePreferences prefs : listPrefs) {
                    ProxyInfo proxyInfo = this.getProxyInfo(prefs, targetProtocol);
                    if (proxyInfo == null) continue;
                    return proxyInfo;
                }
            }
        }
        return ProxyInfo.NO_PROXY;
    }

    public ProxyInfo getProxyInfo(String targetProtocol) {
        return this.getProxyInfo(this.preferences, targetProtocol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getValue(ICicPreferenceConstants.PreferenceTag tag, String def) {
        if (this.preferences == null) {
            return def;
        }
        List list = this.preferences;
        synchronized (list) {
            for (IEclipsePreferences prefs : this.preferences) {
                String value = prefs.get(tag.key(), null);
                if (value == null) continue;
                return value;
            }
        }
        return def;
    }

    public int getIntegerValue(ICicPreferenceConstants.PreferenceTag tag, int def) {
        String timeout = this.getValue(tag, Integer.toString(def));
        return this.convertStringToInt(tag, timeout, def);
    }

    private int convertStringToInt(ICicPreferenceConstants.PreferenceTag tag, String str, int def) {
        try {
            int ntimeout = Integer.parseInt(str);
            return ntimeout;
        }
        catch (NumberFormatException e) {
            String msg = NLS.bind((String)Messages.PreferencesHolder_format_exception, (Object)tag.label(), (Object)Integer.toString(def));
            ICicStatus status = Statuses.ERROR.get(6200, e, msg, new Object[0]);
            log.statusNotOK(status);
            return def;
        }
    }

    public boolean getBooleanValue(ICicPreferenceConstants.PreferenceTag tag, boolean def) {
        return Boolean.valueOf(this.getValue(tag, Boolean.toString(def)));
    }

    public int getConnectTimeout() {
        return this.getIntegerValue(ICicPreferenceConstants.CONNECT_TIMEOUT, 30);
    }

    public int getReadTimeout() {
        return this.getIntegerValue(ICicPreferenceConstants.READ_TIMEOUT, 45);
    }

    public boolean isSSLNonsecureMode() {
        return this.getBooleanValue(ICicPreferenceConstants.SSL_NONSECURE_MODE, false);
    }

    public int getDownloadAutoRetryCount() {
        return this.getIntegerValue(ICicPreferenceConstants.DOWNLOAD_AUTO_RETRY_COUNT, 0);
    }

    public boolean isHttpPreemptiveAuthenticationDisabled() {
        return this.getBooleanValue(ICicPreferenceConstants.HTTP_DISABLE_PREEMPTIVE_AUTHENTICATION, false);
    }

    public boolean isGzipAcceptEncodingEnabled() {
        return this.getBooleanValue(ICicPreferenceConstants.HTTP_ENABLE_GZIP_ACCEPT_ENCODING, false);
    }

    public boolean add(IEclipsePreferences prefs) {
        return this.preferences.add(prefs);
    }

    public boolean remove(IEclipsePreferences prefs) {
        return this.preferences.remove(prefs);
    }
}

