/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.downloads;

import com.ibm.cic.common.core.internal.downloads.ReceiverFactory;
import com.ibm.cic.common.downloads.DownloadHandlerRequest;

public interface IDownloadListener {
    public void enter(DownloadHandlerRequest var1);

    public void exit(DownloadHandlerRequest var1, Object var2);

    public void receivedUnauthorizedResponse(Access var1);

    public void beforeSendRequest(Access var1);

    public void sendRequestCanceled(Access var1);

    public void sendRequestException(Access var1, Exception var2);

    public void receivedResponse(Access var1, Object var2);

    public void openReadingStream(Access var1);

    public void closeReadingStream(Access var1);

    public void startReadingStream(Access var1);

    public void endReadingStream(Access var1);

    public static class Access {
        private final DownloadHandlerRequest request;
        private IReceiver receiver;

        public Access(DownloadHandlerRequest request, IReceiver receiver) {
            this.request = request;
            this.receiver = receiver;
        }

        public Access(DownloadHandlerRequest request) {
            this.request = request;
            this.receiver = IReceiverFactory.INSTANCE.createBasicReceiver(request.getUrlString());
        }

        public DownloadHandlerRequest getRequest() {
            return this.request;
        }

        public IReceiver getReceiver() {
            return this.receiver;
        }

        public void setReceiver(IReceiver receiver) {
            this.receiver = receiver;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.request);
            sb.append(" receiver=");
            sb.append(this.receiver);
            return sb.toString();
        }
    }

    public static interface IHostReceiver
    extends IReceiver {
        @Override
        public String getURLString();

        public String getProtocol();

        public String getHost();

        public int getPort();
    }

    public static interface IReceiver {
        public String getURLString();
    }

    public static interface IReceiverFactory {
        public static final IReceiverFactory INSTANCE = new ReceiverFactory();

        public IReceiver createBasicReceiver(String var1);

        public IHostReceiver createHostReceiver(String var1, String var2, String var3, int var4);
    }
}

