/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.downloads;

import com.ibm.cic.common.core.internal.downloads.Messages;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.downloads.ByteRange;
import com.ibm.cic.common.downloads.IDownloadContext;
import com.ibm.cic.common.downloads.IDownloadSink;

public abstract class DownloadHandlerRequest {
    public static final Factory FACTORY = new Factory(){

        @Override
        public ExistsRequest createExistsRequest(IDownloadContext ctxt, String urlString) {
            return new ExistsRequest(ctxt, urlString);
        }

        @Override
        public OpenStreamRequest createOpenStreamRequest(IDownloadContext ctxt, String urlString) {
            return new OpenStreamRequest(ctxt, urlString);
        }

        @Override
        public OpenStreamForRangeRequest createOpenStreamForRange(IDownloadContext ctxt, String urlString, ByteRange byteRange) {
            return new OpenStreamForRangeRequest(ctxt, urlString, byteRange);
        }

        @Override
        public DownloadRequest createDownloadRequest(IDownloadContext ctxt, String urlString, String destination, long expectedSize) {
            return new DownloadRequest(ctxt, urlString, destination, expectedSize);
        }

        @Override
        public DownloadSinkRequest createDownloadSinkRequest(IDownloadContext ctxt, String urlString, IDownloadSink downloadSink, long expectedSize) {
            return new DownloadSinkRequest(ctxt, urlString, downloadSink, expectedSize);
        }

        @Override
        public QueryContentInfoRequest createQueryContentInfoRequest(IDownloadContext ctxt, String urlString) {
            return new QueryContentInfoRequest(ctxt, urlString);
        }
    };
    private DownloadHandlerRequest parentRequest;
    private final String urlString;
    private final IDownloadContext ctxt;

    protected DownloadHandlerRequest(IDownloadContext ctxt, String urlString) {
        assert (ctxt != null);
        this.parentRequest = null;
        this.ctxt = ctxt;
        this.urlString = urlString;
    }

    public void setParentRequest(DownloadHandlerRequest context) {
        this.parentRequest = context;
    }

    public DownloadHandlerRequest getParentRequest() {
        return this.parentRequest;
    }

    public IDownloadContext getDownloadContext() {
        return this.ctxt;
    }

    public boolean isRootRequest() {
        return this.parentRequest == null;
    }

    public DownloadHandlerRequest getRootRequest() {
        DownloadHandlerRequest rootContext = this.parentRequest != null ? (this.parentRequest.getParentRequest() != null ? this.parentRequest.getRootRequest() : this.parentRequest) : this;
        return rootContext;
    }

    public String getUrlString() {
        return this.urlString;
    }

    public abstract String getLocalizedRequest();

    public static final class DownloadRequest
    extends DownloadHandlerRequest {
        private final String destination;
        private final long expectedSize;

        protected DownloadRequest(IDownloadContext ctxt, String urlString, String destination, long expectedSize) {
            super(ctxt, urlString);
            assert (expectedSize == -1L || expectedSize >= 0L);
            this.destination = destination;
            this.expectedSize = expectedSize;
        }

        public String getDestination() {
            return this.destination;
        }

        public long getExpectedSize() {
            return this.expectedSize;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("download:");
            sb.append(this.getUrlString());
            sb.append(" to '");
            sb.append(this.destination);
            sb.append("'");
            sb.append(" expectedSize='");
            if (this.expectedSize == -1L) {
                sb.append("UNKNOWN");
            } else {
                sb.append(this.expectedSize);
            }
            sb.append("'");
            return sb.toString();
        }

        @Override
        public String getLocalizedRequest() {
            if (this.expectedSize == -1L) {
                return NLS.bind(Messages.DownloadHandlerRequest_Download, (Object)this.getUrlString(), (Object)this.destination);
            }
            return NLS.bind(Messages.DownloadHandlerRequest_DownloadWithSize, this.getUrlString(), this.destination, this.expectedSize);
        }
    }

    public static final class DownloadSinkRequest
    extends DownloadHandlerRequest {
        private final IDownloadSink downloadSink;
        private final long expectedSize;

        protected DownloadSinkRequest(IDownloadContext ctxt, String urlString, IDownloadSink downloadSink, long expectedSize) {
            super(ctxt, urlString);
            assert (expectedSize == -1L || expectedSize >= 0L);
            this.downloadSink = downloadSink;
            this.expectedSize = expectedSize;
        }

        public IDownloadSink getDownloadSink() {
            return this.downloadSink;
        }

        public long getExpectedSize() {
            return this.expectedSize;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("download:");
            sb.append(this.getUrlString());
            sb.append(" to '");
            sb.append(this.downloadSink);
            sb.append("'");
            sb.append(" expectedSize='");
            if (this.expectedSize == -1L) {
                sb.append("UNKNOWN");
            } else {
                sb.append(this.expectedSize);
            }
            sb.append("'");
            return sb.toString();
        }

        @Override
        public String getLocalizedRequest() {
            return this.toString();
        }
    }

    public static final class ExistsRequest
    extends DownloadHandlerRequest {
        protected ExistsRequest(IDownloadContext ctxt, String urlString) {
            super(ctxt, urlString);
        }

        public String toString() {
            return "exists:" + this.getUrlString();
        }

        @Override
        public String getLocalizedRequest() {
            return NLS.bind(Messages.DownloadHandlerRequest_Exists, (Object)this.getUrlString());
        }
    }

    public static interface Factory {
        public ExistsRequest createExistsRequest(IDownloadContext var1, String var2);

        public OpenStreamRequest createOpenStreamRequest(IDownloadContext var1, String var2);

        public OpenStreamForRangeRequest createOpenStreamForRange(IDownloadContext var1, String var2, ByteRange var3);

        public DownloadRequest createDownloadRequest(IDownloadContext var1, String var2, String var3, long var4);

        public DownloadSinkRequest createDownloadSinkRequest(IDownloadContext var1, String var2, IDownloadSink var3, long var4);

        public QueryContentInfoRequest createQueryContentInfoRequest(IDownloadContext var1, String var2);
    }

    public static final class OpenStreamForRangeRequest
    extends DownloadHandlerRequest {
        private final ByteRange byteRange;

        protected OpenStreamForRangeRequest(IDownloadContext ctxt, String urlString, ByteRange byteRange) {
            super(ctxt, urlString);
            if (byteRange == null) {
                throw new NullPointerException();
            }
            this.byteRange = byteRange;
        }

        public ByteRange getByteRange() {
            return this.byteRange;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("open:");
            sb.append(this.getUrlString());
            sb.append(" ");
            sb.append(this.byteRange);
            return sb.toString();
        }

        @Override
        public String getLocalizedRequest() {
            return NLS.bind(Messages.DownloadHandlerRequest_OpenStreamForRange, (Object)this.getUrlString(), (Object)this.byteRange);
        }
    }

    public static final class OpenStreamRequest
    extends DownloadHandlerRequest {
        protected OpenStreamRequest(IDownloadContext ctxt, String urlString) {
            super(ctxt, urlString);
        }

        public String toString() {
            return "open:" + this.getUrlString();
        }

        @Override
        public String getLocalizedRequest() {
            return NLS.bind(Messages.DownloadHandlerRequest_OpenStream, (Object)this.getUrlString());
        }
    }

    public static final class QueryContentInfoRequest
    extends DownloadHandlerRequest {
        protected QueryContentInfoRequest(IDownloadContext ctxt, String urlString) {
            super(ctxt, urlString);
        }

        public String toString() {
            return "queryContentInfo:" + this.getUrlString();
        }

        @Override
        public String getLocalizedRequest() {
            return NLS.bind(Messages.DownloadHandlerRequest_QueryContentInfo, (Object)this.getUrlString());
        }
    }
}

