/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.downloads;

import com.ibm.cic.common.core.artifactrepo.impl.ContentInfoComputation;
import com.ibm.cic.common.downloads.DigestValue;
import com.ibm.cic.common.downloads.IContentInfo;
import java.util.List;

public class DigestUtil {
    private static final String hexDigits = "0123456789abcdef";

    public static String bytesToHexString(byte[] digest) {
        char[] ca = new char[digest.length * 2];
        int i = 0;
        while (i < digest.length) {
            String hexStr = Integer.toHexString(0xFF & digest[i]);
            if (hexStr.length() < 2) {
                ca[2 * i] = 48;
                ca[2 * i + 1] = hexStr.charAt(0);
            } else {
                ca[2 * i] = hexStr.charAt(0);
                ca[2 * i + 1] = hexStr.charAt(1);
            }
            ++i;
        }
        return new String(ca);
    }

    private static int hexDigitValueThrows(char c) {
        int val = hexDigits.indexOf(c);
        if (val == -1) {
            throw new IllegalArgumentException();
        }
        return val;
    }

    public static byte[] hexStringToBytes(String hexString) {
        int hsLen = hexString.length();
        if ((hsLen & 1) == 1) {
            throw new IllegalArgumentException();
        }
        byte[] ba = new byte[hsLen / 2];
        int i = 0;
        while (i < ba.length) {
            char c1 = hexString.charAt(2 * i);
            char c0 = hexString.charAt(2 * i + 1);
            int v1 = DigestUtil.hexDigitValueThrows(c1);
            int v0 = DigestUtil.hexDigitValueThrows(c0);
            int v = v1 << 4 | v0;
            ba[i] = (byte)v;
            ++i;
        }
        return ba;
    }

    private static String getAlgorithmToUse(IContentInfo contentInfo) {
        String[] preferred;
        if (contentInfo == null) {
            return null;
        }
        List<String> algorithms = contentInfo.getDigestAlgorithms();
        if (algorithms.isEmpty()) {
            return null;
        }
        String[] stringArray = preferred = ContentInfoComputation.getPreferredAlgorithms();
        int n = preferred.length;
        int n2 = 0;
        while (n2 < n) {
            String prefAlg = stringArray[n2];
            int j = 0;
            while (j < algorithms.size()) {
                String alg = algorithms.get(j);
                if (alg.equalsIgnoreCase(prefAlg)) {
                    return alg;
                }
                ++j;
            }
            ++n2;
        }
        if (algorithms.size() > 0) {
            return algorithms.get(0);
        }
        return null;
    }

    public static DigestValue getDigestValueToUse(IContentInfo contentInfo) {
        String algorithm = DigestUtil.getAlgorithmToUse(contentInfo);
        if (algorithm == null) {
            return null;
        }
        DigestValue dv = contentInfo.getDigestValue(algorithm);
        return dv;
    }
}

