/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.downloads;

import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.downloads.AuthenticationSchemeUtil;
import com.ibm.cic.common.downloads.CredentialInfo;
import com.ibm.cic.common.downloads.CredentialRequested;
import com.ibm.cic.common.downloads.ICredentialPrompter;
import com.ibm.cic.common.downloads.Messages;

public class CredentialPrompter {
    public static final CredentialPrompter INSTANCE = new CredentialPrompter();
    private static final String DIALOG_MESSAGE_TOKEN = "@DLG@";
    private static final String IBM_MESSAGE_TOKEN = "@IBM@";
    private static final String FORGOT_ID_MESSAGE = "Forgot your IBM ID?";
    private static final String FORGOT_PASSWORD_MESSAGE = "Forgot your password?";
    private static final String IBM_ID_AND_FAQ_MESSAGE = "IBM ID help and FAQ";
    private ICredentialPrompter prompter = null;

    private CredentialPrompter() {
    }

    public ICredentialPrompter getPrompter() {
        return this.prompter;
    }

    public void setPrompter(ICredentialPrompter prompter) {
        this.prompter = prompter;
    }

    public String createConnectMessage(CredentialRequested requested, CredentialInfo previousInfo) {
        String key = null;
        boolean proxy = requested.isProxy();
        String location = requested.getLocation();
        boolean isRetryAttempt = previousInfo.isSomething();
        if (proxy) {
            key = isRetryAttempt ? Messages.CredentialPrompter_ask_proxy_credentials_retry : Messages.CredentialPrompter_ask_proxy_credentials;
        } else {
            if (AuthenticationSchemeUtil.isFTPScheme(requested.getScheme())) {
                if (isRetryAttempt) {
                    if (previousInfo.isAutoGenerated()) {
                        return NLS.bind(Messages.CredentialPrompter_ask_credentials_retry_ftp_automatic, previousInfo.getUid(), previousInfo.getPwd(), requested.getRealm());
                    }
                    return NLS.bind(Messages.CredentialPrompter_ask_credentials_retry_ftp, (Object)requested.getRealm());
                }
                return requested.getRealm();
            }
            if (this.isIbmDownloadSite(requested.getRealm())) {
                key = isRetryAttempt ? Messages.CredentialPrompter_ask_credentials_retry_for_ibm : Messages.CredentialPrompter_ask_credentials_for_ibm;
                return NLS.bind(key, (Object)location, (Object)this.getLocalizedRealm(requested.getRealm()));
            }
            key = isRetryAttempt ? Messages.CredentialPrompter_ask_credentials_retry : Messages.CredentialPrompter_ask_credentials;
        }
        return NLS.bind(key, (Object)requested.getHost(), (Object)requested.getRealm());
    }

    private String getLocalizedRealm(String realm) {
        String msg = this.localizeMainMessage(realm);
        if (realm.indexOf(DIALOG_MESSAGE_TOKEN) > -1) {
            msg = this.localizeMessageToken(msg, FORGOT_ID_MESSAGE, Messages.CredentialPrompter_ask_forgot_id_message);
            msg = this.localizeMessageToken(msg, FORGOT_PASSWORD_MESSAGE, Messages.CredentialPrompter_ask_forgot_password_message);
            msg = this.localizeMessageToken(msg, IBM_ID_AND_FAQ_MESSAGE, Messages.CredentialPrompter_ask_ibm_id_and_faq_message);
        }
        return msg;
    }

    private String localizeMessageToken(String msg, String messageToken, String localizedMessage) {
        int index = msg.indexOf(messageToken);
        if (index == -1) {
            return msg;
        }
        StringBuffer buf = new StringBuffer(msg.substring(0, index));
        buf.append(localizedMessage);
        if (index < msg.length() - 1) {
            buf.append(msg.substring(index + messageToken.length()));
        }
        return buf.toString();
    }

    private String localizeMainMessage(String realm) {
        StringBuffer buf = new StringBuffer(Messages.CredentialPrompter_ask_main_realm_message);
        int index = realm.indexOf(DIALOG_MESSAGE_TOKEN);
        if (index > -1) {
            buf.append(realm.substring(index));
        }
        return buf.toString();
    }

    private boolean isIbmDownloadSite(String realm) {
        return realm.indexOf(IBM_MESSAGE_TOKEN) > -1 && realm.indexOf(DIALOG_MESSAGE_TOKEN) > -1;
    }
}

