/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.volrepo;

import com.ibm.cic.common.core.utils.FileUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class DiskTagFile {
    public static final String DISK_TAG_FILE = "diskTag.inf";

    public static File getFile(File diskRoot) {
        File diskTagFile = new File(diskRoot, DISK_TAG_FILE);
        return diskTagFile;
    }

    public static void save(DiskTagProperties dtp, File diskRoot) throws FileNotFoundException, IOException {
        File diskTagFile = DiskTagFile.getFile(diskRoot);
        FileUtil.ensureDestinationDirectory(diskTagFile);
        FileOutputStream out = new FileOutputStream(diskTagFile);
        try {
            dtp.getProperties().store(out, null);
        }
        finally {
            FileUtil.close(out);
        }
    }

    public static DiskTagProperties load(InputStream is) throws IOException {
        DiskTagProperties dtp = new DiskTagProperties();
        dtp.getProperties().load(is);
        return dtp;
    }

    public static class DiskTagProperties {
        private final Properties properties;
        public static final String DISK_LAYOUT_VERSION = "layoutVersion";
        public static final String DISK_SET_ID = "diskSetId";
        public static final String DISK_SET_OFFERING_ID = "diskSetOfferingId";
        public static final String DISK_SET_OFFERING_VERSION = "diskSetOfferingVersion";
        public static final String DISK_NUMBER = "diskNumber";

        public DiskTagProperties(Properties properties) {
            this.properties = properties;
        }

        public DiskTagProperties() {
            this(new Properties());
        }

        public void setProperty(String key, String value) {
            this.properties.setProperty(key, value);
        }

        public String getProperty(String key) {
            return this.properties.getProperty(key);
        }

        public int getDiskNumber() throws NumberFormatException {
            String value = this.getProperty(DISK_NUMBER);
            return Integer.parseInt(value);
        }

        Properties getProperties() {
            return this.properties;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("diskSetId=");
            sb.append(this.getProperty(DISK_SET_ID));
            sb.append(", ");
            sb.append("diskNumber=");
            sb.append(this.getProperty(DISK_NUMBER));
            sb.append(", ");
            sb.append("diskSetOfferingId=");
            sb.append(this.getProperty(DISK_SET_OFFERING_ID));
            sb.append(", ");
            sb.append("diskSetOfferingVersion=");
            sb.append(this.getProperty(DISK_SET_OFFERING_VERSION));
            sb.append(", ");
            sb.append("layoutVersion=");
            sb.append(this.getProperty(DISK_LAYOUT_VERSION));
            return sb.toString();
        }
    }
}

