/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.utils;

import com.ibm.cic.common.core.utils.Messages;
import org.eclipse.osgi.util.NLS;

public class UnsupportedOperationException
extends java.lang.UnsupportedOperationException {
    public UnsupportedOperationException() {
        super(UnsupportedOperationException.getUnsupportedOperationExceptionMessage());
    }

    public UnsupportedOperationException(String message) {
        super(message);
    }

    private static String getUnsupportedOperationExceptionMessage() {
        int stackIndex = -1;
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        String thisName = UnsupportedOperationException.class.getName();
        String throwableName = Throwable.class.getName();
        int i = 0;
        while (i < stackTrace.length) {
            StackTraceElement stackTraceElement = stackTrace[i];
            String className = stackTraceElement.getClassName();
            if (!className.equals(thisName) && !className.equals(throwableName)) {
                stackIndex = i;
                break;
            }
            ++i;
        }
        if (stackIndex < 0) {
            return null;
        }
        StackTraceElement stackTraceElement = stackTrace[stackIndex];
        String className = stackTraceElement.getClassName();
        String methodName = stackTraceElement.getMethodName();
        String fileName = stackTraceElement.getFileName();
        int lineNumber = stackTraceElement.getLineNumber();
        String msg = String.valueOf(className) + '.' + methodName;
        if (fileName != null && lineNumber > 0) {
            msg = String.valueOf(msg) + '(' + fileName + ':' + String.valueOf(lineNumber) + ')';
        }
        msg = NLS.bind((String)Messages.UnsupportedOperationException_defaultMessage, (Object)msg);
        return msg;
    }
}

