/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.utils;

import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.utils.Check;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.OutputFormatter;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.logging.UidUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;

public class StatusFormatter {
    private final OutputFormatter of;
    private boolean omitUid = false;
    private boolean reportChildren = false;
    private boolean reportSeverity = false;

    public static String toString(IStatus status) {
        return new StatusFormatter().format(status);
    }

    public StatusFormatter() {
        this.of = new OutputFormatter(2);
    }

    public StatusFormatter(OutputFormatter of) {
        this.of = of;
    }

    public StatusFormatter indent() {
        this.of.incTab();
        return this;
    }

    public StatusFormatter omitUid(boolean b) {
        this.omitUid = b;
        return this;
    }

    public StatusFormatter reportChildren(boolean b) {
        this.reportChildren = b;
        return this;
    }

    public StatusFormatter reportSeverity(boolean b) {
        this.reportSeverity = b;
        return this;
    }

    public String format(IStatus status) {
        Throwable e;
        Check.notNull(status);
        if (status instanceof ICicStatus) {
            String userAction;
            String explanation;
            ICicStatus cicStatus = (ICicStatus)status;
            String messages = status.getMessage();
            boolean uidIncluded = false;
            if (!this.omitUid) {
                String uid = cicStatus.getUid();
                if (uid != null) {
                    this.of.appendT(uid);
                    this.of.appendNT(": ");
                    this.of.appendNTnl(messages);
                    uidIncluded = true;
                } else if (this.reportSeverity) {
                    this.of.appendTnl(NLS.bind(StatusFormatter.getSeverityString(cicStatus), (Object)messages));
                    uidIncluded = true;
                }
            }
            if (!uidIncluded) {
                this.of.addTab();
                this.of.appendNTnl(messages);
            }
            if ((explanation = cicStatus.getExplanation()) != null) {
                this.of.nl();
                this.of.appendTnl(NLS.bind(Messages.ErrorDlg_Explanation, (Object)explanation));
            }
            if ((userAction = cicStatus.getUserAction()) != null) {
                this.of.nl();
                this.of.appendTnl(NLS.bind(Messages.ErrorDlg_UserAction, (Object)userAction));
            }
        } else if (this.reportSeverity && !this.omitUid) {
            this.of.appendTnl(NLS.bind(StatusFormatter.getSeverityString(status), (Object)status.getMessage()));
        } else {
            this.of.appendTnl(status.getMessage());
        }
        if ((e = status.getException()) != null) {
            if (e instanceof CoreException) {
                IStatus eStatus = ((CoreException)e).getStatus();
                if (!status.getMessage().contains(eStatus.getMessage())) {
                    this.of.incTab();
                    this.omitUid(false);
                    this.format(eStatus);
                    this.of.decTab();
                }
            } else {
                this.of.nl();
                this.of.appendTnl(e.toString());
            }
            if (e instanceof RuntimeException || e instanceof Error) {
                this.of.nl();
                StackTraceElement[] stackTraceElementArray = e.getStackTrace();
                int n = stackTraceElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    StackTraceElement ste = stackTraceElementArray[n2];
                    this.of.appendTnl(ste.toString());
                    ++n2;
                }
            }
        }
        if (this.reportChildren && status.getChildren().length > 0) {
            this.of.nl();
            this.of.incTab();
            this.omitUid(false);
            this.format(status.getChildren());
            this.of.decTab();
        }
        return this.of.withoutNL();
    }

    public String formatChildren(IStatus status) {
        this.reportSeverity(UidUtil.getUid(status) != null);
        this.reportChildren(true);
        this.format(status.getChildren());
        return this.of.withoutNL();
    }

    private void format(IStatus[] statuses) {
        int i = 0;
        while (i < statuses.length) {
            if (i > 0) {
                this.of.nl();
            }
            this.format(statuses[i]);
            ++i;
        }
    }

    private static String getSeverityString(IStatus status) {
        if (StatusUtil.isCancel(status)) {
            return Messages.CmdUtils_cancel;
        }
        if (StatusUtil.isError(status)) {
            return Messages.CmdUtils_error;
        }
        if (StatusUtil.isWarning(status)) {
            return Messages.CmdUtils_warning;
        }
        if (status.matches(1)) {
            return Messages.CmdUtils_information;
        }
        return Messages.CmdUtils_ok;
    }
}

