/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.utils;

import com.ibm.cic.common.core.utils.Encodings;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.logging.ExceptionUtil;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;

public final class PassOutputThruThread
extends Thread {
    public PassOutputThruThread(final InputStream input, final Writer output) {
        super(new Runnable(){

            @Override
            public void run() {
                Reader in = Encodings.DEFAULT.reader(input);
                Writer out = output != null ? output : FileUtil.NULL_WRITER;
                try {
                    int nChars;
                    char[] buffer = new char[8192];
                    while ((nChars = in.read(buffer)) >= 0) {
                        out.write(buffer, 0, nChars);
                    }
                    out.flush();
                }
                catch (Throwable t) {
                    ExceptionUtil.debugLogToReview(t);
                }
            }
        });
        this.start();
    }

    public void finish() {
        try {
            this.join(5000L);
        }
        catch (InterruptedException interruptedException) {}
        if (this.isAlive()) {
            this.interrupt();
        }
    }
}

