/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.utils;

import java.net.InetAddress;
import java.net.UnknownHostException;

public class NetworkInfo {
    private final InetAddress address;
    private final String fullHostName;
    private final String shortHostName;
    private final String domainName;

    private NetworkInfo(InetAddress addr, String fullHostName, String shortHostName, String domainName) {
        this.address = addr;
        this.fullHostName = fullHostName;
        this.shortHostName = shortHostName;
        this.domainName = domainName;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getFullHostName() {
        return this.fullHostName;
    }

    public String getShortHostName() {
        return this.shortHostName;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("host=");
        sb.append(this.shortHostName);
        sb.append(" domain=");
        sb.append(this.domainName);
        sb.append(" fullHostName=");
        sb.append(this.fullHostName);
        return sb.toString();
    }

    public static NetworkInfo getNetworkInfo() throws UnknownHostException {
        int index;
        InetAddress addr = InetAddress.getLocalHost();
        String shortHostName = addr.getHostName();
        String fullHostName = addr.getCanonicalHostName();
        String domainName = "";
        if (fullHostName.equals(shortHostName) && (index = fullHostName.indexOf(46)) != -1) {
            shortHostName = fullHostName.substring(0, index);
        }
        if (!fullHostName.equals(shortHostName) && fullHostName.length() > shortHostName.length() + 1 && fullHostName.startsWith(shortHostName)) {
            domainName = fullHostName.substring(shortHostName.length() + 1);
        }
        return new NetworkInfo(addr, fullHostName, shortHostName, domainName);
    }
}

