/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.utils;

import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.core.utils.ProcessInfo;
import com.ibm.cic.common.core.utils.ProcessesInfo;
import com.ibm.cic.common.logging.Logger;
import java.lang.reflect.Method;
import java.util.List;

public class NativeUtils {
    public static final int LINK_TYPE_NO_LINK = 0;
    public static final int LINK_TYPE_SYMBOLIC_LINK = 1;
    public static final int LINK_TYPE_MOUNT_POINT = 2;
    public static final int GET_SUBKEY_INCLUDE_KEYS = 1;
    public static final int GET_SUBKEY_INCLUDE_VALUES = 2;
    public static final int GET_SUBKEY_INCLUDE_ALL = 3;
    public static final String REG_SZ = "reg_sz";
    public static final String REG_EXPAND_SZ = "reg_expand_sz";
    public static final String REG_MULTI_SZ = "reg_multi_sz";
    public static final String REG_DWORD = "reg_dword";
    public static final String REG_BINARY = "reg_binary";
    private static boolean hasNatives = false;
    public static final int KEY_WOW64_32KEY = 512;
    public static final int KEY_WOW64_64KEY = 256;

    static {
        try {
            String library_file = System.getProperty("NATIVE_UTILS_FILE_LOCATION");
            if (library_file == null || library_file.length() == 0) {
                System.loadLibrary("nativeUtils");
            } else {
                System.load(library_file);
            }
            hasNatives = true;
        }
        catch (UnsatisfiedLinkError e) {
            Logger.getLogger(NativeUtils.class).error(e);
            hasNatives = false;
        }
    }

    public static String regDataType(String keyOrValueName) {
        return NativeUtils.regDataType(keyOrValueName, 512);
    }

    public static String regDataType(String keyOrValueName, int accessMask) {
        String return_value = NativeUtils.winRegDataType(keyOrValueName, accessMask);
        return return_value;
    }

    public static boolean regDelete(String path, String name) {
        return NativeUtils.regDelete(path, name, 512);
    }

    public static boolean regDelete(String path, String name, int accessMask) {
        boolean return_value = NativeUtils.winRegNameDelete(path, name, accessMask);
        if (!return_value) {
            return_value = NativeUtils.regRead(path, name, false, accessMask) == null;
        }
        return return_value;
    }

    public static boolean regDelete(String keyOrValueName) {
        return NativeUtils.regDelete(keyOrValueName, 512);
    }

    public static boolean regDelete(String keyOrValueName, int accessMask) {
        boolean return_value = NativeUtils.winRegDelete(keyOrValueName, accessMask);
        if (!return_value) {
            return_value = keyOrValueName.endsWith("\\") ? NativeUtils.winRegGetSubkeys(keyOrValueName, 3, accessMask).length == 0 : NativeUtils.winRegRead(keyOrValueName, false, accessMask) == null;
        }
        return return_value;
    }

    public static String regRead(String path, String name, boolean expand) {
        return NativeUtils.regRead(path, name, expand, 512);
    }

    public static String regRead(String path, String name, boolean expand, int accessMask) {
        String return_value = NativeUtils.winRegNameRead(path, name, expand, accessMask);
        return return_value;
    }

    public static String regRead(String keyOrValueName, boolean expand) {
        return NativeUtils.regRead(keyOrValueName, expand, 512);
    }

    public static String regRead(String keyOrValueName, boolean expand, int accessMask) {
        String return_value = NativeUtils.winRegRead(keyOrValueName, expand, accessMask);
        return return_value;
    }

    public static boolean regWrite(String path, String name, String value, String valueType) {
        return NativeUtils.regWrite(path, name, value, valueType, 512);
    }

    public static boolean regWrite(String path, String name, String value, String valueType, int accessMask) {
        boolean return_value = NativeUtils.winRegNameWrite(path, name, NativeUtils.normalizeRegValue(value, valueType), valueType, accessMask);
        return return_value;
    }

    public static boolean regWrite(String keyOrValueName, String value, String valueType) {
        return NativeUtils.regWrite(keyOrValueName, value, valueType, 512);
    }

    public static boolean regWrite(String keyOrValueName, String value, String valueType, int accessMask) {
        boolean return_value = NativeUtils.winRegWrite(keyOrValueName, NativeUtils.normalizeRegValue(value, valueType), valueType, accessMask);
        return return_value;
    }

    public static String[] regGetSubkeys(String key, int option) {
        return NativeUtils.regGetSubkeys(key, option, 512);
    }

    public static String[] regGetSubkeys(String key, int option, int accessMask) {
        return NativeUtils.winRegGetSubkeys(key, option, accessMask);
    }

    public static native String nativeGetLinkTarget(String var0);

    public static native int nativeGetLinkType(String var0);

    public static native long nativeGetFreeSpace(String var0);

    @Deprecated
    public static native boolean isAdministrator();

    public static boolean isNativeAdministrator() {
        boolean isAdmin = false;
        if (CicCommonSettings.isOS400()) {
            try {
                ClassLoader loader = NativeUtils.class.getClassLoader();
                Class<?> cls = loader.loadClass("com.ibm.cic.common.core.os400.utils.CheckUserAuthorizations");
                Method method = cls.getMethod("checkAllobjSecadmSpecialAuthorities", new Class[0]);
                Object object = method.invoke(null, new Object[0]);
                isAdmin = (Boolean)object;
            }
            catch (Exception e) {
                Logger.getLogger(NativeUtils.class).error(e);
                isAdmin = false;
            }
        } else {
            isAdmin = NativeUtils.isAdministrator();
        }
        return isAdmin;
    }

    static native int createSymlink(String var0, String var1);

    static native int getUmask();

    static native int setUmask(int var0);

    static native String getEffectiveGroup();

    static native String getFileGroup(String var0);

    private static native boolean winRegWrite(String var0, String var1, String var2, int var3);

    private static native boolean winRegNameWrite(String var0, String var1, String var2, String var3, int var4);

    private static native boolean winRegDelete(String var0, int var1);

    private static native boolean winRegNameDelete(String var0, String var1, int var2);

    private static native String winRegRead(String var0, boolean var1, int var2);

    private static native String winRegNameRead(String var0, String var1, boolean var2, int var3);

    private static native String winRegDataType(String var0, int var1);

    private static native String[] winRegGetSubkeys(String var0, int var1, int var2);

    static native String winSpecialFolder(String var0, boolean var1);

    static native boolean rebootOs(boolean var0);

    public static boolean hasNatives() {
        return hasNatives;
    }

    public static native boolean isWindows2000();

    public static native boolean isWindows2000Professional();

    public static native boolean isWindows2000AdvancedServer();

    public static native boolean isWindows2003Server();

    public static native boolean isWindows2008Server();

    public static native boolean isWindows2008ServerR2();

    public static native boolean isWindows2012Server();

    public static native boolean isWindowsVista();

    public static native boolean isWindows7();

    public static native boolean isWindows8();

    public static native boolean isWindowsXP();

    private static native ProcessesInfo winGetLockingProcesses(String var0);

    private static native long winGetCurrentProcId();

    private static native int winStopProcess(long var0);

    public static List<ProcessInfo> getLockingProcesses(String paths) {
        ProcessesInfo prInfo = NativeUtils.winGetLockingProcesses(paths);
        if (prInfo == null) {
            prInfo = new ProcessesInfo();
        }
        return prInfo.getProcesses();
    }

    public static long getCurrentProcId() {
        long return_value = NativeUtils.winGetCurrentProcId();
        return return_value;
    }

    public static int stopProcess(long procId) {
        int ret = NativeUtils.winStopProcess(procId);
        return ret;
    }

    private static String normalizeRegValue(String value, String valueType) {
        if (!REG_MULTI_SZ.equals(valueType) || value == null || value.length() == 0) {
            return value;
        }
        StringBuffer normalizedValue = new StringBuffer();
        int lastChar = 10;
        boolean hasValue = false;
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            if (c != '\n') {
                if (lastChar == 10) {
                    if (hasValue) {
                        normalizedValue.append('\n');
                    } else {
                        hasValue = true;
                    }
                }
                normalizedValue.append(c);
            }
            lastChar = c;
            ++i;
        }
        return normalizedValue.toString();
    }
}

