/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.utils;

import com.ibm.cic.common.core.utils.NIOChmodEngine;
import com.ibm.cic.common.logging.Logger;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.attribute.BasicFileAttributes;

public class NIOChmodFileTreeVisitor
implements FileVisitor<Path> {
    private final NIOChmodEngine chmod;
    private final PathMatcher matcher;
    static final Logger log = Logger.getLogger(NIOChmodFileTreeVisitor.class);

    NIOChmodFileTreeVisitor(NIOChmodEngine chmod, PathMatcher matcher) {
        this.chmod = chmod;
        this.matcher = matcher;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
        this.applyPermission(dir, attrs);
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
        this.applyPermission(file, attrs);
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
        if (exc != null) {
            log.error(exc, exc.toString(), new Object[0]);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) {
        log.error(exc, exc.toString(), new Object[0]);
        return FileVisitResult.CONTINUE;
    }

    private void applyPermission(Path file, BasicFileAttributes attrs) {
        try {
            if (this.matcher.matches(file.getFileName())) {
                this.chmod.apply(file, attrs);
            }
        }
        catch (IOException e) {
            log.error(e, e.toString(), new Object[0]);
        }
    }
}

