/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.utils;

import com.ibm.cic.common.core.utils.Messages;
import com.ibm.cic.common.core.utils.NIOChmodClause;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.PlatformUtils;
import com.ibm.cic.common.core.utils.UnsupportedOperationException;
import com.ibm.cic.common.logging.Logger;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class NIOChmodEngine {
    private final int umask = PlatformUtils.getUmask();
    private final List<NIOChmodClause> clauses = new ArrayList<NIOChmodClause>();
    boolean permCopy = false;
    boolean specialExecute = false;
    char permSrc = (char)32;
    char permTarget = (char)32;
    static final Logger log = Logger.getLogger(NIOChmodEngine.class);

    public void apply(Path file, BasicFileAttributes attrs) throws IOException {
        Set<PosixFilePermission> perms = Files.getPosixFilePermissions(file, new LinkOption[0]);
        if (this.permCopy) {
            this.processPermCopy(perms);
        }
        if (this.specialExecute) {
            this.processSpecialExecute(file, perms);
        }
        for (NIOChmodClause clause : this.clauses) {
            perms = clause.apply(perms);
        }
        Files.setPosixFilePermissions(file, perms);
    }

    private void processSpecialExecute(Path file, Set<PosixFilePermission> perms) throws IOException {
        NIOChmodClause addClause = NIOChmodClause.getNewChmodOperation(NIOChmodClause.Operation.ADD);
        Set<PosixFilePermission> currentPerm = Files.getPosixFilePermissions(file, new LinkOption[0]);
        if (currentPerm.contains((Object)PosixFilePermission.OWNER_EXECUTE) || currentPerm.contains((Object)PosixFilePermission.OTHERS_EXECUTE) || currentPerm.contains((Object)PosixFilePermission.GROUP_EXECUTE)) {
            addClause.add(PosixFilePermission.OWNER_EXECUTE);
            addClause.add(PosixFilePermission.GROUP_EXECUTE);
            addClause.add(PosixFilePermission.OTHERS_EXECUTE);
            this.clauses.add(addClause);
        }
    }

    private void processPermCopy(Set<PosixFilePermission> perms) {
        NIOChmodClause addClause = NIOChmodClause.getNewChmodOperation(NIOChmodClause.Operation.ADD);
        switch (this.permSrc) {
            case 'u': {
                if (this.permTarget == 'g') {
                    if (perms.contains((Object)PosixFilePermission.OWNER_WRITE)) {
                        addClause.add(PosixFilePermission.GROUP_WRITE);
                    }
                    if (perms.contains((Object)PosixFilePermission.OWNER_READ)) {
                        addClause.add(PosixFilePermission.GROUP_READ);
                    }
                    if (perms.contains((Object)PosixFilePermission.OWNER_EXECUTE)) {
                        addClause.add(PosixFilePermission.GROUP_EXECUTE);
                    }
                }
                if (this.permTarget != 'o') break;
                if (perms.contains((Object)PosixFilePermission.OWNER_WRITE)) {
                    addClause.add(PosixFilePermission.OTHERS_WRITE);
                }
                if (perms.contains((Object)PosixFilePermission.OWNER_READ)) {
                    addClause.add(PosixFilePermission.OTHERS_READ);
                }
                if (!perms.contains((Object)PosixFilePermission.OWNER_EXECUTE)) break;
                addClause.add(PosixFilePermission.OTHERS_EXECUTE);
                break;
            }
            case 'g': {
                if (this.permTarget == 'u') {
                    if (perms.contains((Object)PosixFilePermission.GROUP_WRITE)) {
                        addClause.add(PosixFilePermission.OWNER_WRITE);
                    }
                    if (perms.contains((Object)PosixFilePermission.GROUP_READ)) {
                        addClause.add(PosixFilePermission.OWNER_READ);
                    }
                    if (perms.contains((Object)PosixFilePermission.GROUP_EXECUTE)) {
                        addClause.add(PosixFilePermission.OWNER_EXECUTE);
                    }
                }
                if (this.permTarget != 'o') break;
                if (perms.contains((Object)PosixFilePermission.GROUP_WRITE)) {
                    addClause.add(PosixFilePermission.OTHERS_WRITE);
                }
                if (perms.contains((Object)PosixFilePermission.GROUP_READ)) {
                    addClause.add(PosixFilePermission.OTHERS_READ);
                }
                if (!perms.contains((Object)PosixFilePermission.GROUP_EXECUTE)) break;
                addClause.add(PosixFilePermission.OTHERS_EXECUTE);
                break;
            }
            case 'o': {
                if (this.permTarget == 'u') {
                    if (perms.contains((Object)PosixFilePermission.OTHERS_WRITE)) {
                        addClause.add(PosixFilePermission.OWNER_WRITE);
                    }
                    if (perms.contains((Object)PosixFilePermission.OTHERS_READ)) {
                        addClause.add(PosixFilePermission.OWNER_READ);
                    }
                    if (perms.contains((Object)PosixFilePermission.OTHERS_EXECUTE)) {
                        addClause.add(PosixFilePermission.OWNER_EXECUTE);
                    }
                }
                if (this.permTarget != 'g') break;
                if (perms.contains((Object)PosixFilePermission.OTHERS_WRITE)) {
                    addClause.add(PosixFilePermission.GROUP_WRITE);
                }
                if (perms.contains((Object)PosixFilePermission.OTHERS_READ)) {
                    addClause.add(PosixFilePermission.GROUP_READ);
                }
                if (!perms.contains((Object)PosixFilePermission.OTHERS_EXECUTE)) break;
                addClause.add(PosixFilePermission.GROUP_EXECUTE);
                break;
            }
            default: {
                throw new IllegalArgumentException(NLS.bind(Messages.NIO_Chmod_Invalid_Parameter, (Object)Character.valueOf(this.permSrc), perms));
            }
        }
        this.clauses.add(addClause);
    }

    public NIOChmodEngine(String perms) {
        try {
            this.parseOctalMode(perms);
        }
        catch (NumberFormatException numberFormatException) {
            this.parseSymbolicMode(perms);
        }
    }

    private void parseOctalMode(String perms) {
        int val = Integer.parseInt(perms, 8);
        if (val > 512) {
            throw new UnsupportedOperationException(NLS.bind(Messages.NIO_Chmod_Unknown_Permission, (Object)perms));
        }
        NIOChmodClause clause = NIOChmodClause.getNewChmodOperation(NIOChmodClause.Operation.SET);
        this.clauses.add(clause);
        if ((val & 1) > 0) {
            clause.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        if ((val & 2) > 0) {
            clause.add(PosixFilePermission.OTHERS_WRITE);
        }
        if ((val & 4) > 0) {
            clause.add(PosixFilePermission.OTHERS_READ);
        }
        if ((val & 8) > 0) {
            clause.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if ((val & 0x10) > 0) {
            clause.add(PosixFilePermission.GROUP_WRITE);
        }
        if ((val & 0x20) > 0) {
            clause.add(PosixFilePermission.GROUP_READ);
        }
        if ((val & 0x40) > 0) {
            clause.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if ((val & 0x80) > 0) {
            clause.add(PosixFilePermission.OWNER_WRITE);
        }
        if ((val & 0x100) > 0) {
            clause.add(PosixFilePermission.OWNER_READ);
        }
    }

    private void parseSymbolicMode(String perms) {
        boolean isAdd = true;
        String[] stringArray = perms.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String perm = stringArray[n2];
            NIOChmodClause clause = null;
            boolean u = false;
            boolean g = false;
            boolean o = false;
            int i = 0;
            while (i < perm.length()) {
                char c = perm.charAt(i);
                switch (c) {
                    case 'u': {
                        if (clause == null) {
                            u = true;
                            this.permTarget = (char)117;
                            break;
                        }
                        this.permCopy = true;
                        this.permSrc = (char)117;
                        break;
                    }
                    case 'g': {
                        if (clause == null) {
                            g = true;
                            this.permTarget = (char)103;
                            break;
                        }
                        this.permCopy = true;
                        this.permSrc = (char)103;
                        break;
                    }
                    case 'o': {
                        if (clause == null) {
                            o = true;
                            this.permTarget = (char)111;
                            break;
                        }
                        this.permCopy = true;
                        this.permSrc = (char)111;
                        break;
                    }
                    case 'a': {
                        u = true;
                        g = true;
                        o = true;
                        break;
                    }
                    case '+': {
                        clause = NIOChmodClause.getNewChmodOperation(NIOChmodClause.Operation.ADD);
                        this.clauses.add(clause);
                        break;
                    }
                    case '-': {
                        clause = NIOChmodClause.getNewChmodOperation(NIOChmodClause.Operation.REMOVE);
                        this.clauses.add(clause);
                        break;
                    }
                    case '=': {
                        NIOChmodClause resetclause = NIOChmodClause.getNewChmodOperation(NIOChmodClause.Operation.REMOVE);
                        this.clauses.add(resetclause);
                        if (u) {
                            resetclause.add(PosixFilePermission.OWNER_EXECUTE);
                            resetclause.add(PosixFilePermission.OWNER_WRITE);
                            resetclause.add(PosixFilePermission.OWNER_READ);
                        }
                        if (g) {
                            resetclause.add(PosixFilePermission.GROUP_EXECUTE);
                            resetclause.add(PosixFilePermission.GROUP_WRITE);
                            resetclause.add(PosixFilePermission.GROUP_READ);
                        }
                        if (o) {
                            resetclause.add(PosixFilePermission.OTHERS_EXECUTE);
                            resetclause.add(PosixFilePermission.OTHERS_WRITE);
                            resetclause.add(PosixFilePermission.OTHERS_READ);
                        }
                        if (!(o || u || g)) {
                            resetclause.add(PosixFilePermission.OWNER_EXECUTE);
                            resetclause.add(PosixFilePermission.OWNER_WRITE);
                            resetclause.add(PosixFilePermission.OWNER_READ);
                            resetclause.add(PosixFilePermission.GROUP_EXECUTE);
                            resetclause.add(PosixFilePermission.GROUP_WRITE);
                            resetclause.add(PosixFilePermission.GROUP_READ);
                            resetclause.add(PosixFilePermission.OTHERS_EXECUTE);
                            resetclause.add(PosixFilePermission.OTHERS_WRITE);
                            resetclause.add(PosixFilePermission.OTHERS_READ);
                        }
                        clause = NIOChmodClause.getNewChmodOperation(NIOChmodClause.Operation.ADD);
                        this.clauses.add(clause);
                        break;
                    }
                    case 'r': {
                        if (clause == null) {
                            throw new IllegalArgumentException(NLS.bind(Messages.NIO_Chmod_Mod_And_Operation_Cant_Exist, (Object)Character.valueOf(c), (Object)perm));
                        }
                        if (u) {
                            clause.add(PosixFilePermission.OWNER_READ);
                        }
                        if (g) {
                            clause.add(PosixFilePermission.GROUP_READ);
                        }
                        if (o) {
                            clause.add(PosixFilePermission.OTHERS_READ);
                        }
                        if (o || u || g) break;
                        if ((this.umask & 4) <= 0) {
                            clause.add(PosixFilePermission.OTHERS_READ);
                        }
                        if ((this.umask & 0x20) <= 0) {
                            clause.add(PosixFilePermission.GROUP_READ);
                        }
                        if ((this.umask & 0x100) > 0) break;
                        clause.add(PosixFilePermission.OWNER_READ);
                        break;
                    }
                    case 'w': {
                        if (clause == null) {
                            throw new IllegalArgumentException(NLS.bind(Messages.NIO_Chmod_Mod_And_Operation_Cant_Exist, (Object)Character.valueOf(c), (Object)perm));
                        }
                        if (u) {
                            clause.add(PosixFilePermission.OWNER_WRITE);
                        }
                        if (g) {
                            clause.add(PosixFilePermission.GROUP_WRITE);
                        }
                        if (o) {
                            clause.add(PosixFilePermission.OTHERS_WRITE);
                        }
                        if (o || u || g) break;
                        if ((this.umask & 2) <= 0) {
                            clause.add(PosixFilePermission.OTHERS_WRITE);
                        }
                        if ((this.umask & 0x10) <= 0) {
                            clause.add(PosixFilePermission.GROUP_WRITE);
                        }
                        if ((this.umask & 0x80) > 0) break;
                        clause.add(PosixFilePermission.OWNER_WRITE);
                        break;
                    }
                    case 'x': {
                        if (clause == null) {
                            throw new IllegalArgumentException(NLS.bind(Messages.NIO_Chmod_Mod_And_Operation_Cant_Exist, (Object)Character.valueOf(c), (Object)perm));
                        }
                        if (u) {
                            clause.add(PosixFilePermission.OWNER_EXECUTE);
                        }
                        if (g) {
                            clause.add(PosixFilePermission.GROUP_EXECUTE);
                        }
                        if (o) {
                            clause.add(PosixFilePermission.OTHERS_EXECUTE);
                        }
                        if (o || u || g) break;
                        if ((this.umask & 1) <= 0) {
                            clause.add(PosixFilePermission.OTHERS_EXECUTE);
                        }
                        if ((this.umask & 8) <= 0) {
                            clause.add(PosixFilePermission.GROUP_EXECUTE);
                        }
                        if ((this.umask & 0x40) > 0) break;
                        clause.add(PosixFilePermission.OWNER_EXECUTE);
                        break;
                    }
                    case 'X': {
                        if (isAdd) {
                            this.specialExecute = true;
                            break;
                        }
                        clause.add(PosixFilePermission.OWNER_EXECUTE);
                        clause.add(PosixFilePermission.GROUP_EXECUTE);
                        clause.add(PosixFilePermission.OTHERS_EXECUTE);
                        break;
                    }
                    case 's': 
                    case 't': {
                        throw new UnsupportedOperationException(NLS.bind(Messages.NIO_Chmod_No_Support_Operation, (Object)perms));
                    }
                    default: {
                        throw new IllegalArgumentException(NLS.bind(Messages.NIO_Chmod_Invalid_Parameter, (Object)Character.valueOf(c), (Object)perms));
                    }
                }
                ++i;
            }
            ++n2;
        }
    }
}

