/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.utils;

import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IInstallableUnitContainer;
import com.ibm.cic.common.core.model.SimpleIdentity;

public final class IdentityUtil {
    private static final String QUALIFIED_SEPARATOR = "..";

    private IdentityUtil() {
        assert (false);
    }

    public static IIdentity createQualifiedId(IInstallableUnit iu) {
        IInstallableUnitContainer parent = iu.getParent();
        IIdentity id = iu.getIdentity();
        return parent == null ? id : new SimpleIdentity(IdentityUtil.createQualifiedId(parent.getIdentity().getId(), id.getId()));
    }

    public static String createQualifiedId(String parent, String child) {
        return String.valueOf(parent) + QUALIFIED_SEPARATOR + child;
    }

    public static String[] splitQualifiedId(IIdentity qualifiedId) {
        return IdentityUtil.splitQualifiedId(qualifiedId.getId());
    }

    public static String[] splitQualifiedId(String qualifiedId) {
        int i = qualifiedId.indexOf(QUALIFIED_SEPARATOR);
        if (i < 0) {
            String[] stringArray = new String[2];
            stringArray[1] = qualifiedId;
            return stringArray;
        }
        return new String[]{qualifiedId.substring(0, i), qualifiedId.substring(i + QUALIFIED_SEPARATOR.length())};
    }

    public static String getVersionedId(IContent content) {
        return String.valueOf(content.getIdentity().getId()) + '_' + content.getVersion().toString();
    }

    public static String getQualifiedVersionedId(IInstallableUnit unit) {
        return String.valueOf(unit.getQualifiedId().getId()) + '_' + unit.getVersion().toString();
    }
}

