/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.utils;

import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.core.utils.ConvertUtil;
import com.ibm.cic.common.core.utils.DeviceSystemUtil;
import com.ibm.cic.common.core.utils.Encodings;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.Messages;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.PPFileUtil;
import com.ibm.cic.common.core.utils.PlatformUtils;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.UserOptions;
import com.ibm.cic.common.downloads.FormatUtil;
import com.ibm.cic.common.downloads.IHasIsCanceled;
import com.ibm.cic.common.downloads.ITransferMonitor;
import com.ibm.cic.common.downloads.ProgressInputStream;
import com.ibm.cic.common.downloads.TransferMonitor;
import com.ibm.cic.common.logging.ExceptionUtil;
import com.ibm.cic.common.logging.Logger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.Console;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.SyncFailedException;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

public class FileUtil {
    public static final String DS_STORE = ".DS_Store";
    private static final Logger log = Logger.getLogger(FileUtil.class);
    public static final int CHANNEL_BLOCK_SIZE = 65536;
    private static final int BLOCK_SIZE = 4096;
    private static final int MAX_MKDIR_RETRIES = 5;
    private static boolean makeDirNull = false;
    public static final Writer NULL_WRITER = new Writer(){

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }

        @Override
        public void write(char[] cbuf, int off, int len) {
        }
    };
    static final IChannelTransfer DEFAULT_CHANNEL_TRANSFER = new DefaultChannelTransfer();
    private static final Object lock_fileTempDir = new Object();
    private static File fileTmpDir;
    private static final int bufferSize = 24576;

    public static void setMakeDirNull(boolean bVal) {
        makeDirNull = bVal;
    }

    public static File toAbsolute(File path, File defaultRelative) {
        return path.isAbsolute() ? path : new File(defaultRelative, path.toString());
    }

    public static long getSizeOnDisk4kBlocks(long size) {
        return (size + 4096L - 1L) / 4096L * 4096L;
    }

    public static long getFileSizeOnDisk4kBlocks(File file) {
        File[] f;
        if (!file.isDirectory()) {
            return FileUtil.getSizeOnDisk4kBlocks(file.length());
        }
        long result = 0L;
        File[] fileArray = f = file.listFiles();
        int n = f.length;
        int n2 = 0;
        while (n2 < n) {
            File element = fileArray[n2];
            result += FileUtil.getFileSizeOnDisk4kBlocks(element);
            ++n2;
        }
        return result;
    }

    public static String getRelativePath(File parent, File child) {
        try {
            String parentPath = parent.getCanonicalPath();
            String childPath = child.getCanonicalPath();
            if (childPath.startsWith(String.valueOf(parentPath) + File.separatorChar)) {
                return childPath.substring(parentPath.length() + 1);
            }
            return childPath;
        }
        catch (IOException iOException) {
            return child.getPath();
        }
    }

    public static void checkAbsoluteFile(File file) throws IOException {
        FileUtil.checkAbsolute(file);
        if (!file.exists()) {
            throw new IOException(NLS.bind(Messages.FileUtil_File_Not_Found, (Object)file));
        }
        if (file.isDirectory()) {
            throw new IOException(NLS.bind(Messages.FileUtil_File_Is_A_Directory, (Object)file));
        }
    }

    public static void checkAbsoluteDir(File file) throws IOException {
        FileUtil.checkAbsolute(file);
        if (!file.exists()) {
            throw new IOException(NLS.bind(Messages.FileUtil_Directory_Not_Found, (Object)file));
        }
        if (!file.isDirectory()) {
            throw new IOException(NLS.bind(Messages.FileUtil_Not_A_Directory, (Object)file));
        }
    }

    public static void checkAbsolute(File file) throws IOException {
        if (!file.isAbsolute()) {
            throw new IOException(NLS.bind(Messages.FileUtil_Path_Not_Absolute, (Object)file));
        }
    }

    public static void copyFile(File file, File destination) throws IOException, FileNotFoundException {
        PPFileUtil.getPolicy().copyFile(file, destination);
    }

    static void copyFile(IChannelTransfer channelTransfer, File file, File destination) throws IOException, FileNotFoundException {
        FileInputStream fin = null;
        FileOutputStream fout = null;
        FileChannel from = null;
        FileChannel to = null;
        try {
            fin = new FileInputStream(file);
            fout = new FileOutputStream(destination);
            from = fin.getChannel();
            to = fout.getChannel();
            long[] outBytesCopied = new long[1];
            FileUtil.transferBlock(channelTransfer, file, destination, from, to, from.size(), from.size(), 0L, from.size(), null, outBytesCopied);
        }
        finally {
            if (fin != null) {
                fin.close();
            }
            if (fout != null) {
                fout.close();
            }
        }
    }

    public static void copyFile(File file, File destination, long blockSize, boolean syncOnClose, ITransferMonitor transferPerformance) throws IOException, FileNotFoundException {
        long[] outBytesCopied = new long[1];
        FileUtil.copyFile(file, destination, blockSize, syncOnClose, transferPerformance, outBytesCopied);
    }

    public static void copyFile(File file, File destination, long blockSize, boolean syncOnClose, ITransferMonitor transferPerformance, long[] outBytesCopied) throws IOException, FileNotFoundException {
        PPFileUtil.getPolicy().copyFile(file, destination, blockSize, syncOnClose, transferPerformance, outBytesCopied);
    }

    public static void copyFile(IChannelTransfer channelTransfer, File file, File destination, long blockSize, boolean syncOnClose, ITransferMonitor transferPerformance, long[] outBytesCopied) throws IOException, FileNotFoundException {
        assert (channelTransfer != null);
        assert (outBytesCopied != null);
        assert (outBytesCopied.length == 1);
        assert (outBytesCopied[0] == 0L);
        if (transferPerformance == null) {
            transferPerformance = new TransferMonitor();
        }
        FileInputStream fin = null;
        FileOutputStream fout = null;
        FileChannel from = null;
        FileChannel to = null;
        long bytes = file.length();
        long blocks = bytes / blockSize;
        long remainder = bytes % blockSize;
        transferPerformance.startTransfer(bytes, bytes);
        try {
            fin = new FileInputStream(file);
            fout = new FileOutputStream(destination);
            from = fin.getChannel();
            to = fout.getChannel();
            long i = 0L;
            while (i < blocks) {
                if (!FileUtil.transferBlock(channelTransfer, file, destination, from, to, bytes, blockSize, i, blockSize, transferPerformance, outBytesCopied)) {
                    return;
                }
                ++i;
            }
            if (remainder > 0L && !FileUtil.transferBlock(channelTransfer, file, destination, from, to, bytes, blockSize, blocks, remainder, transferPerformance, outBytesCopied)) {
                return;
            }
            if (syncOnClose) {
                to.force(true);
            }
        }
        finally {
            transferPerformance.done();
            if (fin != null) {
                fin.close();
            }
            if (fout != null) {
                fout.close();
            }
        }
    }

    private static boolean transferBlock(IChannelTransfer channelTransfer, File file, File destination, FileChannel from, FileChannel to, long bytes, long blockSize, long i, long remainder, ITransferMonitor transferPerformance, long[] outBytesCopied) throws IOException {
        long copied = 0L;
        long pos = i * blockSize;
        long count = remainder;
        Long noProgressTime = null;
        while (copied != remainder) {
            long ret = channelTransfer.transfer(from, to, pos, count);
            if (ret != count) {
                long requiredSpace = bytes - pos + ret;
                IStatus status = DeviceSystemUtil.getDiskSpaceStatus(null, destination, requiredSpace, 2);
                if (!status.isOK()) {
                    throw new LowDiskSpaceException(status);
                }
                if (ret == 0L) {
                    if (noProgressTime != null) {
                        long now = System.currentTimeMillis();
                        long elapsed = now - noProgressTime;
                        if (channelTransfer.getNoProgressTimeout() != -1L && elapsed > channelTransfer.getNoProgressTimeout()) {
                            throw new TransferTimeoutException(NLS.bind(Messages.FileUtil_noProgressCopyingAfterTimeout, file, destination, FormatUtil.formatTimeSpanMilliSeconds(elapsed)));
                        }
                    } else {
                        noProgressTime = System.currentTimeMillis();
                    }
                } else {
                    noProgressTime = null;
                }
            }
            copied += ret;
            count -= ret;
            pos += ret;
            outBytesCopied[0] = outBytesCopied[0] + ret;
            if (transferPerformance == null) continue;
            int percentDone = (int)(outBytesCopied[0] * 100L / (bytes + 1L));
            transferPerformance.update(percentDone, outBytesCopied[0], bytes, -1L, -1L);
            if (!transferPerformance.isCanceled()) continue;
            return false;
        }
        return true;
    }

    public static void copyFile(File file, File destination, long blockSize, boolean syncOnClose, IProgressMonitor monitor) throws FileNotFoundException, IOException {
        CopyProgressMonitor cpm = new CopyProgressMonitor(monitor);
        FileUtil.copyFile(file, destination, blockSize, syncOnClose, cpm);
    }

    public static void copyFile(File file, File destination, IProgressMonitor monitor) throws IOException, FileNotFoundException {
        FileUtil.copyFile(file, destination, false, monitor);
    }

    public static void copyFile(File file, File destination, boolean syncOnClose, IProgressMonitor monitor) throws IOException, FileNotFoundException {
        FileUtil.copyFile(file, destination, 65536L, syncOnClose, monitor);
    }

    public static void copyFile(File file, File destination, boolean syncOnClose, String perm, IProgressMonitor monitor) throws IOException, FileNotFoundException {
        FileUtil.copyFile(file, destination, 65536L, syncOnClose, monitor);
        if (perm != null) {
            FileUtil.chmod(perm, false, false, new String[]{FileUtil.getCanonicalPath(destination)});
        }
    }

    public static void copyFile(File file, File destination, boolean syncOnClose, ITransferMonitor transferPerformance) throws IOException, FileNotFoundException {
        FileUtil.copyFile(file, destination, 65536L, syncOnClose, transferPerformance);
    }

    public static void copyFile(File file, File destination, boolean syncOnClose, ITransferMonitor transferPerformance, long[] outBytesCopied) throws IOException, FileNotFoundException {
        FileUtil.copyFile(file, destination, 65536L, syncOnClose, transferPerformance, outBytesCopied);
    }

    public static void fdSync(FileDescriptor fd) throws SyncFailedException {
        if (UserOptions.CIC_SKIP_FD_SYNC.isSet()) {
            return;
        }
        fd.sync();
    }

    public static void copyStream(InputStream stream, File destFile, IProgressMonitor monitor) throws IOException {
        InputStream source = null;
        FileOutputStream dest = null;
        try {
            int bytesRead;
            File destFolder = destFile.getParentFile();
            if (!destFolder.isDirectory()) {
                destFolder.mkdirs();
            }
            source = stream;
            dest = new FileOutputStream(destFile);
            byte[] buffer = new byte[8192];
            while ((bytesRead = source.read(buffer)) != -1) {
                dest.write(buffer, 0, bytesRead);
            }
        }
        catch (Throwable throwable) {
            FileUtil.close(source);
            if (dest != null) {
                dest.close();
            }
            throw throwable;
        }
        FileUtil.close(source);
        if (dest != null) {
            dest.close();
        }
    }

    public static void copyFileToStream(File inputFile, OutputStream destStream, boolean closeOutputStream, IProgressMonitor monitor) throws IOException {
        FileInputStream source = null;
        source = new FileInputStream(inputFile);
        FileUtil.transferStreams(source, true, destStream, closeOutputStream);
    }

    public static long copyStream(long size, InputStream stream, File destFile, boolean syncOnClose, ITransferMonitor transferPerformance) throws IOException {
        if (transferPerformance == null) {
            transferPerformance = new TransferMonitor();
        }
        long copied = 0L;
        ProgressInputStream source = null;
        FileOutputStream dest = null;
        try {
            int bytesRead;
            File destFolder = destFile.getParentFile();
            if (!destFolder.isDirectory()) {
                destFolder.mkdirs();
            }
            source = new ProgressInputStream(null, stream, size, size, transferPerformance, true);
            dest = new FileOutputStream(destFile);
            byte[] buffer = new byte[8192];
            while (!transferPerformance.isCanceled() && (bytesRead = ((InputStream)source).read(buffer)) != -1) {
                dest.write(buffer, 0, bytesRead);
                copied += (long)bytesRead;
            }
            if (syncOnClose) {
                dest.flush();
                FileUtil.fdSync(dest.getFD());
            }
        }
        catch (Throwable throwable) {
            FileUtil.close(source);
            if (dest != null) {
                dest.close();
            }
            throw throwable;
        }
        FileUtil.close(source);
        if (dest != null) {
            dest.close();
        }
        return copied;
    }

    public static boolean ensureDestinationDirectory(File destFile) {
        File destFolder;
        boolean return_value = false;
        if (destFile != null && (destFolder = destFile.getParentFile()) != null) {
            return_value = destFolder.isDirectory() ? true : destFolder.mkdirs();
        }
        return return_value;
    }

    public static void ensureDirectory(File directory) {
        if (!directory.isDirectory()) {
            int i = 0;
            while (i < 5) {
                directory.mkdirs();
                if (directory.exists()) {
                    return;
                }
                ++i;
            }
            log.warning(Messages.FileUtil_Failed_To_Create_Directory, directory.getAbsolutePath());
        }
    }

    public static void ensureDestinationDirectory(File destFile, IProgressMonitor monitor) {
        FileUtil.ensureDestinationDirectory(destFile);
    }

    public static ICicStatus checkDestinationDirectory(File destFile) {
        File parent = destFile.getParentFile();
        return FileUtil.checkDirectoryExistsAndWritable(parent);
    }

    public static ICicStatus checkDirectoryExistsAndWritable(File dir) {
        if (!dir.exists()) {
            ICicStatus statusError = Statuses.ERROR.get(104, Messages.FileUtil_destination_directory_does_not_exist, dir);
            return statusError;
        }
        if (!dir.isDirectory()) {
            ICicStatus statusError = Statuses.ERROR.get(104, Messages.FileUtil_destination_directory_does_not_exist, dir);
            return statusError;
        }
        try {
            File dummy = FileUtil.createTempFile("testCanWrite", null, dir);
            dummy.delete();
        }
        catch (IOException e) {
            ICicStatus statusError = Statuses.ERROR.get(104, e, Messages.FileUtil_destination_directory_cant_write, dir);
            return statusError;
        }
        return ICicStatus.OK_STATUS;
    }

    public static boolean directoryIsWriteable(String dir) {
        boolean return_value = false;
        File theDir = new File(dir);
        while (theDir != null && !theDir.exists()) {
            theDir = theDir.getParentFile();
        }
        if (theDir != null && theDir.isDirectory()) {
            File testShortCut = new File(theDir, "IBMIM_dummy.dll");
            if (!testShortCut.exists()) {
                try {
                    return_value = testShortCut.createNewFile();
                }
                catch (IOException e) {
                    ExceptionUtil.debugLogIOException(e);
                }
            } else {
                return_value = true;
            }
            if (return_value) {
                return_value = testShortCut.delete();
            }
        }
        return return_value;
    }

    public static synchronized ICicStatus checkDestination(File destFile) {
        FileUtil.ensureDestinationDirectory(destFile);
        return FileUtil.checkDestinationDirectory(destFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getJavaIoTmpDir() {
        Object object = lock_fileTempDir;
        synchronized (object) {
            if (fileTmpDir == null) {
                String v = System.getProperty("java.io.tmpdir");
                fileTmpDir = new File(v);
            }
            return fileTmpDir;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetJavaIoTmpDir() {
        Object object = lock_fileTempDir;
        synchronized (object) {
            fileTmpDir = null;
        }
    }

    public static File createTempFile(String prefix, String suffix, File directory) throws IOException {
        File tmpDir = directory;
        if (tmpDir == null) {
            tmpDir = FileUtil.getJavaIoTmpDir();
        }
        return File.createTempFile(prefix, suffix, tmpDir);
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        return FileUtil.createTempFile(prefix, suffix, null);
    }

    public static File createTempDir(String prefix, String suffix, File directory) throws IOException {
        File file = FileUtil.createTempFile(prefix, suffix, directory);
        if (!(file = file.getCanonicalFile()).delete()) {
            throw new IOException(NLS.bind(Messages.FileUtil_failed_to_delete, (Object)file));
        }
        if (!file.mkdirs()) {
            throw new IOException(NLS.bind(Messages.FileUtil_destination_directory_does_not_exist, (Object)file));
        }
        return file;
    }

    public static IStatus makeDirectories(File directory) {
        if (!directory.isDirectory() && !directory.mkdirs()) {
            String msg = NLS.bind(Messages.FileUtil_destination_directory_does_not_exist, (Object)directory);
            ICicStatus statusError = Statuses.ERROR.get(104, msg, new Object[0]);
            return statusError;
        }
        return Status.OK_STATUS;
    }

    public static void mv(File file, File destination, boolean overwrite, IProgressMonitor monitor) throws FileNotFoundException, IOException {
        FileUtil.mv(file, destination, overwrite, false, monitor);
    }

    public static void mv(File file, File destination, boolean overwrite, boolean preserveModified, IProgressMonitor monitor) throws FileNotFoundException, IOException {
        boolean moved;
        if (overwrite && destination.exists()) {
            destination.delete();
        }
        if (!(moved = file.renameTo(destination))) {
            FileUtil.copyFile(file, destination, true, monitor);
            if (preserveModified) {
                destination.setLastModified(file.lastModified());
            }
            FileUtil.rm(file);
        }
    }

    public static void deleteEmptyDirs(File dir) throws IOException {
        FileUtil.deleteEmptyDirs(dir, null, null);
    }

    public static void deleteEmptyDirsLogIOE(File dir) {
        try {
            FileUtil.deleteEmptyDirs(dir);
        }
        catch (IOException e) {
            ExceptionUtil.log.warning(e);
        }
    }

    public static void deleteEmptyDirs(File dir, Collection notDeleted, Collection deleted) throws IOException {
        File[] files = dir.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                FileUtil.deleteEmptyDirs(file, notDeleted, deleted);
                ++n2;
            }
            File cfile = dir.getCanonicalFile();
            boolean d = cfile.delete();
            if (d) {
                if (deleted != null) {
                    deleted.add(cfile);
                }
            } else if (notDeleted != null) {
                notDeleted.add(cfile);
            }
        }
    }

    public static boolean isEmptyDir(File dir) {
        return dir.isDirectory() && dir.list().length == 0;
    }

    public static boolean delete(File path) {
        boolean return_value = FileUtil.delete(path, 1, 0);
        return return_value;
    }

    private static boolean delete(File path, int attempt, int maxattempt) {
        boolean return_value = true;
        if (path == null) {
            return return_value;
        }
        boolean isSymLink = PlatformUtils.isSymlink(path);
        if (isSymLink || path.exists()) {
            File parent = path.getParentFile();
            return_value = path.delete();
            if (return_value) {
                if (!FileUtil.confirmDeletion(parent, path)) {
                    log.debug("Could not confirm deletion of {0}", path.getAbsolutePath());
                }
            } else if (attempt <= maxattempt) {
                if (attempt == maxattempt) {
                    log.warning("Failed to delete {0}", path.getAbsolutePath());
                    return_value = false;
                } else {
                    if (CicCommonSettings.isWindows() && attempt == 1) {
                        System.gc();
                    }
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException ex) {
                        ExceptionUtil.debugLogInterruptedException(ex);
                    }
                    return_value = FileUtil.delete(path, attempt + 1, maxattempt);
                }
            }
        }
        return return_value;
    }

    private static boolean confirmDeletion(File parent, File path) {
        boolean deleted = true;
        int i = 0;
        while (i < 50) {
            deleted = true;
            String[] fn = parent.list();
            if (fn != null) {
                String[] stringArray = fn;
                int n = fn.length;
                int n2 = 0;
                while (n2 < n) {
                    String element = stringArray[n2];
                    if (path.getName().equals(element)) {
                        deleted = false;
                    }
                    ++n2;
                }
            }
            if (deleted) break;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ++i;
        }
        return deleted;
    }

    public static void renameTo(File file, File destination, boolean overwrite) throws IOException {
        boolean ok;
        if (overwrite && destination.exists()) {
            destination.delete();
        }
        if (!(ok = file.renameTo(destination))) {
            String msg = NLS.bind(Messages.FileUtil_renameTo_failed, (Object)file, (Object)destination);
            log.debug(msg);
            throw new IOException(msg);
        }
    }

    public static void copyDir(File src, File dest, IProgressMonitor monitor) throws IOException {
        FileUtil.copyDir(src, dest, null, monitor);
    }

    public static void copyDir(File src, File dest, String perm, IProgressMonitor monitor) throws IOException {
        FileUtil.copyDir(src, dest, false, false, true, false, false, perm, "", monitor);
    }

    public static void copyDir(File src, File dest, boolean copyEmptyDirs, boolean allowCancel, boolean fineGrained, boolean showPercent, boolean preserveTimeStamp, String taskName, IProgressMonitor monitor) throws IOException {
        FileUtil.copyDir(src, dest, copyEmptyDirs, allowCancel, fineGrained, showPercent, preserveTimeStamp, null, taskName, monitor);
    }

    public static void copyDir(File src, File dest, boolean copyEmptyDirs, boolean allowCancel, boolean fineGrained, boolean showPercent, boolean preserveTimeStamp, String perm, String taskName, IProgressMonitor monitor) throws IOException {
        try {
            int totalWork;
            if (monitor == null) {
                totalWork = 1024;
                monitor = new NullProgressMonitor();
            } else {
                totalWork = FileUtil.computeCopyDirWork(src);
            }
            monitor.beginTask("", 1);
            SubProgressMonitor submon = new SubProgressMonitor(monitor, 1, 4);
            submon.beginTask(taskName, totalWork);
            FileUtil.doCopyDir(src, dest, copyEmptyDirs, allowCancel, fineGrained, showPercent, preserveTimeStamp, perm, 0, totalWork, (IProgressMonitor)submon);
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private static int doCopyDir(File src, File dest, boolean copyEmptyDirs, boolean allowCancel, boolean fineGrained, boolean showPercent, boolean preserveTimeStamp, String perm, int work, int totalWork, IProgressMonitor monitor) throws IOException {
        String[] files = src.list();
        if (files == null) {
            return work;
        }
        if ((files.length > 0 || copyEmptyDirs) && dest.mkdir() && perm != null) {
            FileUtil.chmod(perm, false, false, new String[]{FileUtil.getCanonicalPath(dest)});
        }
        String[] stringArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            if (allowCancel && monitor.isCanceled()) break;
            File from = new File(src, file);
            File to = new File(dest, file);
            if (from.isDirectory()) {
                work = FileUtil.doCopyDir(from, to, copyEmptyDirs, allowCancel, fineGrained, showPercent, preserveTimeStamp, perm, work, totalWork, monitor);
            } else {
                if (fineGrained) {
                    FileUtil.copyFile(from, to, true, perm, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                } else {
                    FileUtil.copyFile(from, to, true, perm, (IProgressMonitor)new NullProgressMonitor());
                    monitor.worked(1);
                }
                if (preserveTimeStamp) {
                    to.setLastModified(from.lastModified());
                }
                ++work;
                if (showPercent) {
                    int pct = work * 100 / totalWork;
                    String percent = String.valueOf('(') + String.valueOf(pct) + "%) ";
                    monitor.subTask(percent);
                }
            }
            ++n2;
        }
        return work;
    }

    private static int computeCopyDirWork(File src) throws IOException {
        String[] files = src.list();
        if (files == null) {
            return 0;
        }
        int result = 0;
        String[] stringArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            File from = new File(src, file);
            result = from.isDirectory() ? (result += FileUtil.computeCopyDirWork(from)) : ++result;
            ++n2;
        }
        return result;
    }

    public static boolean rm_r(File f, boolean removeRoot) {
        return FileUtil.rm_r(f, removeRoot, null, null);
    }

    public static boolean rm_r(File f, boolean removeRoot, Collection notDeleted, Collection deleted) {
        boolean isSymLink = PlatformUtils.isSymlink(f);
        if (!f.exists() && !isSymLink) {
            log.debug("File does not exist ({0}) to be deleted.", f.getAbsolutePath());
            return true;
        }
        if (!f.isDirectory() || isSymLink) {
            return FileUtil.deleteAndTrack(f, notDeleted, deleted);
        }
        File[] subfiles = f.listFiles();
        boolean deletedChildren = true;
        if (subfiles != null) {
            File[] fileArray = subfiles;
            int n = subfiles.length;
            int n2 = 0;
            while (n2 < n) {
                File subfile = fileArray[n2];
                deletedChildren &= FileUtil.rm_r(subfile, true, notDeleted, deleted);
                ++n2;
            }
        }
        if (removeRoot) {
            if (f.delete()) {
                if (deleted != null) {
                    deleted.add(f);
                }
                log.debug("Dir  deleted ({0}).", f.getAbsolutePath());
                return true;
            }
            if (notDeleted != null) {
                notDeleted.add(f);
            }
            if (deletedChildren) {
                log.warning(Messages.FileUtil_failed_to_delete, f);
            } else {
                log.debug(Messages.FileUtil_failed_to_delete, f);
            }
        }
        return false;
    }

    private static boolean deleteAndTrack(File f, Collection notDeleted, Collection deleted) {
        boolean b = f.delete();
        if (b) {
            if (deleted != null) {
                deleted.add(f);
            }
            log.debug("File deleted ({0}).", f);
        } else if (notDeleted != null) {
            notDeleted.add(f);
            log.debug(Messages.FileUtil_failed_to_delete, f);
        } else {
            log.warning(Messages.FileUtil_failed_to_delete, f);
        }
        return b;
    }

    private static int collectDirsForRemoval(Collection dirFileCounts, File f, boolean removeRoot) {
        if (!f.exists()) {
            return 0;
        }
        if (f.isFile()) {
            return 1;
        }
        File[] subfiles = f.listFiles();
        int count = 0;
        File[] fileArray = subfiles;
        int n = subfiles.length;
        int n2 = 0;
        while (n2 < n) {
            File subfile = fileArray[n2];
            count += FileUtil.collectDirsForRemoval(dirFileCounts, subfile, true);
            ++n2;
        }
        if (removeRoot) {
            dirFileCounts.add(new DirFileCount(f, subfiles.length));
            ++count;
        }
        return count;
    }

    public static boolean rm_r(File f, boolean removeRoot, IProgressMonitor monitor) {
        LinkedList list = new LinkedList();
        int count = FileUtil.collectDirsForRemoval(list, f, removeRoot);
        monitor.beginTask("", count);
        boolean deletedChildren = true;
        try {
            for (DirFileCount dirFileCount : list) {
                File dir = dirFileCount.getDir();
                deletedChildren &= FileUtil.rm_r(dir, true);
                monitor.worked(dirFileCount.getCount());
            }
        }
        finally {
            monitor.done();
        }
        return deletedChildren;
    }

    public static int listFiles(File dir, Collection list) throws IOException {
        File canDir = dir.getCanonicalFile();
        if (!canDir.isDirectory()) {
            return 0;
        }
        boolean listDirs = false;
        boolean listRelative = false;
        return FileUtil.privateListFiles(canDir, null, list, listDirs, listRelative);
    }

    public static int listRelativeFiles(File dir, Collection list, boolean listDirs) throws IOException {
        File canDir = dir.getCanonicalFile();
        if (!canDir.isDirectory()) {
            return 0;
        }
        return FileUtil.privateListFiles(canDir, null, list, listDirs, true);
    }

    private static int privateListFiles(File dir, File relDir, Collection list, boolean listDirs, boolean listRelative) {
        assert (dir.isDirectory());
        assert (dir.isAbsolute());
        String[] names = dir.list();
        ArrayList<File> filesThisDir = null;
        if (list != null) {
            filesThisDir = new ArrayList<File>(names.length + 1);
        }
        File[] files = new File[names.length];
        int count = 0;
        int i = 0;
        while (i < names.length) {
            String name = names[i];
            files[i] = new File(dir, name);
            boolean isSymLink = PlatformUtils.isSymlink(files[i]);
            if (files[i].isDirectory() && !isSymLink) {
                File relDir2 = relDir == null ? new File(name) : new File(relDir, name);
                count += FileUtil.privateListFiles(files[i], relDir2, list, listDirs, listRelative);
            }
            ++i;
        }
        if (listDirs && relDir != null) {
            if (filesThisDir != null) {
                if (listRelative) {
                    filesThisDir.add(relDir);
                } else {
                    filesThisDir.add(dir);
                }
            }
            ++count;
        }
        i = 0;
        while (i < names.length) {
            if (files[i].isFile()) {
                if (filesThisDir != null) {
                    if (listRelative) {
                        filesThisDir.add(new File(relDir, names[i]));
                    } else {
                        filesThisDir.add(files[i]);
                    }
                }
                ++count;
            }
            ++i;
        }
        if (list != null) {
            list.addAll(filesThisDir);
        }
        return count;
    }

    public static boolean removeEmptyDirs(File dir, boolean removeRoot, String ... subDirsToSkip) {
        return FileUtil.removeEmptyDirs(dir, removeRoot, true, subDirsToSkip);
    }

    private static boolean removeEmptyDirs(File dir, boolean removeRoot, boolean reportFailures, String ... subDirsToSkip) {
        if (!dir.exists()) {
            return true;
        }
        if (dir.isDirectory()) {
            HashSet<String> subDirsToSkipSet = new HashSet<String>(Arrays.asList(subDirsToSkip));
            File[] subfiles = null;
            if (!makeDirNull) {
                subfiles = dir.listFiles();
            }
            boolean hasRemainingChild = false;
            boolean hasRemainingChildSkipped = false;
            if (subfiles != null) {
                File[] fileArray = subfiles;
                int n = subfiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File subfile = fileArray[n2];
                    if (subfile.isDirectory()) {
                        if (subDirsToSkipSet.contains(subfile.getName())) {
                            hasRemainingChildSkipped = true;
                        } else {
                            boolean removedSubDir = FileUtil.removeEmptyDirs(subfile, true, false, new String[0]);
                            if (reportFailures && !removedSubDir) {
                                log.warning(Messages.FileUtil_failed_to_delete, subfile);
                            }
                            hasRemainingChild = !removedSubDir || hasRemainingChild;
                        }
                    } else if (subfile.getName().equals(DS_STORE) && Platform.getOS().equals("macosx")) {
                        subfile.delete();
                    } else {
                        hasRemainingChild = true;
                    }
                    ++n2;
                }
            }
            if (removeRoot && !hasRemainingChild && !hasRemainingChildSkipped) {
                boolean bl = hasRemainingChild = !dir.delete();
            }
            if (reportFailures && removeRoot && hasRemainingChild) {
                log.warning(Messages.FileUtil_failed_to_delete, dir);
            }
            return !hasRemainingChild;
        }
        return false;
    }

    public static void rm(File f) {
        if (f.exists()) {
            if (!f.isFile()) {
                log.warning(Messages.FileUtil_failed_to_delete_directory, f);
            } else if (!f.delete()) {
                log.warning(Messages.FileUtil_failed_to_delete, f);
            }
        }
    }

    public static void close(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (Exception e) {
                ExceptionUtil.debugLogToReview(e);
            }
        }
    }

    public static Map<String, String> toMap(Properties props) {
        HashMap<String, String> result = new HashMap<String, String>(props.size());
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            result.put((String)entry.getKey(), (String)entry.getValue());
        }
        return result;
    }

    public static Properties readProperties(File file) throws IOException {
        Properties properties = new Properties();
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
        try {
            try {
                properties.load(is);
            }
            catch (IOException e) {
                FileUtil.close(is);
                throw e;
            }
        }
        finally {
            FileUtil.close(is);
        }
        return properties;
    }

    public static void writeProperties(File file, Properties properties) throws IOException {
        FileUtil.writeProperties(file, properties, null);
    }

    public static void writeProperties(File file, Properties properties, String comments) throws IOException {
        file.getParentFile().mkdirs();
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));){
            try {
                properties.store(os, comments);
            }
            catch (IOException e) {
                FileUtil.close(os);
                throw e;
            }
        }
    }

    public static String readFile(File file) throws IOException {
        return Encodings.UTF8.read(file);
    }

    public static String readPasswordFromStdIn(String promptLabel) {
        String result = null;
        Console c = System.console();
        if (c == null) {
            System.out.print(promptLabel);
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            try {
                result = br.readLine();
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        } else {
            System.out.print(promptLabel);
            result = String.copyValueOf(c.readPassword());
            if (CicCommonSettings.isZOS() && PlatformUtils.isJRE6()) {
                result = ConvertUtil.convertStringA2E(result);
            }
        }
        if (result != null) {
            result = result.trim();
        }
        return result;
    }

    public static String readStream(InputStream in) throws IOException {
        return Encodings.UTF8.read(in);
    }

    public static void writeFile(File file, String contents, boolean append) throws IOException {
        Encodings.UTF8.write(file, contents, append);
    }

    public static void writeFile(File file, String contents) throws IOException {
        Encodings.UTF8.write(file, contents);
    }

    public static File getCanonicalFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            return file;
        }
    }

    public static String getCanonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return file.getPath();
        }
    }

    public static String getCanonicalPath(String path) {
        return FileUtil.getCanonicalPath(new File(path));
    }

    public static boolean directoriesAreRelated(File dir1, File dir2) {
        int len1 = FileUtil.getCanonicalPath(dir1).length();
        int len2 = FileUtil.getCanonicalPath(dir2).length();
        if (len1 == 0 && len2 == 0) {
            return true;
        }
        if (len1 > 0 && len2 > 0) {
            String path2;
            String path1 = PPFileUtil.getPolicy().processPathForComparison(dir1);
            if (path1.equals(path2 = PPFileUtil.getPolicy().processPathForComparison(dir2))) {
                return true;
            }
            return path2.startsWith(String.valueOf(path1) + File.separatorChar) || path1.startsWith(String.valueOf(path2) + File.separatorChar);
        }
        return false;
    }

    public static boolean directoriesAreRelated(String path1, String path2) {
        return FileUtil.directoriesAreRelated(new File(path1), new File(path2));
    }

    public static boolean filesAreSame(String path1, String path2) {
        assert (path1 != null);
        if (path2 == null) {
            return false;
        }
        return FileUtil.filesAreSame(new File(path1), new File(path2));
    }

    public static boolean filesAreSame(File file1, File file2) {
        assert (file1 != null);
        if (file2 == null) {
            return false;
        }
        int len1 = FileUtil.getCanonicalPath(file1).length();
        int len2 = FileUtil.getCanonicalPath(file2).length();
        if (len1 == 0 && len2 == 0) {
            return true;
        }
        if (len1 > 0 && len2 > 0) {
            String path1 = PPFileUtil.getPolicy().processPathForComparison(file1);
            String path2 = PPFileUtil.getPolicy().processPathForComparison(file2);
            return path1.equals(path2);
        }
        return false;
    }

    public static boolean chmod(String perm, boolean recursive, String file) {
        return PlatformUtils.chmod(new String[]{file}, perm, recursive) == 0;
    }

    public static boolean chmod(String perm, boolean recursive, String[] fileList) {
        return PlatformUtils.chmod(fileList, perm, recursive) == 0;
    }

    public static boolean chmod(String perm, boolean recursive, boolean shellSyntax, String file) {
        return PlatformUtils.chmod(new String[]{file}, perm, recursive, shellSyntax, null, null) == 0;
    }

    public static boolean chmod(String perm, boolean recursive, boolean shellSyntax, String[] fileList) {
        return PlatformUtils.chmod(fileList, perm, recursive, shellSyntax, null, null) == 0;
    }

    public static void zip(File sourceFolder, File destinationArchive) throws IOException {
        ZipOutputStream output = new ZipOutputStream(new FileOutputStream(destinationArchive));
        try {
            FileUtil.zipDir(output, sourceFolder, (IPath)new Path(""));
        }
        catch (Throwable throwable) {
            try {
                output.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            output.close();
        }
        catch (IOException iOException) {}
    }

    public static void zip(File[] sourceFiles, File destinationArchive) throws IOException {
        ZipOutputStream output = new ZipOutputStream(new FileOutputStream(destinationArchive));
        try {
            File[] fileArray = sourceFiles;
            int n = sourceFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File sourceFile = fileArray[n2];
                if (sourceFile.isDirectory()) {
                    FileUtil.zipDir(output, sourceFile, (IPath)new Path(sourceFile.getName()));
                } else {
                    FileUtil.zipFile(output, sourceFile, (IPath)new Path(""));
                }
                ++n2;
            }
        }
        catch (Throwable throwable) {
            try {
                output.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            output.close();
        }
        catch (IOException iOException) {}
    }

    public static File fixLongFileName(File file) {
        return PPFileUtil.getPolicy().fixLongFileName(file);
    }

    private static void zipFile(ZipOutputStream output, File sourceFile, IPath prefix) throws IOException {
        FileInputStream input = new FileInputStream(sourceFile);
        try {
            ZipEntry zipEntry = new ZipEntry(prefix.append(sourceFile.getName()).toString());
            zipEntry.setTime(sourceFile.lastModified());
            output.putNextEntry(zipEntry);
            FileUtil.transferStreams(input, true, output, false);
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)input).close();
            }
            catch (IOException iOException) {}
            try {
                output.closeEntry();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            ((InputStream)input).close();
        }
        catch (IOException iOException) {}
        try {
            output.closeEntry();
        }
        catch (IOException iOException) {}
    }

    private static void zipDir(ZipOutputStream output, File source, IPath prefix) {
        File[] files;
        File[] fileArray = files = PPFileUtil.getPolicy().fixLongFileName(source).listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            try {
                File fixedFile = PPFileUtil.getPolicy().fixLongFileName(file);
                if (fixedFile.isFile()) {
                    FileUtil.zipFile(output, fixedFile, prefix);
                } else if (fixedFile.isDirectory()) {
                    FileUtil.zipDir(output, fixedFile, prefix.append(file.getName()));
                } else {
                    log.error(Messages.FileUtil_ZipError, file.getAbsolutePath());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }

    public static String shortenNameLength(String name) {
        StringTokenizer tok = new StringTokenizer(name, "_ ");
        ArrayList<String> list = new ArrayList<String>();
        while (tok.hasMoreElements()) {
            list.add(tok.nextToken());
        }
        String[] toks = list.toArray(new String[list.size()]);
        int keyIndex = 0;
        boolean nextIndex = false;
        int i = 0;
        while (i < toks.length && keyIndex < 10) {
            String key = toks[i];
            if (key.length() > 1) {
                int j = i + 1;
                while (j < toks.length) {
                    if (toks[j].length() > 1 && toks[j].equals(key)) {
                        toks[j] = Integer.toString(keyIndex);
                        nextIndex = true;
                    }
                    ++j;
                }
            }
            if (nextIndex) {
                nextIndex = false;
                ++keyIndex;
            }
            ++i;
        }
        StringBuffer return_value = new StringBuffer();
        String[] stringArray = toks;
        int n = toks.length;
        int n2 = 0;
        while (n2 < n) {
            String tok2 = stringArray[n2];
            return_value.append(tok2);
            ++n2;
        }
        return return_value.toString();
    }

    public static void transferStreams(InputStream source, boolean closeSource, OutputStream destination, boolean closeDestination) throws IOException {
        byte[] buffer = new byte[24576];
        try {
            int bytesRead = 0;
            while ((bytesRead = source.read(buffer)) > 0) {
                destination.write(buffer, 0, bytesRead);
            }
        }
        catch (Throwable throwable) {
            if (closeSource) {
                try {
                    source.close();
                }
                catch (IOException iOException) {}
            }
            if (closeDestination) {
                try {
                    destination.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (closeSource) {
            try {
                source.close();
            }
            catch (IOException iOException) {}
        }
        if (closeDestination) {
            try {
                destination.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static ByteArrayInputStream transferStreamToByteArrayInputStream(InputStream source, int size) throws IOException {
        int bytesRead;
        if (size < 0) {
            throw new IllegalArgumentException("Negative file size: " + size);
        }
        byte[] byteArray = new byte[size];
        int offset = 0;
        while (offset < size && (bytesRead = source.read(byteArray, offset, size - offset)) != -1) {
            offset += bytesRead;
        }
        return new ByteArrayInputStream(byteArray);
    }

    public static boolean isDirectoryWriteable(String path) {
        return FileUtil.isDirectoryWriteable(new File(path));
    }

    public static boolean isDirectoryWriteable(File path) {
        boolean return_value = false;
        if (path.isDirectory()) {
            return FileUtil.canCreateAndRemoveFile(path);
        }
        if (!path.exists()) {
            File parent = path;
            do {
                if ((parent = parent.getParentFile()) == null || !parent.exists()) continue;
                return FileUtil.canCreateAndRemoveFile(parent);
            } while (parent != null);
        }
        return return_value;
    }

    private static boolean canCreateAndRemoveFile(File dir) {
        boolean return_value = false;
        if (dir.isDirectory()) {
            File testFile = new File(dir, "writeTestNow.dll");
            try {
                try {
                    return_value = testFile.createNewFile();
                }
                catch (IOException e) {
                    ExceptionUtil.debugLogIOException(e);
                    if (testFile.exists()) {
                        testFile.delete();
                    }
                }
            }
            finally {
                if (testFile.exists()) {
                    testFile.delete();
                }
            }
        }
        return return_value;
    }

    public static boolean canRead(File file) {
        return PPFileUtil.getPolicy().canRead(file);
    }

    public static boolean canRead(String pathname) {
        boolean return_value = false;
        if (pathname != null && !pathname.equals("")) {
            return_value = FileUtil.canRead(new File(pathname));
        }
        return return_value;
    }

    public static boolean canWrite(File file) {
        return PPFileUtil.getPolicy().canWrite(file);
    }

    public static boolean canWrite(String pathname) {
        boolean return_value = false;
        if (pathname != null && !pathname.equals("")) {
            return_value = FileUtil.canWrite(new File(pathname));
        }
        return return_value;
    }

    public static void close(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException e) {
                ExceptionUtil.debugLogIOException(e);
            }
        }
    }

    public static String getFileDetails(File f) {
        StringBuffer details = new StringBuffer();
        if (f != null) {
            String path = f.getAbsolutePath();
            boolean exists = f.exists();
            boolean readable = f.canRead();
            boolean writable = f.canWrite();
            boolean executable = f.canExecute();
            boolean hidden = f.isHidden();
            String lastModified = new Date(f.lastModified()).toString();
            long size = FileUtil.getFileSizeOnDisk4kBlocks(f);
            details.append("Path = ").append(path).append("\n");
            details.append("Exists = ").append(exists).append("\n");
            details.append("Readable = ").append(readable).append("\n");
            details.append("Writable = ").append(writable).append("\n");
            details.append("Executable = ").append(executable).append("\n");
            details.append("Hidden = ").append(hidden).append("\n");
            details.append("Modified = ").append(lastModified).append("\n");
            details.append("Size = ").append(size).append("\n");
        }
        return details.toString();
    }

    public static class CopyProgressMonitor
    extends TransferMonitor {
        private IProgressMonitor monitor;

        public CopyProgressMonitor(IProgressMonitor monitor) {
            this.monitor = monitor != null ? monitor : new NullProgressMonitor();
            this.setMonitorCanceled(new IHasIsCanceled(){

                @Override
                public boolean isCanceled() {
                    return CopyProgressMonitor.this.monitor.isCanceled();
                }
            });
        }

        @Override
        public void startTransfer(long bytesTotal, long bytesToTransfer) {
            this.monitor.beginTask("", 100);
        }

        @Override
        public void done() {
            this.monitor.done();
        }

        @Override
        public void update(int percentDone, long bytesTransferred, long bytesToTransferTotal, long bytesPerSecondTotal, long bytesPerLastSecond) {
            this.monitor.worked(percentDone);
        }

        @Override
        public boolean needsUpdates() {
            return true;
        }
    }

    static class DefaultChannelTransfer
    implements IChannelTransfer {
        DefaultChannelTransfer() {
        }

        @Override
        public long transfer(FileChannel from, FileChannel to, long pos, long count) throws IOException {
            return to.transferFrom(from, pos, count);
        }

        @Override
        public long getNoProgressTimeout() {
            return 10000L;
        }
    }

    private static class DirFileCount {
        private final File dir;
        private final int count;

        public DirFileCount(File dir, int count) {
            this.dir = dir;
            this.count = count;
        }

        public File getDir() {
            return this.dir;
        }

        public int getCount() {
            return this.count;
        }
    }

    public static interface IChannelTransfer {
        public long getNoProgressTimeout();

        public long transfer(FileChannel var1, FileChannel var2, long var3, long var5) throws IOException;
    }

    public static class LowDiskSpaceException
    extends IOException {
        private final IStatus status;

        public LowDiskSpaceException(IStatus status) {
            super(status.getMessage());
            this.status = status;
        }

        public IStatus getStatus() {
            return this.status;
        }
    }

    public static class NoFinalizeCloseFileOutputStream
    extends FileOutputStream {
        public NoFinalizeCloseFileOutputStream(File file, boolean append) throws FileNotFoundException {
            super(file, append);
        }

        public NoFinalizeCloseFileOutputStream(File file) throws FileNotFoundException {
            super(file);
        }

        public NoFinalizeCloseFileOutputStream(FileDescriptor fdObj) {
            super(fdObj);
        }

        public NoFinalizeCloseFileOutputStream(String name, boolean append) throws FileNotFoundException {
            super(name, append);
        }

        public NoFinalizeCloseFileOutputStream(String name) throws FileNotFoundException {
            super(name);
        }

        protected void finalize() {
        }
    }

    public static abstract class RetryOnIOException {
        private final Logger retryLog;
        private long startTime;
        private int count;
        private boolean succeeded;

        public RetryOnIOException(Logger log) {
            this.retryLog = log;
        }

        protected abstract String getOperationDebugMessage();

        protected abstract void operation() throws IOException;

        protected abstract boolean shouldRetry(IOException var1);

        protected abstract void onSucceeded();

        protected abstract void logFailedInNoRetryMode(IOException var1);

        protected long getElapsedTimeMillis() {
            return System.currentTimeMillis() - this.startTime;
        }

        public int getOperationCalledCount() {
            return this.count;
        }

        protected Logger log() {
            return this.retryLog;
        }

        public void perform() throws IOException {
            if (UserOptions.CIC_RETRY_MOVE.isSet()) {
                this.log().debug("Perform with retry: {0}", this.getOperationDebugMessage());
                this.performWithRetry();
            } else {
                this.log().debug("Perform without retry: {0}", this.getOperationDebugMessage());
                try {
                    this.count = 1;
                    this.operation();
                    this.onSucceeded();
                }
                catch (IOException e) {
                    this.logFailedInNoRetryMode(e);
                    throw e;
                }
            }
        }

        private void performWithRetry() throws IOException {
            this.startTime = System.currentTimeMillis();
            this.count = 0;
            this.succeeded = false;
            while (!this.succeeded) {
                try {
                    ++this.count;
                    this.operation();
                    this.succeeded = true;
                    this.onSucceeded();
                    break;
                }
                catch (IOException e) {
                    if (this.shouldRetry(e)) continue;
                    throw e;
                }
            }
        }
    }

    public static abstract class RetryOnIOExceptionDefaultLogging
    extends RetryOnIOException {
        private final long pauseInMillis;

        public RetryOnIOExceptionDefaultLogging(Logger retryLog, long pauseInMillis) {
            super(retryLog);
            this.pauseInMillis = pauseInMillis;
        }

        public RetryOnIOExceptionDefaultLogging(Logger retryLog) {
            this(retryLog, 500L);
        }

        public long getPauseInMillis() {
            return this.pauseInMillis;
        }

        @Override
        protected void onSucceeded() {
            String msg;
            if (this.getOperationCalledCount() > 1 && (msg = this.getSucceededAfterRetriesMessage()) != null) {
                this.log().note(msg, new Object[0]);
            }
        }

        @Override
        protected void logFailedInNoRetryMode(IOException e) {
            String msg = this.getFailedMessage();
            this.error(e, msg, new Object[0]);
        }

        protected abstract String getSucceededAfterRetriesMessage();

        @Override
        protected boolean shouldRetry(IOException e) {
            String msg;
            boolean retry = this.decideShouldRetry(e);
            if (!retry) {
                String msg2 = this.getFailedAfterTryingNTimesMessage();
                this.error(e, msg2, new Object[0]);
                return false;
            }
            if (this.getOperationCalledCount() == 1) {
                msg = this.getFirstRetryMessage();
                this.warning(e, msg, new Object[0]);
            } else {
                msg = this.getSubsequentRetryMessage();
                this.warning(e, msg, new Object[0]);
            }
            System.gc();
            try {
                Thread.sleep(this.pauseInMillis);
            }
            catch (InterruptedException e1) {
                this.log().debug(e1);
            }
            return true;
        }

        protected abstract boolean decideShouldRetry(IOException var1);

        protected abstract String getFailedAfterTryingNTimesMessage();

        protected abstract String getFailedMessage();

        protected abstract String getFirstRetryMessage();

        protected abstract String getSubsequentRetryMessage();

        private void error(IOException e, String msg, Object ... args) {
            if (msg != null) {
                this.log().status(Statuses.ERROR.get(e, msg, args));
            } else {
                this.log().error(e);
            }
        }

        private void warning(IOException e, String msg, Object ... args) {
            if (msg != null) {
                this.log().status(Statuses.WARNING.get(e, msg, args));
            } else {
                this.log().warning(e);
            }
        }
    }

    public static abstract class RetryToTimeoutOnIOException
    extends RetryOnIOExceptionDefaultLogging {
        private final int timeoutInSeconds;

        public RetryToTimeoutOnIOException(Logger retryLog, long pauseInMillis, int timeoutInSeconds) {
            super(retryLog, pauseInMillis);
            this.timeoutInSeconds = timeoutInSeconds;
        }

        public RetryToTimeoutOnIOException(Logger retryLog, int timeoutInSeconds) {
            super(retryLog);
            this.timeoutInSeconds = timeoutInSeconds;
        }

        protected abstract String getOperationForMessage();

        @Override
        protected String getFailedMessage() {
            return NLS.bind(Messages.FileUtil_retryFailed, (Object)this.getOperationForMessage());
        }

        @Override
        protected String getSucceededAfterRetriesMessage() {
            return NLS.bind(Messages.FileUtil_succeededAfterCountRetries, (Object)this.getOperationForMessage(), (Object)(this.getOperationCalledCount() - 1));
        }

        @Override
        protected String getFailedAfterTryingNTimesMessage() {
            String msg = NLS.bind(Messages.FileUtil_failedPersistentlyAfterCountRetries, (Object)this.getOperationForMessage(), (Object)this.getOperationCalledCount());
            return msg;
        }

        @Override
        protected boolean decideShouldRetry(IOException arg0) {
            long elapsed = this.getElapsedTimeMillis();
            return elapsed < (long)(this.timeoutInSeconds * 1000);
        }

        @Override
        protected String getFirstRetryMessage() {
            return NLS.bind(Messages.FileUtil_failedRetryingForCountSeconds, (Object)this.getOperationForMessage(), (Object)this.timeoutInSeconds);
        }

        @Override
        protected String getSubsequentRetryMessage() {
            return NLS.bind(Messages.FileUtil_retryFailed, (Object)this.getOperationForMessage());
        }
    }

    public static abstract class SafeUpdate {
        private final File file;

        public SafeUpdate(File file) {
            this.file = file;
        }

        public abstract void write(FileOutputStream var1) throws IOException;

        public void write() throws IOException {
            FileUtil.ensureDestinationDirectory(this.file);
            File tmp = this.getTemp();
            FileOutputStream stream = null;
            try {
                stream = new FileOutputStream(tmp);
                this.write(stream);
                stream.close();
            }
            catch (IOException e) {
                FileUtil.close(stream);
                tmp.delete();
                throw e;
            }
            if (!this.file.exists()) {
                FileUtil.renameTo(tmp, this.file, false);
            } else {
                File orig = this.getTemp();
                FileUtil.renameTo(this.file, orig, false);
                try {
                    FileUtil.renameTo(tmp, this.file, false);
                    orig.delete();
                }
                catch (IOException e) {
                    orig.renameTo(this.file);
                    throw e;
                }
            }
        }

        private File getTemp() {
            String path = String.valueOf(this.file.getPath()) + '.';
            int i = 0;
            File result;
            while ((result = new File(String.valueOf(path) + i)).exists()) {
                ++i;
            }
            return result;
        }
    }

    public static class SyncOnCloseFileOutputStream
    extends NoFinalizeCloseFileOutputStream {
        public SyncOnCloseFileOutputStream(File file, boolean append) throws FileNotFoundException {
            super(file, append);
        }

        public SyncOnCloseFileOutputStream(File file) throws FileNotFoundException {
            super(file);
        }

        public SyncOnCloseFileOutputStream(FileDescriptor fdObj) {
            super(fdObj);
        }

        public SyncOnCloseFileOutputStream(String name, boolean append) throws FileNotFoundException {
            super(name, append);
        }

        public SyncOnCloseFileOutputStream(String name) throws FileNotFoundException {
            super(name);
        }

        @Override
        public void close() throws IOException {
            this.flush();
            FileUtil.fdSync(this.getFD());
            super.close();
        }

        @Override
        protected void finalize() {
        }
    }

    public static class TransferTimeoutException
    extends IOException {
        public TransferTimeoutException() {
        }

        public TransferTimeoutException(String s) {
            super(s);
        }
    }
}

