/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.utils;

import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.utils.DeviceSystemUtil;
import com.ibm.cic.common.core.utils.IDeviceSystem;
import com.ibm.cic.common.core.utils.Messages;
import com.ibm.cic.common.core.utils.NativeUtils;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import org.eclipse.core.runtime.Plugin;

public class DeviceSystem {
    private static final Logger log = Logger.getLogger(DeviceSystem.class, (Plugin)ComIbmCicCommonCorePlugin.getDefault());
    private static final IDeviceSystem THE_DS;
    private static IDeviceSystem ds;
    public static final int LINK_TYPE_NO_LINK = 0;
    public static final int LINK_TYPE_SYMBOLIC_LINK = 1;
    public static final int LINK_TYPE_MOUNT_POINT = 2;

    static {
        ds = THE_DS = new IDeviceSystem(){

            @Override
            public long getFreeSpace(File path) {
                return DeviceSystem.implGetFreeSpace(path);
            }

            @Override
            public File getMountPoint(File path) {
                return DeviceSystem.implGetMountPoint(path);
            }
        };
    }

    public static IDeviceSystem getDeviceSystem() {
        return ds;
    }

    @Deprecated
    public static void setDeviceSystem(IDeviceSystem deviceSystem) {
        ds = deviceSystem;
    }

    public static File getMountPoint(File path) {
        return DeviceSystem.getDeviceSystem().getMountPoint(path);
    }

    public static long getFreeSpace(File path) {
        return DeviceSystem.getDeviceSystem().getFreeSpace(path);
    }

    public static File implGetMountPoint(File path) {
        if (!NativeUtils.hasNatives()) {
            return null;
        }
        if (path == null) {
            throw new NullPointerException();
        }
        File file = path.getAbsoluteFile();
        while (file != null) {
            if (!file.exists()) {
                if (file.getParent() == null) {
                    return file;
                }
                file = file.getParentFile();
                continue;
            }
            int type = NativeUtils.nativeGetLinkType(file.getAbsolutePath());
            switch (type) {
                case 0: {
                    if (file.getParent() == null) {
                        return file;
                    }
                    file = file.getParentFile();
                    break;
                }
                case 1: {
                    String target = NativeUtils.nativeGetLinkTarget(file.getAbsolutePath());
                    if (target == null) {
                        if (file.getParent() == null) {
                            return file;
                        }
                        file = file.getParentFile();
                        break;
                    }
                    file = new File(target);
                    break;
                }
                case 2: {
                    String target = NativeUtils.nativeGetLinkTarget(file.getAbsolutePath());
                    if (target == null) {
                        return file;
                    }
                    file = new File(target);
                    break;
                }
            }
        }
        return null;
    }

    public static long implGetFreeSpace(File path) {
        long overrideDiskSpace = DeviceSystemUtil.getOverrideDiskSpace();
        if (overrideDiskSpace >= 0L) {
            log.warning(Messages.Override_Disk_Space, Long.toString(overrideDiskSpace));
            return overrideDiskSpace;
        }
        if (!NativeUtils.hasNatives()) {
            return -1L;
        }
        if (path == null) {
            throw new NullPointerException();
        }
        File file = path.getAbsoluteFile();
        if (file.isFile()) {
            file = file.getParentFile();
        }
        while (file != null) {
            if (file.exists()) {
                long diskSpace = file.getUsableSpace();
                if (diskSpace == 0L) {
                    diskSpace = NativeUtils.nativeGetFreeSpace(file.getAbsolutePath());
                }
                return diskSpace;
            }
            file = file.getParentFile();
        }
        return -1L;
    }
}

