/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.utils;

import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Status;

class CicStatus
extends Status
implements ICicStatus {
    private static final Logger log = Logger.getLogger(CicStatus.class);
    private static final Pattern ARG_PATTERN = Pattern.compile("\\{(\\d+)\\}");
    private final String uid;
    private final String explanation;
    private final String userAction;
    private String origMessage;
    private Object[] messageArgs;

    CicStatus(String pluginId, int severity, int code, String uid, String explanation, String userAction, Throwable exception, String origMessage, Object ... messageArgs) {
        super(severity, pluginId, code, messageArgs.length == 0 ? origMessage : NLS.bind(origMessage, messageArgs), exception);
        this.uid = uid;
        this.explanation = explanation;
        this.userAction = userAction;
        this.origMessage = origMessage;
        this.messageArgs = messageArgs;
        this.checkSeverityConsistency();
        this.verifyArguments();
    }

    protected void setMessage(String message) {
        this.origMessage = message;
        this.messageArgs = new Object[0];
        super.setMessage(message);
    }

    private void verifyArguments() {
        Matcher matcher = ARG_PATTERN.matcher(this.origMessage);
        int expectedArgs = 0;
        while (matcher.find()) {
            int num = Integer.valueOf(matcher.group(1));
            if (num < expectedArgs) continue;
            expectedArgs = num + 1;
        }
        if (this.messageArgs.length != expectedArgs) {
            log.warningNoUid("Internal error: expected {0} args, got {1} args for message: {2}", expectedArgs, this.messageArgs.length, this.origMessage);
        }
    }

    private void checkSeverityConsistency() {
        if (this.uid != null) {
            int expectedSeverity = -1;
            switch (this.uid.charAt(this.uid.length() - 1)) {
                case 'E': {
                    expectedSeverity = 4;
                    break;
                }
                case 'W': {
                    expectedSeverity = 2;
                    break;
                }
                case 'I': {
                    expectedSeverity = 1;
                    break;
                }
                default: {
                    this.reportError("Internal error: UID should end with 'E', 'W', or 'I': {0}", this.uid);
                    return;
                }
            }
            if (this.getSeverity() != expectedSeverity) {
                this.reportError("Internal error: inconsistent severity for UID {0}: expected {1} but was {2}", this.uid, StatusUtil.severityToString(expectedSeverity), StatusUtil.severityToString(this.getSeverity()));
            }
        }
    }

    private void reportError(String msg, Object ... args) {
        if (this.uid.startsWith("CRIM")) {
            assert (false) : NLS.bind(msg, args);
        } else {
            log.warningNoUid(msg, args);
        }
    }

    public String toString() {
        return StatusUtil.toString(this);
    }

    @Override
    public String getExplanation() {
        return this.explanation;
    }

    @Override
    public String getUserAction() {
        return this.userAction;
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public String getOrigMessage() {
        return this.origMessage;
    }

    @Override
    public Object[] getMessageArgs() {
        return this.messageArgs;
    }

    @Override
    public boolean isErrorOrCancel() {
        return this.matches(12);
    }

    @Override
    public boolean isError() {
        return this.matches(4);
    }

    @Override
    public boolean isCancel() {
        return this.matches(8);
    }

    @Override
    public boolean isWarning() {
        return this.matches(2);
    }

    @Override
    public boolean isInfo() {
        return this.matches(1);
    }
}

