/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.utils;

import com.ibm.cic.common.core.utils.CallStack;
import com.ibm.cic.common.core.utils.NLS;
import java.util.Arrays;

public class Check {
    private Check() {
        Check.failNoInstances();
    }

    public static void isTrue(boolean cond) {
        if (!cond) {
            Check.fail();
        }
    }

    public static void isTrue(boolean cond, Object msg) {
        if (!cond) {
            Check.fail(msg);
        }
    }

    public static void isTrue(boolean cond, String msg, Object ... args) {
        if (!cond) {
            Check.fail(msg, args);
        }
    }

    public static void notTrue(boolean cond) {
        if (cond) {
            Check.fail();
        }
    }

    public static void notTrue(boolean cond, Object msg) {
        if (cond) {
            Check.fail(msg);
        }
    }

    public static void notTrue(boolean cond, String msg, Object ... args) {
        if (cond) {
            Check.fail(msg, args);
        }
    }

    public static <T> T notNull(T ref) {
        if (ref == null) {
            Check.fail();
        }
        return ref;
    }

    public static <T> T notNull(T ref, Object msg) {
        if (ref == null) {
            Check.fail(msg);
        }
        return ref;
    }

    public static <T> T notNull(T ref, String msg, Object ... args) {
        if (ref == null) {
            Check.fail(msg, args);
        }
        return ref;
    }

    public static AssertionError failNoInstances() {
        StackTraceElement caller = CallStack.getCaller();
        throw Check.fail("{0} may not have instances created", caller.getClassName());
    }

    public static AssertionError fail() {
        throw new AssertionError();
    }

    public static AssertionError fail(Object msg) {
        throw new AssertionError((Object)(msg instanceof Object[] ? Arrays.toString((Object[])msg) : String.valueOf(msg)));
    }

    public static AssertionError fail(String msg, Object ... args) {
        throw new AssertionError((Object)(args.length == 0 ? msg : NLS.bind(msg, args)));
    }

    public static AssertionError missingCase(Object value) {
        return Check.fail("Missing case for: {0}", value);
    }
}

