/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.utils;

import com.ibm.cic.common.core.cmd.CmdCommand;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.internal.adaptor.EclipseEnvironmentInfo;

public class ApplicationArguments {
    private static ApplicationArguments _instance = null;
    private final String[] originalArguments = EclipseEnvironmentInfo.getDefault().getNonFrameworkArgs();
    private ArrayList<String> arguments;

    public static ApplicationArguments getInstance() {
        if (_instance == null) {
            _instance = new ApplicationArguments();
        }
        return _instance;
    }

    private ApplicationArguments() {
        this.initialize();
    }

    @Deprecated
    public static ApplicationArguments reloadInstance() {
        _instance = new ApplicationArguments();
        return _instance;
    }

    public String toString() {
        return this.arguments.toString();
    }

    public void add(String ... args) {
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String a = stringArray[n2];
            this.arguments.add(a);
            ++n2;
        }
        this.save();
    }

    private void save() {
        String[] args = this.arguments.toArray(new String[this.arguments.size()]);
        EclipseEnvironmentInfo.setAppArgs((String[])args);
    }

    public void restore() {
        this.initialize();
        EclipseEnvironmentInfo.setAppArgs((String[])this.originalArguments);
    }

    private void initialize() {
        this.arguments = this.originalArguments == null ? new ArrayList(0) : new ArrayList<String>(Arrays.asList(this.originalArguments));
    }

    public String getNextArg(CmdCommand cmd) {
        int index = this.indexOf(cmd);
        if (index >= 0 && index < this.arguments.size() - 1) {
            return this.arguments.get(index + 1);
        }
        return null;
    }

    public boolean replace(CmdCommand oldCmd, CmdCommand newCmd) {
        int index = this.indexOf(oldCmd);
        if (index < 0) {
            return false;
        }
        this.arguments.set(index, newCmd.id());
        this.save();
        return true;
    }

    public boolean isEmpty() {
        return this.arguments.isEmpty();
    }

    public boolean contains(String value) {
        return this.indexOf(value) >= 0;
    }

    public boolean contains(CmdCommand cmd) {
        return this.indexOf(cmd) >= 0;
    }

    private int indexOf(String arg) {
        int i = 0;
        while (i < this.arguments.size()) {
            if (arg.equalsIgnoreCase(this.arguments.get(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int indexOf(CmdCommand cmd) {
        int i = 0;
        while (i < this.arguments.size() - 1) {
            if (cmd.findCommand(this.arguments.get(i)) != null) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

