/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.utils;

import com.ibm.cic.common.core.internal.utils.CicServiceabilityProvider;
import com.ibm.cic.common.core.internal.utils.IServiceabilityProvider;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.CicStatus;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.IStatusFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractStatuses {
    private final String pluginId;
    private final IServiceabilityProvider provider;
    public final IStatusFactory OK_STATUS;
    public final IStatusFactory INFO_STATUS;
    public final IStatusFactory CANCEL_STATUS;
    public final IStatusFactory WARNING_STATUS;
    public final IStatusFactory ERROR_STATUS;

    public static ICicStatus createStatus(String pluginId, int severity, int code, String uid, String explanation, String userAction, Throwable exception, String msg, Object ... args) {
        return new CicStatus(pluginId, severity, code, uid, explanation, userAction, exception, msg, args);
    }

    protected AbstractStatuses(String pluginId) {
        this.pluginId = pluginId;
        this.provider = new CicServiceabilityProvider();
        this.OK_STATUS = new StatusFactory(this, 0);
        this.INFO_STATUS = new StatusFactory(this, 1);
        this.CANCEL_STATUS = new StatusFactory(this, 8);
        this.WARNING_STATUS = new StatusFactory(this, 2);
        this.ERROR_STATUS = new StatusFactory(this, 4);
    }

    public void initializeMessages(String bundleName, Class messages) {
        NLS.initializeMessages((String)bundleName, (Class)messages);
        this.provider.initializeMessages(messages);
    }

    public ICicStatus createStatus(int severity, int code, Throwable exception, String msg, Object ... args) {
        if (msg == null) {
            msg = "";
        }
        return AbstractStatuses.createStatus(this.pluginId, severity, code, this.provider.getUid(msg), this.provider.getExplanation(msg), this.provider.getUserAction(msg), exception, msg, args);
    }

    public ICicStatus createStatus(IStatus status, String msg, Object ... args) {
        return this.createStatus(status.getSeverity(), status.getCode(), status.getException(), msg, args);
    }

    public CicMultiStatus createMultiStatus(String plugin, int severity, int code, IStatus[] children, Throwable exception, String msg, Object ... args) {
        if (msg == null) {
            msg = "";
        }
        return new CicMultiStatus(plugin, severity, code, this.provider.getUid(msg), this.provider.getExplanation(msg), this.provider.getUserAction(msg), children, exception, msg, args);
    }

    public CicMultiStatus createMultiStatus(String plugin, int severity, int code, IStatus[] children, Throwable exception, String msg) {
        return this.createMultiStatus(plugin, severity, code, children, exception, msg, new Object[0]);
    }

    public CicMultiStatus createMultiStatus(int severity, int code, IStatus[] children, Throwable exception, String msg, Object ... args) {
        return this.createMultiStatus(this.pluginId, severity, code, children, exception, msg, args);
    }

    public CicMultiStatus createMultiStatus() {
        return this.createMultiStatus(0, 0, null, null, null, new Object[0]);
    }

    public CicMultiStatus createMultiStatus(String msg, Object ... args) {
        return this.createMultiStatus(this.pluginId, 0, 0, null, null, msg, args);
    }

    public CicMultiStatus createMultiStatus(int code, IStatus[] children, String msg, Object ... args) {
        return this.createMultiStatus(0, code, children, null, msg, args);
    }

    public CicMultiStatus createMultiStatus(int code, IStatus child, String msg, Object ... args) {
        return this.createMultiStatus(0, code, new IStatus[]{child}, null, msg, args);
    }

    public CicMultiStatus createMultiStatus(int code, String msg, Object ... args) {
        return this.createMultiStatus(0, code, null, null, msg, args);
    }

    public CicMultiStatus createMultiStatus(int code, Throwable exception, String msg, Object ... args) {
        return this.createMultiStatus(0, code, null, exception, msg, args);
    }

    public CicMultiStatus createMultiStatus(IStatus[] children, String msg, Object ... args) {
        return this.createMultiStatus(0, 0, children, null, msg, args);
    }

    public CicMultiStatus createMultiStatusWithChild(IStatus child, String msg, Object ... args) {
        return this.createMultiStatus(new IStatus[]{child}, msg, args);
    }

    public CicMultiStatus createMultiStatusFromStatus(IStatus status) {
        String plugin = status.getPlugin();
        int severity = status.getSeverity();
        int code = status.getCode();
        IStatus[] children = status.getChildren();
        Throwable exception = status.getException();
        if (status instanceof ICicStatus) {
            ICicStatus cs = (ICicStatus)status;
            return this.createMultiStatus(plugin, severity, code, children, exception, cs.getOrigMessage(), cs.getMessageArgs());
        }
        return this.createMultiStatus(plugin, severity, code, children, exception, status.getMessage());
    }

    CicMultiStatus createMultiStatusFromStatus(IStatus status, String newMsg, Object ... newArgs) {
        return this.createMultiStatus(status.getPlugin(), status.getSeverity(), status.getCode(), status.getChildren(), status.getException(), newMsg, newArgs);
    }

    private static class StatusFactory
    implements IStatusFactory {
        private final AbstractStatuses statuses;
        private final int severity;

        StatusFactory(AbstractStatuses statuses, int severity) {
            this.statuses = statuses;
            this.severity = severity;
        }

        @Override
        public ICicStatus get(int code, Throwable exception, String msg, Object ... args) {
            return this.statuses.createStatus(this.severity, code, exception, msg, args);
        }

        @Override
        public ICicStatus get(String msg, Object ... args) {
            return this.statuses.createStatus(this.severity, 0, null, msg, args);
        }

        @Override
        public ICicStatus get(int code, String msg, Object ... args) {
            return this.statuses.createStatus(this.severity, code, null, msg, args);
        }

        @Override
        public ICicStatus get(Throwable exception, String msg, Object ... args) {
            return this.statuses.createStatus(this.severity, 0, exception, msg, args);
        }

        @Override
        public CicMultiStatus getMultiStatus() {
            return this.getMultiStatus(null, new Object[0]);
        }

        @Override
        public CicMultiStatus getMultiStatus(String msg, Object ... args) {
            return this.statuses.createMultiStatus(this.severity, 0, null, null, msg, args);
        }

        @Override
        public CicMultiStatus getMultiStatus(IStatus[] children, String msg, Object ... args) {
            return this.statuses.createMultiStatus(this.severity, 0, children, null, msg, args);
        }

        @Override
        public CicMultiStatus getMultiStatus(int code, IStatus[] children, String msg, Object ... args) {
            return this.statuses.createMultiStatus(this.severity, code, children, null, msg, args);
        }

        @Override
        public CicMultiStatus getMultiStatus(int code, IStatus[] children, Throwable exception, String msg, Object ... args) {
            return this.statuses.createMultiStatus(this.severity, code, children, exception, msg, args);
        }
    }
}

