/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.repository.digest;

import com.ibm.cic.common.core.internal.downloads.FileContentInfo;
import com.ibm.cic.common.core.internal.utils.CicConstants;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.repository.digest.IRepositoryDigestXML;
import com.ibm.cic.common.core.utils.XMLWriter;
import com.ibm.cic.common.downloads.DigestValue;
import com.ibm.cic.common.downloads.IContentInfo;
import java.util.List;

public class RepositoryDigestTocEntry
implements IRepositoryDigestXML {
    private String alias;
    private final FileContentInfo contentInfo;

    RepositoryDigestTocEntry(ICicLocation fileName, String alias, IContentInfo contentInfo) {
        assert (fileName != null);
        this.setAlias(alias);
        if (contentInfo == null) {
            this.contentInfo = new FileContentInfo(null, fileName);
        } else {
            this.contentInfo = new FileContentInfo(contentInfo);
            if (this.contentInfo.getFileName() == CicConstants.EMPTY_LOCATION) {
                this.contentInfo.setFileName(fileName);
            }
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof RepositoryDigestTocEntry) {
            RepositoryDigestTocEntry rhs = (RepositoryDigestTocEntry)o;
            if (!rhs.getFileName().equals(this.getFileName())) {
                return false;
            }
            if (!rhs.alias.equals(this.alias)) {
                return false;
            }
            if (!rhs.contentInfo.getDigestSet().equals(this.contentInfo.getDigestSet())) {
                return false;
            }
            return rhs.contentInfo.getSizeInfo().equals(this.contentInfo.getSizeInfo());
        }
        return false;
    }

    public int hashCode() {
        int h = this.getFileName().hashCode();
        h += h * 7 + this.alias.hashCode();
        h += h * 7 + this.contentInfo.getDigestSet().hashCode();
        h += h * 7 + this.contentInfo.getSizeInfo().hashCode();
        return h;
    }

    private void setAlias(String alias) {
        this.alias = alias != null ? alias : "";
    }

    ICicLocation getFileName() {
        return this.contentInfo.getFileName();
    }

    public FileContentInfo getContentInfo() {
        return this.contentInfo;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("file='");
        sb.append(this.getFileName());
        sb.append("'");
        sb.append(" alias='");
        sb.append(this.alias);
        sb.append("' ");
        sb.append(this.contentInfo);
        sb.append(" file2='");
        return sb.toString();
    }

    void emitXML(XMLWriter writer) {
        long downloadSize;
        writer.start("file");
        writer.attribute("name", this.getFileName().toString());
        if (this.alias.length() > 0) {
            writer.attribute("alias", this.alias);
        }
        if ((downloadSize = this.getContentInfo().getSizeInfo().getDownloadSize()) != Long.MIN_VALUE) {
            writer.attribute("size", Long.toString(downloadSize));
        }
        List<DigestValue> digests = this.getContentInfo().getDigests();
        for (DigestValue dv : digests) {
            writer.attribute(dv.getAlgorithm().toUpperCase(), dv.getDigestAsString());
        }
        writer.end("file");
    }
}

