/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.repository.digest;

import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.internal.repository.RepositoryUpdateOfferingHandler;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.Information;
import com.ibm.cic.common.core.model.internal.IFixInternal;
import com.ibm.cic.common.core.model.proxy.FixReference;
import com.ibm.cic.common.core.model.proxy.IFixReference;
import com.ibm.cic.common.core.model.proxy.IOfferingReference;
import com.ibm.cic.common.core.model.proxy.OfferingReference;
import com.ibm.cic.common.core.model.utils.FixProperty;
import com.ibm.cic.common.core.model.utils.LicenseUtils;
import com.ibm.cic.common.core.model.utils.OfferingOrFixProperty;
import com.ibm.cic.common.core.model.utils.OfferingProperty;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.repository.IContentRepository;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.RepositoryUtils;
import com.ibm.cic.common.core.repository.digest.RepositoryDigestBaseOfferingData;
import com.ibm.cic.common.core.repository.digest.RepositoryDigestDictionary;
import com.ibm.cic.common.core.repository.digest.RepositoryDigestFixData;
import com.ibm.cic.common.core.repository.digest.RepositoryDigestOfferingData;
import com.ibm.cic.common.core.repository.digest.RepositoryDigestToc;
import com.ibm.cic.common.core.repository.nls.NLSUtils;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.LinkedProperties;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.UserOptions;
import com.ibm.cic.common.core.utils.XMLWriter;
import com.ibm.cic.common.logging.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class RepositoryDigestRepositoryData {
    private static final Logger log = Logger.getLogger(RepositoryDigestRepositoryData.class);
    private static final List<String> LANG_LIST = new ArrayList<String>(NLSUtils.calculateBundleNames("default"));
    private static final String[] KEYS_OF_INTEREST = new String[]{"offering.type", "default.profile", "default.user.profile", "vendor.name", "offering.service.repositories"};
    private LinkedProperties m_dictionaries = new LinkedProperties();
    private final String m_name;
    private final String m_location;
    private boolean m_useContentData = false;
    private LinkedProperties m_properties = new LinkedProperties();
    private List<RepositoryDigestOfferingData> m_offeringAndUpdateDatas = new ArrayList<RepositoryDigestOfferingData>();
    private List<RepositoryDigestFixData> m_fixDatas = new ArrayList<RepositoryDigestFixData>();
    private List<RepositoryDigestRepositoryData> m_repositoryData = new ArrayList<RepositoryDigestRepositoryData>();
    private RepositoryDigestToc m_toc = new RepositoryDigestToc();
    private boolean m_digestDataCleared = false;

    public String toSimpleString() {
        return "Loc:" + this.m_location + " Name:" + this.m_name + " UseContent:" + this.m_useContentData + " Dict_size:" + this.m_dictionaries.size() + " Props:\n" + this.m_properties;
    }

    public String toString() {
        return String.valueOf(this.toSimpleString()) + this.m_offeringAndUpdateDatas + this.m_fixDatas;
    }

    public RepositoryDigestRepositoryData() {
        this(null, null);
    }

    RepositoryDigestRepositoryData(String a_name, String a_location) {
        this.m_name = a_name != null ? a_name : "";
        this.m_location = a_location != null ? a_location : "";
    }

    void setProperty(String key, String value) {
        this.m_properties.setProperty(key, value);
    }

    void addOfferingData(RepositoryDigestOfferingData offeringData) {
        this.m_offeringAndUpdateDatas.remove(offeringData);
        this.m_offeringAndUpdateDatas.add(offeringData);
        offeringData.setParent(this);
        offeringData.setPlatformSlice(this.m_properties);
        offeringData.setUnavailableReason(this.m_properties);
        this.addUpdateProperty(offeringData);
    }

    void addFixData(RepositoryDigestFixData fixData) {
        this.m_fixDatas.remove(fixData);
        this.m_fixDatas.add(fixData);
        fixData.setUnavailableReason(this.m_properties);
        fixData.setParent(this);
    }

    void addUpdateProperty(RepositoryDigestOfferingData offeringData) {
        offeringData.addUpdateProperty(this.m_properties);
    }

    private boolean badFixMissingApplicableOffering(RepositoryDigestFixData rdfd) {
        if (rdfd.isEnhancedFix()) {
            return rdfd.getApplicableOfferings().isEmpty();
        }
        return false;
    }

    private boolean badFixMissingRecommended(RepositoryDigestFixData rdfd) {
        return !rdfd.getTranslatedProperties().containsKey("recommended");
    }

    private boolean badFix(RepositoryDigestFixData rdfd) {
        return this.badFixMissingApplicableOffering(rdfd) || this.badFixMissingRecommended(rdfd);
    }

    private boolean cwaRepository(ICicLocation remotePath) {
        if (remotePath == null) {
            return false;
        }
        return remotePath.toString().matches("https?://[^/]*\\.ibm\\.com/software/repositorymanager.*");
    }

    void end(String inputStreamUrl, ICicLocation remotePath) {
        Iterator<RepositoryDigestFixData> iterator = this.m_fixDatas.iterator();
        while (iterator.hasNext()) {
            RepositoryDigestFixData rdfd = iterator.next();
            boolean ignoreFix = false;
            if (!this.badFix(rdfd)) continue;
            if (UserOptions.CIC_IGNORE_BAD_FIXES.isValueAll()) {
                ignoreFix = true;
            } else if (!UserOptions.CIC_IGNORE_BAD_FIXES.isValueNone() && UserOptions.CIC_IGNORE_BAD_FIXES.isValueEntitled() && this.cwaRepository(remotePath)) {
                ignoreFix = true;
            }
            if (!ignoreFix) continue;
            ICicStatus ws = Statuses.WARNING.get(Messages.RepositoryDigest_FixDigestBad, inputStreamUrl, rdfd.toString());
            CicMultiStatus ms = Statuses.ST.createMultiStatusFromStatus(ws);
            if (this.badFixMissingRecommended(rdfd)) {
                ms.add(Statuses.WARNING.get(Messages.RepositoryDigest_FixDigestMissingRecommendedProperty, new Object[0]));
            }
            if (this.badFixMissingApplicableOffering(rdfd)) {
                ms.add(Statuses.WARNING.get(Messages.RepositoryDigest_FixDigestMissingApplicableOfferingProperty, new Object[0]));
            }
            ms.add(Statuses.WARNING.get(Messages.RepositoryDigest_FixDigestIgnoredDueToSystemProperty, UserOptions.CIC_IGNORE_BAD_FIXES.getName(), UserOptions.CIC_IGNORE_BAD_FIXES.value(), "none"));
            log.status(ms);
            iterator.remove();
        }
    }

    void setToc(RepositoryDigestToc a_toc) {
        assert (a_toc != null);
        this.m_toc = a_toc;
    }

    private LinkedProperties getFilteredProperties() {
        LinkedProperties result = new LinkedProperties();
        String[] stringArray = this.m_properties.getPropertyKeys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (!RepositoryUpdateOfferingHandler.isUpdateProperty(name)) {
                result.setProperty(name, this.m_properties.getProperty(name));
            }
            ++n2;
        }
        return result;
    }

    void emitXML(XMLWriter writer, boolean emitLocation) {
        writer.start("repository");
        if (this.m_name.length() > 0) {
            writer.attribute("name", this.m_name);
        }
        if (emitLocation) {
            writer.attribute("location", this.m_location);
        }
        if (!this.useContentData()) {
            writer.attribute("useContentData", false);
        }
        writer.write(this.getFilteredProperties());
        for (RepositoryDigestOfferingData offeringData : this.m_offeringAndUpdateDatas) {
            offeringData.emitXML(writer);
        }
        for (RepositoryDigestFixData fixData : this.m_fixDatas) {
            fixData.emitXML(writer);
        }
        this.m_toc.emitXML(writer);
        for (RepositoryDigestRepositoryData repData : this.m_repositoryData) {
            repData.emitXML(writer, true);
        }
        for (RepositoryDigestDictionary dick : this.m_dictionaries.values()) {
            dick.emitXML(writer);
        }
        writer.end("repository");
    }

    List<IOfferingReference> getOfferingReferences(boolean includeUnavailable) {
        if (!this.m_repositoryData.isEmpty()) {
            ArrayList<IOfferingReference> result = new ArrayList<IOfferingReference>();
            for (RepositoryDigestRepositoryData repData : this.m_repositoryData) {
                result.addAll(repData.getOfferingReferences(includeUnavailable));
            }
            return result;
        }
        return this.getThisRepositoryOnlyOfferingReferences(includeUnavailable);
    }

    public List<IOfferingReference> getThisRepositoryOnlyOfferingReferences(boolean includeUnavailable) {
        ArrayList<IOfferingReference> result = new ArrayList<IOfferingReference>();
        for (RepositoryDigestOfferingData offeringData : this.m_offeringAndUpdateDatas) {
            if (offeringData.isUpdate() || !includeUnavailable && offeringData.getUnavailableReason() != null) continue;
            offeringData.performNlUpdate();
            result.add(new OfferingReference(offeringData));
        }
        return result;
    }

    List<IFixReference> getFixReferences(boolean includeUnavailable) {
        ArrayList<IFixReference> result = new ArrayList<IFixReference>();
        if (!this.m_repositoryData.isEmpty()) {
            for (RepositoryDigestRepositoryData repData : this.m_repositoryData) {
                result.addAll(repData.getFixReferences(includeUnavailable));
            }
        } else {
            for (RepositoryDigestFixData fixData : this.m_fixDatas) {
                if (!includeUnavailable && fixData.getUnavailableReason() != null) continue;
                fixData.performNlUpdate();
                result.add(new FixReference(fixData));
            }
        }
        return result;
    }

    List<IOfferingReference> getUpdates(boolean includeUnavailable) {
        ArrayList<IOfferingReference> result = new ArrayList<IOfferingReference>();
        if (this.m_properties.getProperty("LayoutPolicy").equals("CompositeRepository")) {
            for (RepositoryDigestRepositoryData repData : this.m_repositoryData) {
                result.addAll(repData.getUpdates(includeUnavailable));
            }
        } else {
            for (RepositoryDigestOfferingData offeringData : this.m_offeringAndUpdateDatas) {
                if (!offeringData.isUpdate() || !includeUnavailable && offeringData.getUnavailableReason() != null) continue;
                offeringData.performNlUpdate();
                OfferingReference or = new OfferingReference(offeringData);
                or.setUpdate(offeringData.getBaseOfferingData());
                result.add(or);
            }
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o instanceof RepositoryDigestRepositoryData) {
            RepositoryDigestRepositoryData other = (RepositoryDigestRepositoryData)o;
            if (other.m_location == this.m_location) {
                return true;
            }
            if (this.m_location.equals(other.m_location)) {
                return true;
            }
            return super.equals(o);
        }
        return false;
    }

    public int hashCode() {
        return this.m_location.hashCode() * 3 + this.m_name.hashCode() * 3;
    }

    void clear() {
        this.clearDigestInfo();
        if (this.m_properties.size() > 0) {
            this.m_properties.clear();
        }
        if (this.m_repositoryData.size() > 0) {
            this.m_repositoryData.clear();
        }
        if (this.m_dictionaries.size() > 0) {
            this.m_dictionaries.clear();
        }
    }

    public void clearDigestInfo() {
        if (this.m_offeringAndUpdateDatas.size() > 0 || this.m_fixDatas.size() > 0) {
            this.m_offeringAndUpdateDatas.clear();
            this.m_fixDatas.clear();
        }
        if (!this.m_toc.isEmpty()) {
            this.m_toc.clear();
        }
        for (RepositoryDigestRepositoryData repData : this.m_repositoryData) {
            repData.clearDigestInfo();
        }
        this.m_digestDataCleared = true;
        this.setUseContentData(false);
    }

    public IStatus addOfferingDigestData(IOffering of, IProgressMonitor progressMonitor) {
        boolean resolveAndUnresolveOffering;
        IStatus return_value = Status.OK_STATUS;
        boolean bl = resolveAndUnresolveOffering = !of.isResolved();
        if (resolveAndUnresolveOffering) {
            return_value = this.resolve(of, progressMonitor);
        }
        if (!StatusUtil.isErrorOrCancel(return_value)) {
            boolean validateImportProfile;
            boolean importEnabled;
            boolean supportsWebUIMode;
            boolean supportsPortableMode;
            String supportedPlatforms;
            boolean betaInstallationOnly;
            boolean betaCompatible;
            boolean supportsGroupMode;
            boolean supportsConsoleMode;
            ArrayList translatable = new ArrayList();
            RepositoryDigestOfferingData odd = new RepositoryDigestOfferingData(of.getIdentity(), of.getVersion());
            Information ofInfo = of.getInformation();
            if (ofInfo != null) {
                odd.setInformation(ofInfo);
                NLSUtils.addKeyToCollectionIfNlKey(ofInfo.getNameKey(), translatable);
                NLSUtils.addKeyToCollectionIfNlKey(ofInfo.getDescriptionKey(), translatable);
            }
            odd.setBaseOfferingInfo(RepositoryDigestBaseOfferingData.createOfferingUpdate(of));
            IContentRepository contRep = RepositoryUtils.getContentRepository(of);
            odd.addTocEntryList(of.getLocation(), contRep);
            translatable.addAll(odd.addUntranslatedProperties(of, KEYS_OF_INTEREST));
            boolean requiresAdmin = OfferingProperty.requiresAdminUser(of);
            if (!requiresAdmin) {
                odd.addUntranslatedProperty("offering.RequiresAdmin", Boolean.toString(requiresAdmin));
            }
            if (supportsConsoleMode = OfferingProperty.supportsConsoleMode(of)) {
                odd.addUntranslatedProperty("supports.console.mode", Boolean.toString(supportsConsoleMode));
            }
            if (supportsGroupMode = OfferingProperty.supportsGroupMode(of)) {
                odd.addUntranslatedProperty("offering.SupportsGroupMode", Boolean.toString(supportsGroupMode));
            }
            if (betaCompatible = OfferingProperty.isBetaCompatible(of)) {
                odd.addUntranslatedProperty("beta.compatible", Boolean.toString(betaCompatible));
            }
            if (betaInstallationOnly = OfferingProperty.isBetaInstallationOnly(of)) {
                odd.addUntranslatedProperty("beta.installation.only", Boolean.toString(betaInstallationOnly));
            }
            String license_kinds = LicenseUtils.getLicenseKinds(of, false);
            odd.addUntranslatedProperty("OfferingReference.LicensesKinds", license_kinds);
            String lum_id = LicenseUtils.getOfferingLumIdsAsString(of);
            odd.addUntranslatedProperty("OfferingReference.enablement.lum.id", lum_id);
            String lum_ver = LicenseUtils.getOfferingLumVersionsAsString(of);
            odd.addUntranslatedProperty("OfferingReference.enablement.lum.version", lum_ver);
            String supportedOS = OfferingProperty.getSupportedOS(of);
            if (supportedOS.length() > 0) {
                odd.addUntranslatedProperty("supportedOS", supportedOS);
            }
            if ((supportedPlatforms = OfferingProperty.getSupportedPlatforms(of)) != null) {
                odd.addUntranslatedProperty("supportedPlatforms", supportedPlatforms);
            }
            if (supportsPortableMode = OfferingOrFixProperty.supportsPortable(of)) {
                odd.addUntranslatedProperty("supports.portable", Boolean.toString(supportsPortableMode));
            }
            if (supportsWebUIMode = OfferingOrFixProperty.supportsWebUI(of)) {
                odd.addUntranslatedProperty("supports.web.ui", Boolean.toString(supportsWebUIMode));
            }
            if (importEnabled = OfferingProperty.isImportEnabled(of)) {
                odd.addUntranslatedProperty("import.enabled", Boolean.toString(importEnabled));
            }
            if (validateImportProfile = OfferingProperty.validateImportProfile(of)) {
                odd.addUntranslatedProperty("import.profile.validation", Boolean.toString(validateImportProfile));
            }
            this.addNonDefaultProperty(odd, of, "extension.of.extension", false);
            this.addNonDefaultProperty(odd, of, "offering.display.after", "");
            boolean showPkgInstalledDlg = OfferingProperty.showHasBeenInstalledDialog(of);
            if (!showPkgInstalledDlg) {
                odd.addUntranslatedProperty("offering.showDialog.installed", Boolean.toString(showPkgInstalledDlg));
            }
            odd.addRepositoryDigestDictionaryList(translatable, contRep);
            this.addOfferingData(odd);
        }
        if (resolveAndUnresolveOffering) {
            RepositoryUtils.unresolve(of);
        }
        return return_value;
    }

    private IStatus resolve(IOfferingOrFix oof, IProgressMonitor monitor) {
        IStatus status = RepositoryUtils.resolve(oof, monitor);
        if (status.isOK() || status.getCode() == 6058) {
            return Status.OK_STATUS;
        }
        return status;
    }

    private void addNonDefaultProperty(RepositoryDigestOfferingData odd, IOffering offering, String key, boolean defaultValue) {
        this.addNonDefaultProperty(odd, offering, key, Boolean.toString(defaultValue));
    }

    private void addNonDefaultProperty(RepositoryDigestOfferingData odd, IOffering offering, String key, String defaultValue) {
        String value = offering.getProperties().getProperty(key, defaultValue);
        if (!defaultValue.equals(value)) {
            odd.addUntranslatedProperty(key, value);
        }
    }

    public IStatus addFixDigestData(IFix a_fix, IProgressMonitor pm) {
        IStatus return_value = this.resolve(a_fix, pm);
        if (!StatusUtil.isErrorOrCancel(return_value)) {
            boolean supportsGroupMode;
            boolean importEnabled;
            boolean supportsPortableMode;
            String supportedPlatforms;
            ArrayList translatable = new ArrayList();
            RepositoryDigestFixData fdd = null;
            fdd = a_fix.isEnhancedFix() ? new RepositoryDigestFixData(a_fix.getIdentity(), a_fix.getVersion(), a_fix.getApplicableOfferings()) : new RepositoryDigestFixData(a_fix.getIdentity(), a_fix.getVersion(), ((IFixInternal)((Object)a_fix)).getInternalOfferingId(), ((IFixInternal)((Object)a_fix)).getInternalOfferingVersion());
            Information fixInfo = a_fix.getInformation();
            if (fixInfo != null) {
                fdd.setInformation(fixInfo);
                NLSUtils.addKeyToCollectionIfNlKey(fixInfo.getNameKey(), translatable);
                NLSUtils.addKeyToCollectionIfNlKey(fixInfo.getDescriptionKey(), translatable);
            }
            IContentRepository contRep = RepositoryUtils.getContentRepository(a_fix);
            fdd.addTocEntryList(a_fix.getLocation(), contRep);
            boolean betaCompatible = OfferingProperty.isBetaCompatible(a_fix);
            if (betaCompatible) {
                fdd.addUntranslatedProperty("beta.compatible", Boolean.toString(betaCompatible));
            }
            boolean recommended = FixProperty.isRecommended(a_fix);
            fdd.addUntranslatedProperty("recommended", Boolean.toString(recommended));
            boolean betaInstallationOnly = OfferingProperty.isBetaInstallationOnly(a_fix);
            if (betaInstallationOnly) {
                fdd.addUntranslatedProperty("beta.installation.only", Boolean.toString(betaInstallationOnly));
            }
            if ((supportedPlatforms = OfferingProperty.getSupportedPlatforms(a_fix)) != null) {
                fdd.addUntranslatedProperty("supportedPlatforms", supportedPlatforms);
            }
            if (supportsPortableMode = OfferingOrFixProperty.supportsPortable(a_fix)) {
                fdd.addUntranslatedProperty("supports.portable", Boolean.toString(supportsPortableMode));
            }
            if (importEnabled = OfferingProperty.isImportEnabled(a_fix)) {
                fdd.addUntranslatedProperty("import.enabled", Boolean.toString(importEnabled));
            }
            if (supportsGroupMode = OfferingProperty.supportsGroupMode(a_fix)) {
                fdd.addUntranslatedProperty("offering.SupportsGroupMode", Boolean.toString(supportsGroupMode));
            }
            translatable.addAll(fdd.addUntranslatedProperties(a_fix, KEYS_OF_INTEREST));
            fdd.addRepositoryDigestDictionaryList(translatable, contRep);
            this.addFixData(fdd);
        }
        return return_value;
    }

    public LinkedProperties getProperties() {
        return this.m_properties;
    }

    public boolean useContentData() {
        return this.m_useContentData;
    }

    public void setUseContentData(boolean contentData) {
        this.m_useContentData = contentData;
    }

    public RepositoryDigestRepositoryData getRepositoryDigestData(String name, String location) {
        assert (location != null);
        RepositoryDigestRepositoryData return_value = this.findRepositoryDigestData(location);
        if (return_value == null) {
            return_value = new RepositoryDigestRepositoryData(name, location);
            this.m_repositoryData.add(return_value);
        }
        return return_value;
    }

    public RepositoryDigestRepositoryData removeRepositoryDigestData(String location) {
        assert (location != null);
        RepositoryDigestRepositoryData return_value = this.findRepositoryDigestData(location);
        if (return_value != null) {
            this.m_repositoryData.remove(return_value);
        }
        return return_value;
    }

    public void addRepositoryDigestData(RepositoryDigestRepositoryData rdd) {
        RepositoryDigestRepositoryData rddCurrent = this.findRepositoryDigestData(rdd.getLocation());
        if (rddCurrent == null) {
            this.m_repositoryData.add(rdd);
        }
    }

    private RepositoryDigestRepositoryData findRepositoryDigestData(String location) {
        for (RepositoryDigestRepositoryData repData : this.m_repositoryData) {
            if (!repData.m_location.equals(location)) continue;
            return repData;
        }
        return null;
    }

    public String[] getNestedRepositoryLocations() {
        ArrayList<String> result = new ArrayList<String>(this.m_repositoryData.size());
        for (RepositoryDigestRepositoryData repData : this.m_repositoryData) {
            result.add(repData.getLocation());
        }
        return result.toArray(new String[result.size()]);
    }

    public String getLocation() {
        return this.m_location;
    }

    public List<RepositoryDigestRepositoryData> getRepositoryDigestList() {
        return this.m_repositoryData;
    }

    public String resolveNL(String val) {
        if (NLSUtils.isNLKey(val)) {
            for (String lang : LANG_LIST) {
                String val1;
                if (!this.m_dictionaries.containsKey(lang) || (val1 = ((RepositoryDigestDictionary)this.m_dictionaries.get(lang)).getProperty(val.substring(1))) == null) continue;
                return val1;
            }
        }
        return val;
    }

    void addDictionary(RepositoryDigestDictionary a_dict) {
        this.m_dictionaries.put(a_dict.getLang(), a_dict);
    }

    public void addRepositoryDigestDictionaryList(IRepository contRep) {
        String[] fileList;
        String[] stringArray = fileList = contRep.getNLSFileList();
        int n = fileList.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            Properties prop = new Properties();
            try {
                String lang;
                InputStream is = contRep.openNLSFileStream(element);
                try {
                    prop.load(is);
                }
                finally {
                    FileUtil.close(is);
                }
                int b = element.indexOf(95);
                if (b == -1) {
                    lang = "default";
                } else {
                    int e = element.lastIndexOf(46);
                    lang = element.substring(b + 1, e);
                }
                RepositoryDigestDictionary dict = new RepositoryDigestDictionary(lang);
                Enumeration<Object> keys = prop.keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    String val = prop.getProperty(key);
                    if (val == null) continue;
                    dict.addProperty(key, val);
                }
                if (!dict.isEmpty()) {
                    this.addDictionary(dict);
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            ++n2;
        }
    }

    public void copyDigestRepositoryData(RepositoryDigestRepositoryData repDigest) {
        this.m_properties = repDigest.m_properties;
        this.m_offeringAndUpdateDatas = repDigest.m_offeringAndUpdateDatas;
        this.m_fixDatas = repDigest.m_fixDatas;
        this.m_repositoryData = repDigest.m_repositoryData;
        this.m_dictionaries = repDigest.m_dictionaries;
        this.m_repositoryData = repDigest.m_repositoryData;
        this.m_digestDataCleared = false;
    }

    boolean isDigestDataCleared() {
        return this.m_digestDataCleared;
    }

    void setDigestDataCleared(boolean dataCleared) {
        this.m_digestDataCleared = dataCleared;
    }
}

