/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.repository.digest;

import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.repository.UpdateOfferingUtils;
import com.ibm.cic.common.core.utils.XMLWriter;
import org.osgi.framework.Version;

public class RepositoryDigestBaseOfferingData {
    public static final RepositoryDigestBaseOfferingData NULL = new NullRepositoryDigestBaseOfferingData();
    private final IIdentity m_Id;
    private final Version m_Version;
    private final String m_DisplayVersion;

    static RepositoryDigestBaseOfferingData createOfferingUpdate(IOffering offering) {
        if (UpdateOfferingUtils.isUpdate(offering)) {
            IIdentity baseId = UpdateOfferingUtils.getBaseOfferingId(offering);
            Version baseVersion = UpdateOfferingUtils.getBaseOfferingVersion(offering);
            String baseDisplayVersion = UpdateOfferingUtils.getBaseOfferingDisplayVersion(offering);
            return new RepositoryDigestBaseOfferingData(baseId, baseVersion, baseDisplayVersion);
        }
        return NULL;
    }

    public RepositoryDigestBaseOfferingData(IIdentity a_boId, Version a_boVersion, String a_boDisplayVersion) {
        this.m_Id = a_boId;
        this.m_Version = a_boVersion;
        this.m_DisplayVersion = a_boDisplayVersion;
    }

    public void emitXML(XMLWriter writer) {
        writer.start("baseOffering");
        writer.attribute("id", this.m_Id);
        writer.attribute("version", this.m_Version);
        writer.attribute("displayVersion", this.m_DisplayVersion);
        writer.end("baseOffering");
    }

    public IIdentity getId() {
        return this.m_Id;
    }

    public Version getVersion() {
        return this.m_Version;
    }

    public String getDisplayVersion() {
        return this.m_DisplayVersion;
    }

    public String toString() {
        return "UPDATE TO:" + this.m_Id + " Ver:" + this.m_Version + " Vis ver:" + this.m_DisplayVersion;
    }

    private static class NullRepositoryDigestBaseOfferingData
    extends RepositoryDigestBaseOfferingData {
        public NullRepositoryDigestBaseOfferingData() {
            super(null, null, null);
        }

        @Override
        public String toString() {
            return "Not an update";
        }

        @Override
        public void emitXML(XMLWriter writer) {
        }
    }
}

