/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.repository;

import com.ibm.cic.common.core.definitions.ProfileOS;
import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.proxy.IOfferingOrFixReference;
import com.ibm.cic.common.core.model.proxy.IOfferingReference;
import com.ibm.cic.common.core.model.proxy.OfferingOrFixReference;
import com.ibm.cic.common.core.utils.LinkedProperties;
import com.ibm.cic.common.core.utils.NLS;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class SliceUtils {
    public static String platformToString(String os, String arch) {
        StringBuilder sb = new StringBuilder(20);
        if (os != null) {
            sb.append("os=").append(os);
            if (arch != null) {
                sb.append(',');
            }
        }
        if (arch != null) {
            sb.append("arch=").append(arch);
        }
        return sb.toString();
    }

    public static String platformToDisplayName(String os, String arch) {
        if (os == null) {
            return arch;
        }
        if (arch == null) {
            return ProfileOS.getOperatingSystemDisplayName(os);
        }
        return NLS.bind(Messages.Platform_Display_Name, (Object)ProfileOS.getOperatingSystemDisplayName(os), (Object)arch);
    }

    public static IStatus checkPlatform(IOfferingOrFix offeringOrFix, String os, String arch) {
        return offeringOrFix instanceof IOfferingOrFixReference ? ((IOfferingOrFixReference)offeringOrFix).checkPlatform(os, arch) : Status.OK_STATUS;
    }

    public static boolean isMoreApplicable(IOfferingReference o1, IOfferingReference o2) {
        String arch;
        if (!o2.isPlatformSlice()) {
            return false;
        }
        if (!o1.isPlatformSlice()) {
            return true;
        }
        String os = Platform.getOS();
        return o1.checkPlatform(os, arch = Platform.getOSArch()).isOK() && !o2.checkPlatform(os, arch).isOK();
    }

    public static boolean isPlatformSlice(IContent content) {
        if (content instanceof OfferingOrFixReference) {
            OfferingOrFixReference offeringRef = (OfferingOrFixReference)content;
            return offeringRef.isPlatformSlice();
        }
        return false;
    }

    public static void setPlatformSlice(IContent content, LinkedProperties predefineds) {
        if (content instanceof OfferingOrFixReference && predefineds != null) {
            OfferingOrFixReference offeringRef = (OfferingOrFixReference)content;
            String os = predefineds.getProperty("cic.selector.os");
            String arch = predefineds.getProperty("cic.selector.arch");
            offeringRef.setPlatformSlice(os, arch);
        }
    }

    public static void mergePlatformSlices(IContent source, IContent target) {
        if (source instanceof OfferingOrFixReference && target instanceof OfferingOrFixReference) {
            OfferingOrFixReference baseOffering = (OfferingOrFixReference)source;
            OfferingOrFixReference targetOffering = (OfferingOrFixReference)target;
            if (baseOffering.isPlatformSlice() && targetOffering.isPlatformSlice()) {
                targetOffering.mergePlatformSlices(baseOffering);
            } else {
                targetOffering.clearPlatformSlices();
            }
        }
    }

    public static List<String> getListOfPlatformSlices(IContent content) {
        if (content instanceof OfferingOrFixReference) {
            OfferingOrFixReference offeringRef = (OfferingOrFixReference)content;
            return offeringRef.getListOfPlatformSlices();
        }
        return Collections.emptyList();
    }

    private SliceUtils() {
        assert (false);
    }
}

