/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.repository;

import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.StatusCodes;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.IStatusCodes;
import com.ibm.cic.common.core.utils.MultiStatusUtil;
import com.ibm.cic.common.core.utils.OutputFormatter;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.downloads.DownloadStatusException;
import com.ibm.cic.common.logging.Logger;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class RepositoryStatus
extends Status
implements IStatusCodes {
    String location;
    public static final RepositoryStatus ST_ERROR_CANT_ADD_EXISTING_REPOSITORY_SITE_CLOSED = new RepositoryStatus(4, 6002, Messages.Repo_CantAddExistingRepositorySiteClosed);
    public static final RepositoryStatus ST_OK_REPOSITORY_STATUS_OK = new RepositoryStatus(0, 6021, Messages.Repo_RepositoryStatusOK);
    public static final RepositoryStatus ST_WARNING_REPOSITORY_STATUS_WARNING = new RepositoryStatus(2, 6022, Messages.Repo_RepositoryStatusWarning);
    public static final RepositoryStatus ST_ERROR_UNSUPPORTED_LAYOUT_POLICY = new RepositoryStatus(4, 6006, Messages.Repo_UnsupportedLayoutPolicy);
    public static final RepositoryStatus ST_ERROR_UNSUPPORTED_LAYOUT_POLICY_VERSION = new RepositoryStatus(4, 6007, Messages.Repo_UnsupportedLayoutPolicyVersion);
    public static final RepositoryStatus ST_ERROR_UNSUPPORTED_REPOSITORY_TYPE = new RepositoryStatus(4, 6008, Messages.Repo_RepositoryType);
    public static final RepositoryStatus ST_ERROR_UNSUPPORTED_REPOSITORY_TYPE_VERSION = new RepositoryStatus(4, 6009, Messages.Repo_RepositoryTypeVersion);
    public static final RepositoryStatus ST_ERROR_REPOSITORY_LOCATION_IS_NOT_PROVIDED = new RepositoryStatus(4, 6010, Messages.Repo_RepositoryLocationIsNotProvided);
    public static final RepositoryStatus ST_ERROR_CANT_CREATE_REPOSITORY = new RepositoryStatus(4, 6003, Messages.Repo_CantCreateRepository);
    public static final RepositoryStatus ST_ERROR_CANT_CREATE_REPOSITORY_ALREADY_EXISTS = new RepositoryStatus(4, 6011, Messages.Repo_CantCreateRepositoryAlreadyExists);
    public static final RepositoryStatus ST_ERROR_CANT_CREATE_REPOSITORY_BECAUSE = new RepositoryStatus(4, 6013, Messages.Repo_CantCreateRepositoryBecause);
    public static final RepositoryStatus ST_ERROR_CANT_CREATE_REPOSITORY_NO_ENOUGH_INFO = new RepositoryStatus(4, 6015, Messages.Repo_CantCreateRepositoryNoEnoughInfo);
    public static final RepositoryStatus ST_ERROR_CANT_CREATE_REPOSITORY_CANT_CREATE_FILE = new RepositoryStatus(4, 6016, Messages.Repo_CantCreateRepositoryCantCreate);
    public static final RepositoryStatus ST_ERROR_CANT_CREATE_REPOSITORY_CANT_DELETE_FILE = new RepositoryStatus(4, 6017, Messages.Repo_CantCreateRepositoryCantDelete);
    public static final RepositoryStatus ST_ERROR_CANT_CREATE_REPOSITORY_AT_REMOTE_LOC = new RepositoryStatus(4, 6012, Messages.Repo_CantCreateRepositoryAtRemoteLocation);
    public static final RepositoryStatus ST_ERRORTEMPLT_CANT_ACCESS_REPOSITORY = new RepositoryStatus(4, 6004, Messages.Repo_CantAccessRepository);
    public static final RepositoryStatus ST_ERROR_REPOSITORY_IS_NOT_WRITABLE = new RepositoryStatus(4, 6005, Messages.Repo_RepositoryIsNotWritable);
    public static final RepositoryStatus ST_ERROR_CONTENT_ELEMENT_CANT_BE_ADDED = new RepositoryStatus(4, 6051, Messages.Repo_ContentElementCantBeAdded);
    public static final RepositoryStatus ST_ERROR_CONTENT_ELEMENT_CANT_BE_DELETED = new RepositoryStatus(4, 6055, Messages.Repo_ContentElementCantBeDeleted);
    public static final RepositoryStatus ST_ERROR_CONTENT_ELEMENT_CANT_BE_SAVED = new RepositoryStatus(4, 6052, Messages.Repo_ContentElementCantBeSaved);
    public static final RepositoryStatus ST_ERROR_CONTENT_ELEMENT_NOT_FROM_REPOSITORY = new RepositoryStatus(4, 6050, Messages.Repo_ContentNotFromRepository);
    public static final RepositoryStatus ST_ERROR_CONTENT_ELEMENT_CANT_BE_RESOLVED = new RepositoryStatus(4, 6053, Messages.Repo_ContentCantBeResolved);
    public static final RepositoryStatus ST_ERROR_REP_INFO_DOES_NOT_MATCH = new RepositoryStatus(4, 6054, Messages.Repo_RepositoryInfoDoesNotMatch);

    public RepositoryStatus(int severity, int code, String message, Throwable exception) {
        super(severity, IStatusCodes.PLUGIN_ID, code, message, exception);
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public RepositoryStatus(RepositoryStatus repoStatus, Throwable exception) {
        this(repoStatus.getSeverity(), repoStatus.getCode(), repoStatus.getMessage(), exception);
    }

    public RepositoryStatus(RepositoryStatus repoStatus, String message) {
        this(repoStatus.getSeverity(), repoStatus.getCode(), NLS.bind((String)repoStatus.getMessage(), (Object)message), null);
    }

    public RepositoryStatus(RepositoryStatus repoStatus, String message0, String message1) {
        this(repoStatus.getSeverity(), repoStatus.getCode(), NLS.bind((String)repoStatus.getMessage(), (Object)message0, (Object)message1), null);
    }

    public RepositoryStatus(RepositoryStatus repoStatus, IRepository rep) {
        this(repoStatus, rep != null ? rep.getName() : "");
    }

    public RepositoryStatus(RepositoryStatus repoStatus, IRepository rep, String message) {
        this(repoStatus, rep.getName(), message);
    }

    public RepositoryStatus(int severity, int code, String message) {
        this(severity, code, message, null);
    }

    protected static String getRepositoryId(IRepository a_rep) {
        String name;
        String location = a_rep.getLocationStr();
        if (location.equals(name = a_rep.getName())) {
            return a_rep.getLocationStr();
        }
        return String.valueOf(a_rep.getName()) + "@" + a_rep.getLocationStr();
    }

    public static IStatus createErrorStatus(String message, int code, Logger a_log, Exception exception) {
        if (a_log != null) {
            a_log.debug(message);
        }
        return new Status(4, ComIbmCicCommonCorePlugin.getPluginId(), code, message, (Throwable)exception);
    }

    public static IStatus createErrorStatus(int code, String message, String str0, String str1) {
        return RepositoryStatus.createErrorStatus(NLS.bind((String)message, (Object)str0, (Object)str1), code, null);
    }

    public static IStatus createErrorStatus(String message, int code, Logger a_log) {
        return RepositoryStatus.createErrorStatus(message, code, a_log, null);
    }

    public static IStatus createErrorStatus(String message, String str0, int code, Logger a_log) {
        return RepositoryStatus.createErrorStatus(NLS.bind((String)message, (Object)str0), code, a_log, null);
    }

    public static IStatus createErrorStatus(String message, String str0, String str1, int code, Logger a_log) {
        return RepositoryStatus.createErrorStatus(NLS.bind((String)message, (Object)str0, (Object)str1), code, a_log, null);
    }

    public static IStatus createErrorStatus(String message, String str0, IRepository repository, int code, Logger a_log, Exception exception) {
        return RepositoryStatus.createErrorStatus(NLS.bind((String)message, (Object)str0, (Object)RepositoryStatus.getRepositoryId(repository)), code, a_log, exception);
    }

    public static IStatus createErrorStatus(String message, String str0, IRepository repository, int code, Logger a_log) {
        return RepositoryStatus.createErrorStatus(NLS.bind((String)message, (Object)str0, (Object)RepositoryStatus.getRepositoryId(repository)), code, a_log, null);
    }

    public static IStatus createErrorStatus(String message, IRepository repository, int code, Logger a_log, Exception exception) {
        return RepositoryStatus.createErrorStatus(NLS.bind((String)message, (Object)RepositoryStatus.getRepositoryId(repository)), code, a_log, exception);
    }

    public static IStatus createErrorStatus(String message, IRepository repository, int code, Logger a_log) {
        return RepositoryStatus.createErrorStatus(NLS.bind((String)message, (Object)RepositoryStatus.getRepositoryId(repository)), code, a_log, null);
    }

    public static final CicMultiStatus createSpecificMultiStatus(ICicStatus template, Exception e) {
        CicMultiStatus status = Statuses.ST.createMultiStatus(template.getSeverity(), template.getCode(), null, e, template.getOrigMessage(), template.getMessageArgs());
        return status;
    }

    public static final CicMultiStatus createErrorMultiStatus(int code, String msg0, String msg1, String msg2, IStatus childStatus) {
        IStatus[] iStatusArray;
        if (childStatus == null) {
            iStatusArray = null;
        } else {
            IStatus[] iStatusArray2 = new IStatus[1];
            iStatusArray = iStatusArray2;
            iStatusArray2[0] = childStatus;
        }
        CicMultiStatus status = Statuses.ST.createMultiStatus(4, code, iStatusArray, null, NLS.bind((String)msg0, (Object)msg1, (Object)msg2), new Object[0]);
        return status;
    }

    public static final IStatus getDisplayStatusForCanAddExisting(String genericMsg, String specificMsg, IStatus argStatus) {
        StatusAndErrorType statusAndType = RepositoryStatus.getDisplayStatusForCanAddExisting(genericMsg, argStatus);
        if (statusAndType.isKnownInvalidLocation()) {
            MultiStatus ms = new MultiStatus(statusAndType.getPlugin(), statusAndType.getCode(), specificMsg, null);
            ms.add((IStatus)statusAndType);
            return ms;
        }
        return statusAndType;
    }

    public static final StatusAndErrorType getDisplayStatusForCanAddExisting(String msg, IStatus argStatus) {
        final ArrayList knownInvalid = new ArrayList(1);
        IStatus status = MultiStatusUtil.removeDuplicates(argStatus);
        IStatus displayStatus = MultiStatusUtil.newFilteredStatus(msg, status, new MultiStatusUtil.IStatusFilter(){

            @Override
            public boolean considerChildren() {
                return true;
            }

            @Override
            public boolean include(IStatus astatus) {
                if (!astatus.isMultiStatus() && StatusCodes.isAuthenticationCanceled(astatus)) {
                    knownInvalid.add(astatus);
                    return true;
                }
                if (astatus.getCode() == 6020) {
                    if (astatus.isMultiStatus()) {
                        IStatus[] c = astatus.getChildren();
                        boolean hasMultiChildren = false;
                        if (c.length == 0) {
                            hasMultiChildren = false;
                        } else {
                            int i = 0;
                            while (!hasMultiChildren && i < c.length) {
                                IStatus ac = c[i];
                                if (ac.getCode() == 6020) {
                                    hasMultiChildren = true;
                                }
                                ++i;
                            }
                        }
                        if (hasMultiChildren) {
                            return false;
                        }
                    }
                    knownInvalid.add(astatus);
                    return true;
                }
                Throwable t = astatus.getException();
                if (t == null) {
                    if (astatus.getCode() == 6) {
                        return true;
                    }
                    if (astatus.getCode() == 15) {
                        knownInvalid.add(astatus);
                        return true;
                    }
                    if (astatus.getCode() == 6002) {
                        knownInvalid.add(astatus);
                        return true;
                    }
                    if (astatus.getCode() == 6023) {
                        knownInvalid.add(astatus);
                        return true;
                    }
                    return false;
                }
                return !(t instanceof FileNotFoundException);
            }
        });
        if (knownInvalid.size() >= 1) {
            return new StatusAndErrorType((IStatus)knownInvalid.get(0), true);
        }
        if (status == displayStatus) {
            MultiStatus ms = new MultiStatus(status.getPlugin(), 0, Messages.Repo_CantAddRepositoryTroubleShooting, null);
            RepositoryStatus.addInfo(ms, Messages.Repo_CantAddRepositoryTroubleShooting_1);
            RepositoryStatus.addInfo(ms, Messages.Repo_CantAddRepositoryTroubleShooting_2);
            RepositoryStatus.addInfo(ms, Messages.Repo_CantAddRepositoryTroubleShooting_3);
            RepositoryStatus.addInfo(ms, Messages.Repo_CantAddRepositoryTroubleShooting_4);
            CicMultiStatus msRoot = Statuses.ST.createMultiStatus(6024, status.getException(), msg, new Object[0]);
            msRoot.add((IStatus)ms);
            displayStatus = msRoot;
        } else {
            displayStatus = MultiStatusUtil.removeDuplicates(displayStatus);
        }
        return new StatusAndErrorType(displayStatus, false);
    }

    private static void addInfo(MultiStatus ms, String msg) {
        ms.add((IStatus)Statuses.INFO.get(msg, new Object[0]));
    }

    public void setException(Throwable exception) {
        super.setException(exception);
    }

    public static IStatus addRepositroyAccessStatus(CicMultiStatus return_status, IStatus newStatus, String repLocation) {
        if (return_status != null && !newStatus.isOK()) {
            DownloadStatusException dse;
            Object c;
            return_status.add(newStatus);
            Throwable e = MultiStatusUtil.getAnyException(newStatus);
            String newMsg = String.valueOf(return_status.getMessage()) + "-" + repLocation + "\n";
            if (e != null && e instanceof DownloadStatusException && (c = (dse = (DownloadStatusException)e).getProtocolCode()) instanceof Integer && (Integer)c == 401) {
                newMsg = String.valueOf(newMsg) + "    (" + Messages.AuthenticationIsRequired + ") " + OutputFormatter.NEW_LINE_STR;
            }
            return_status.setMessage(newMsg);
        }
        return return_status;
    }

    public static class StatusAndErrorType
    implements ICicStatus {
        private final IStatus status;
        private final boolean knownInvalidLocation;

        public StatusAndErrorType(IStatus status, boolean knownInvalidLocation) {
            this.status = status;
            this.knownInvalidLocation = knownInvalidLocation;
        }

        public boolean isKnownInvalidLocation() {
            return this.knownInvalidLocation;
        }

        public IStatus[] getChildren() {
            return this.status.getChildren();
        }

        public int getCode() {
            return this.status.getCode();
        }

        public Throwable getException() {
            return this.status.getException();
        }

        public String getMessage() {
            return this.status.getMessage();
        }

        public String getPlugin() {
            return this.status.getPlugin();
        }

        public int getSeverity() {
            return this.status.getSeverity();
        }

        public boolean isMultiStatus() {
            return this.status.isMultiStatus();
        }

        public boolean isOK() {
            return this.status.isOK();
        }

        public boolean matches(int severityMask) {
            return this.status.matches(severityMask);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("knownInvalid=");
            sb.append(this.knownInvalidLocation);
            sb.append(":");
            sb.append(this.status);
            return sb.toString();
        }

        @Override
        public Object[] getMessageArgs() {
            if (this.status instanceof ICicStatus) {
                return ((ICicStatus)this.status).getMessageArgs();
            }
            return null;
        }

        @Override
        public String getOrigMessage() {
            if (this.status instanceof ICicStatus) {
                return ((ICicStatus)this.status).getOrigMessage();
            }
            return null;
        }

        @Override
        public String getUid() {
            return StatusUtil.getUid(this.status);
        }

        @Override
        public String getExplanation() {
            return StatusUtil.getExplanation(this.status);
        }

        @Override
        public String getUserAction() {
            return StatusUtil.getUserAction(this.status);
        }

        @Override
        public boolean isError() {
            return this.matches(4);
        }

        @Override
        public boolean isErrorOrCancel() {
            return this.matches(12);
        }

        @Override
        public boolean isCancel() {
            return this.matches(8);
        }

        @Override
        public boolean isWarning() {
            return this.matches(8);
        }

        @Override
        public boolean isInfo() {
            return this.matches(1);
        }
    }
}

