/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.repository;

import com.ibm.cic.common.core.internal.repository.RepositoryPool;
import com.ibm.cic.common.core.repository.IRepositoryPool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PrivateRepositoryPools {
    private final ArrayList privatePools = new ArrayList();
    public static final PrivateRepositoryPools INSTANCE = new PrivateRepositoryPools();

    private PrivateRepositoryPools() {
    }

    public IRepositoryPool createPrivateRepositoryPool(String name) {
        RepositoryPool pool = new RepositoryPool(name);
        this.privatePools.add(pool);
        return pool;
    }

    public void releasePrivatePool(IRepositoryPool privatePool) {
        boolean removed = this.privatePools.remove(privatePool);
        assert (removed);
        assert (privatePool.getRepositories().size() == 0);
    }

    public List getPrivateRepositoryPools() {
        return Collections.unmodifiableList(this.privatePools);
    }
}

