/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.repository;

import com.ibm.cic.common.core.artifactrepo.IArtifactSession;
import com.ibm.cic.common.core.artifactrepo.IReadArtifactRepo;
import com.ibm.cic.common.core.artifactrepo.base.IMultiArtifactOperationArguments;
import com.ibm.cic.common.core.internal.repository.RepositoryInfo;
import com.ibm.cic.common.core.model.IAssembly;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IShareableUnit;
import com.ibm.cic.common.core.model.ISuFragment;
import com.ibm.cic.common.core.repository.AbstractBaseRepository;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.UnavailableUtils;
import com.ibm.cic.common.core.repository.UpdateOfferingUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Version;

public class MemoryRepository
extends AbstractBaseRepository {
    public static final String REPOSITORY_TYPE = "Memory";
    public static final String REPOSITORY_VERSION = "0.0.0.1";
    private final List m_offerings = Collections.synchronizedList(new ArrayList());
    private final List m_unavailable_offerings = Collections.synchronizedList(new ArrayList());
    private final List m_updates = Collections.synchronizedList(new ArrayList());
    private final List m_unavailable_updates = Collections.synchronizedList(new ArrayList());
    private final List m_fixes = Collections.synchronizedList(new ArrayList());
    private final List m_unavailable_fixes = Collections.synchronizedList(new ArrayList());
    private final List m_assemblies = Collections.synchronizedList(new ArrayList());
    private final List m_sus = Collections.synchronizedList(new ArrayList());
    private final List m_suFragments = Collections.synchronizedList(new ArrayList());
    private final List m_ius = Collections.synchronizedList(new ArrayList());

    public MemoryRepository() {
        super(REPOSITORY_TYPE, REPOSITORY_VERSION);
    }

    @Override
    protected IStatus doAddContent(IContent content) {
        if (content instanceof IOffering) {
            if (UpdateOfferingUtils.isUpdate(content)) {
                if (UnavailableUtils.isUnavailable(content)) {
                    this.m_unavailable_updates.add(content);
                } else {
                    this.m_updates.add(content);
                }
            } else if (UnavailableUtils.isUnavailable(content)) {
                this.m_unavailable_offerings.add(content);
            } else {
                this.m_offerings.add(content);
            }
        } else if (content instanceof IFix) {
            if (UnavailableUtils.isUnavailable(content)) {
                this.m_unavailable_fixes.add(content);
            } else {
                this.m_fixes.add(content);
            }
        } else if (content instanceof IAssembly) {
            this.m_assemblies.add(content);
        } else if (content instanceof IShareableUnit) {
            this.m_sus.add(content);
        } else if (content instanceof ISuFragment) {
            this.m_suFragments.add(content);
        } else if (content instanceof IInstallableUnit) {
            this.m_ius.add(content);
        }
        return this.getStatus(false, null);
    }

    @Override
    public boolean containsMetadata() {
        return !this.m_assemblies.isEmpty() || !this.m_fixes.isEmpty() || !this.m_ius.isEmpty() || !this.m_sus.isEmpty() || !this.m_suFragments.isEmpty() || !this.m_offerings.isEmpty() || !this.m_updates.isEmpty();
    }

    @Override
    public List getAllContentElements(IProgressMonitor monitor) {
        ArrayList return_value = new ArrayList();
        return_value.addAll(this.m_assemblies);
        return_value.addAll(this.m_fixes);
        return_value.addAll(this.m_ius);
        return_value.addAll(this.m_sus);
        return_value.addAll(this.m_suFragments);
        return_value.addAll(this.m_offerings);
        return_value.addAll(this.m_updates);
        return return_value;
    }

    @Override
    public List getAllOfferings(boolean includeUnavailable, IProgressMonitor progressMonitor) {
        ArrayList offs = new ArrayList(this.m_offerings);
        if (includeUnavailable) {
            offs.addAll(this.m_unavailable_offerings);
        }
        return offs;
    }

    @Override
    public List getAllUpdates(boolean includeUnavailable, IIdentity id, Version ver, IProgressMonitor progressMonitor) {
        ArrayList<IOffering> return_value = new ArrayList<IOffering>();
        ArrayList updates = new ArrayList(this.m_updates);
        if (includeUnavailable) {
            updates.addAll(this.m_unavailable_updates);
        }
        for (IOffering update : updates) {
            if (id != null && !update.getIdentity().equals(id) || ver != null && ver.compareTo(update.getVersion()) >= 0) continue;
            IIdentity baseId = UpdateOfferingUtils.getBaseOfferingId(update);
            Version baseVersion = UpdateOfferingUtils.getBaseOfferingVersion(update);
            if (baseId == null || baseVersion == null || id != null && !baseId.equals(id) || ver != null && baseVersion.compareTo(ver) > 0) continue;
            return_value.add(update);
        }
        return return_value;
    }

    public IStatus setUpdateOffering(IOffering updateOffering, IOffering baseOffering) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IStatus unsetUpdateOffering(IOffering updateOffering) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List getAllFixes(boolean includeUnavailable, IProgressMonitor progressMonitor) {
        ArrayList fixes = new ArrayList(this.m_fixes);
        if (includeUnavailable) {
            fixes.addAll(this.m_unavailable_fixes);
        }
        return fixes;
    }

    @Override
    public List getAllAssemblies(IProgressMonitor progressMonitor) {
        return new ArrayList(this.m_assemblies);
    }

    @Override
    public List getAllSus(IProgressMonitor progressMonitor) {
        return new ArrayList(this.m_sus);
    }

    @Override
    public List getAllSuFragments(IProgressMonitor progressMonitor) {
        return new ArrayList(this.m_suFragments);
    }

    @Override
    public List getAllIus(IProgressMonitor progressMonitor) {
        return new ArrayList(this.m_ius);
    }

    @Override
    public IStatus clear() {
        this.m_offerings.clear();
        this.m_unavailable_offerings.clear();
        this.m_updates.clear();
        this.m_fixes.clear();
        this.m_assemblies.clear();
        this.m_sus.clear();
        this.m_suFragments.clear();
        this.m_ius.clear();
        return super.clear();
    }

    public void getArtifactFiles(IArtifactSession session, IMultiArtifactOperationArguments artifactArgs, IProgressMonitor monitor) {
    }

    @Override
    public boolean hasArtifactToc(IArtifactSession session, IProgressMonitor monitor) {
        return false;
    }

    @Override
    public IReadArtifactRepo.IArtifactToc readArtifactToc(IArtifactSession session, IProgressMonitor monitor) {
        return null;
    }

    @Override
    public IReadArtifactRepo.IArtifactToc readCachedArtifactToc(IArtifactSession session, IPath tocCache, IProgressMonitor monitor) {
        return null;
    }

    @Override
    public IReadArtifactRepo.IArtifactTocCapabilities getArtifactTocCapabilities() {
        return null;
    }

    @Override
    protected IRepository setUniqueRepositoryInfo(IRepository masterRepository) throws IOException, CoreException {
        String version;
        String type;
        String name;
        RepositoryInfo ri;
        if (masterRepository != null && this.initializeRepository(ri = new RepositoryInfo(name = String.valueOf(masterRepository.getName()) + "_memCache", type = REPOSITORY_TYPE, version = REPOSITORY_VERSION, masterRepository.getLocation(), null), null).isOK() && this.addExistingRepository().isOK()) {
            return this;
        }
        return null;
    }

    @Override
    public IStatus doDeleteContent(IContent content) {
        if (content instanceof IOffering) {
            if (UpdateOfferingUtils.isUpdate(content)) {
                this.m_updates.remove(content);
            } else {
                this.m_offerings.remove(content);
            }
        } else if (content instanceof IFix) {
            this.m_fixes.remove(content);
        } else if (content instanceof IAssembly) {
            this.m_assemblies.remove(content);
        } else if (content instanceof IShareableUnit) {
            this.m_sus.remove(content);
        } else if (content instanceof ISuFragment) {
            this.m_suFragments.remove(content);
        } else if (content instanceof IInstallableUnit) {
            this.m_ius.remove(content);
        }
        return Status.OK_STATUS;
    }

    @Override
    public IStatus saveContent(IContent content) {
        return Status.OK_STATUS;
    }

    @Override
    protected IStatus doImportP2Repository(File p2RepositoryFile, IProgressMonitor progressMonitor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IStatus deleteP2Repository(IProgressMonitor progressMonitor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IStatus exportP2Repository(File destinationFile, IProgressMonitor progressMonitor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsP2Repository(IProgressMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IStatus addNLSFile(String fileName, InputStream source) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IStatus deleteNLSFile(String fileName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String[] getNLSFileList() {
        throw new UnsupportedOperationException();
    }

    @Override
    public InputStream openNLSFileStream(String fileName) {
        throw new UnsupportedOperationException();
    }
}

