/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.repository;

import com.ibm.cic.common.core.artifactrepo.impl.AbstractPathWriteArtifactRepository;
import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.internal.artifactrepo.IRevealArtifactFileLocations;
import com.ibm.cic.common.core.internal.repository.TableOfContents;
import com.ibm.cic.common.core.internal.utils.CicConstants;
import com.ibm.cic.common.core.model.IAssembly;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.Writer;
import com.ibm.cic.common.core.model.proxy.IOfferingOrFixReference;
import com.ibm.cic.common.core.model.proxy.IOfferingReference;
import com.ibm.cic.common.core.model.utils.ContentCollection;
import com.ibm.cic.common.core.repository.AbstractFileBasedRepository;
import com.ibm.cic.common.core.repository.CicFileLocation;
import com.ibm.cic.common.core.repository.ContentZip2Repository;
import com.ibm.cic.common.core.repository.DirectoryArtifactRepository;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.repository.IContentRepository;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.IRepositoryInfo;
import com.ibm.cic.common.core.repository.IRevealFileLocations;
import com.ibm.cic.common.core.repository.LayoutPolicy;
import com.ibm.cic.common.core.repository.LayoutPolicyDefaultLayout;
import com.ibm.cic.common.core.repository.RepositoryFileBasedSiteProperties;
import com.ibm.cic.common.core.repository.RepositoryStatus;
import com.ibm.cic.common.core.repository.RepositoryUtils;
import com.ibm.cic.common.core.repository.UpdateOfferingUtils;
import com.ibm.cic.common.core.repository.listeners.RepositoryEventClear;
import com.ibm.cic.common.core.repository.listeners.RepositoryEventContentAddRemove;
import com.ibm.cic.common.core.repository.listeners.RepositoryEventContentChanged;
import com.ibm.cic.common.core.repository.listeners.RepositoryEventContentElementChanged;
import com.ibm.cic.common.core.repository.listeners.RepositoryEventContentListAdd;
import com.ibm.cic.common.core.repository.listeners.RepositoryEventFileAdded;
import com.ibm.cic.common.core.repository.listeners.RepositoryEventFileRemoved;
import com.ibm.cic.common.core.repository.listeners.RepositoryEventProperty;
import com.ibm.cic.common.core.utils.FileURLUtil;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.downloads.ContentInfo;
import com.ibm.cic.common.downloads.IContentInfo;
import com.ibm.cic.common.downloads.IDownloadSession;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;

public class DirectoryRepository
extends AbstractFileBasedRepository {
    public static final String REPOSITORY_TYPE = "Dir";
    public static final String REPOSITORY_VERSION = "0.0.0.1";
    public static final String DEF_OFFERING_SUB_REP = "DirDefaultOfferingStorage";
    public static final String DEF_OFFERING_CON_SUB_REP_VAL = "ContentElementRepository";
    private static final String DEF_OFFERING_ZIP_SUB_REP_VAL = "ZipElementRepository";
    private static final Logger log = Logger.getLogger(DirectoryRepository.class);
    private final IDownloadSession m_session = IDownloadSession.NO_SESSION;
    private final IContentInfo m_contentInfoBeforeUpdate = ContentInfo.EMPTY_CONTENT_INFO;
    private final IProgressMonitor m_NullProgressMonitor = new NullProgressMonitor();
    private final TableOfContents.IOnTocSaved m_onSaved = null;

    public DirectoryRepository() {
        this(REPOSITORY_TYPE, REPOSITORY_VERSION);
    }

    @Override
    public IStatus initializeRepository(IRepositoryInfo repInfo, IProgressMonitor progressMonitor) {
        Object return_value = super.initializeRepository(repInfo, progressMonitor);
        if (return_value.isOK()) {
            if (!CicConstants.hasArchiveInPath(repInfo.getLocation()) && !FileURLUtil.isURLString(repInfo.getLocation().toString(), true)) {
                return_value = this.getStatus(false, null);
                if (!return_value.isOK() && !this.getSiteProperties().isInitialized()) {
                    File location = repInfo.getLocation().toFile();
                    return_value = location.isDirectory() && (this.getName() == null || !new File(location, this.getName()).exists()) ? this.getWriteArtifactRepository().initializeArtifactRepository(repInfo) : RepositoryStatus.createErrorMultiStatus(6014, Messages.ERROR_CANT_CREATE_REPOSITORY_OF_TYPE, this.getType(), this.getLocationStr(), return_value);
                }
            } else {
                return_value = RepositoryStatus.createErrorMultiStatus(6014, Messages.ERROR_CANT_CREATE_REPOSITORY_OF_TYPE, this.getType(), this.getLocationStr(), return_value);
            }
        }
        return return_value;
    }

    protected DirectoryRepository(String type, String version) {
        super(type, version);
        this.setArtifactRepository(new DirectoryArtifactRepository(){

            @Override
            public IRepository getRepository() {
                return DirectoryRepository.this;
            }

            @Override
            public void createArtifactRepository(IRepositoryInfo repInfo) throws Exception {
                this.doCreateArtifactRepository(repInfo);
            }

            @Override
            public void deleteArtifactRepository() {
                this.doDeleteArtifactRepository();
            }
        });
        this.setLayoutPolicy(new LayoutPolicyDefaultLayout(this));
        this.setSiteProperties(new RepositoryFileBasedSiteProperties(this.getLP()));
    }

    public static File getTempDir(File rootLocation) {
        return new File(rootLocation, "tmp");
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == IRevealFileLocations.class) {
            IRevealArtifactFileLocations ral = (IRevealArtifactFileLocations)this.getAdapter(IRevealArtifactFileLocations.class);
            if (ral != null) {
                return new RevealFileLocations(ral);
            }
            return null;
        }
        return super.getAdapter(adapter);
    }

    private AbstractPathWriteArtifactRepository getWriteArtifactRepository() {
        return (AbstractPathWriteArtifactRepository)this.getArtifactRepository();
    }

    @Override
    public IStatus canCreateRepository() {
        IStatus return_value = super.canCreateRepository();
        if (return_value.isOK()) {
            return_value = this.getSiteProperties().canCreate();
        }
        return return_value;
    }

    @Override
    protected IStatus doCreateRepository() {
        Object return_value = super.doCreateRepository();
        if (return_value.isOK() && (return_value = this.getSiteProperties().save()).isOK()) {
            try {
                this.getWriteArtifactRepository().createArtifactRepository(this.getRepositoryInfo());
            }
            catch (Exception e) {
                e.printStackTrace();
                return_value = RepositoryStatus.ST_ERROR_CANT_CREATE_REPOSITORY;
                ((RepositoryStatus)return_value).setException(e);
            }
        }
        return return_value;
    }

    @Override
    protected String[] getFileNames(ICicLocation relativeDirLocation, AbstractFileBasedRepository.Filter filter) {
        ArrayList<String> return_value = new ArrayList<String>();
        File path = this.getLocation().append(relativeDirLocation).toFile();
        File[] names = path.listFiles();
        if (names != null) {
            File[] fileArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String fileName;
                File name = fileArray[n2];
                if (name.isFile() && filter.acceptableFileName(fileName = name.getName())) {
                    return_value.add(fileName);
                }
                ++n2;
            }
        }
        return return_value.toArray(new String[return_value.size()]);
    }

    @Override
    Map getRelativeSearchLocationsAndFileNames(AbstractFileBasedRepository.Filter filter) {
        Map return_value = super.getRelativeSearchLocationsAndFileNames(filter);
        ICicLocation dirLocation = LayoutPolicy.EMPTY_LOCATION;
        String[] fileNames = this.getFileNames(dirLocation, filter);
        if (fileNames.length > 0) {
            return_value.put(dirLocation, fileNames);
        }
        return return_value;
    }

    private String constructFileName(IContent content) {
        String return_value = !(content instanceof IOffering) ? Writer.getFileName(content) : (DEF_OFFERING_CON_SUB_REP_VAL.equals(this.getSiteProperties().getProperty(DEF_OFFERING_SUB_REP)) ? Writer.getFileName(content) : (DEF_OFFERING_ZIP_SUB_REP_VAL.equals(this.getSiteProperties().getProperty(DEF_OFFERING_SUB_REP)) ? Writer.getFileName(content) : String.valueOf(Writer.getName(content)) + CicConstants.getJarFileDotExt()));
        return return_value;
    }

    @Override
    public IContent addContent(IContent content) throws IOException {
        String fileName;
        ICicLocation contentFolderPath;
        File contentFolder;
        if (content != null && this.isOpen() && this.isWritable() && this.getStatus(true, null).isOK() && this.canStoreMetadata() && !new File(contentFolder = (contentFolderPath = this.getLP().getCalculatedFQDirPath(content)).toFile(), fileName = this.constructFileName(content)).exists()) {
            IContentRepository subRepository;
            if (!contentFolder.exists()) {
                contentFolder.mkdirs();
            }
            if ((subRepository = this.createSubRepository(content, fileName, this.getLP().getRelativeTopDirPath(content.getClass()))) != null) {
                IContent return_value;
                IContentRepository cer;
                if ((content instanceof IOffering || content instanceof IFix) && (cer = RepositoryUtils.getContentRepository(content)) != null) {
                    subRepository.copyFrom(cer, null);
                }
                if (content instanceof IOffering) {
                    IOffering offering = (IOffering)content;
                    this.addOfferingChildrenToCer(offering, subRepository);
                    this.getUpdatesHandler().setUpdateOffering(offering);
                }
                if (content instanceof IOfferingOrFixReference) {
                    IOfferingOrFixReference ref = (IOfferingOrFixReference)content;
                    ref.addToSiteProperties(this.getSiteProperties());
                }
                if ((return_value = subRepository.getElement()) != null) {
                    ArrayList list = this.createTocEntryList(fileName, subRepository);
                    TableOfContents.addTocEntries(this.m_session, contentFolderPath, this.m_contentInfoBeforeUpdate, list, this.m_onSaved, this.m_NullProgressMonitor);
                    return_value = this.customizeNewIContentObject(subRepository, return_value, this.getLP().getRelativeTopDirPath(return_value.getClass()).append(fileName));
                    this.publishEvent(new RepositoryEventContentAddRemove(this, return_value, true));
                }
                return return_value;
            }
        }
        return null;
    }

    @Override
    protected IStatus doImportP2Repository(File sourceP2RepositoryFile, IProgressMonitor monitor) {
        IStatus return_value = null;
        if (sourceP2RepositoryFile != null && this.isOpen() && this.canStoreMetadata()) {
            if (this.isWritable()) {
                File p2RepositoryFile = this.getLP().getFQTopP2Path().toFile();
                FileUtil.ensureDestinationDirectory(p2RepositoryFile);
                try {
                    FileUtil.copyFile(sourceP2RepositoryFile, p2RepositoryFile, monitor);
                    return_value = Status.OK_STATUS;
                }
                catch (FileNotFoundException e) {
                    return_value = RepositoryStatus.createErrorStatus(Messages.Repo_CantImportP2RepositoryIsMissing, this, 6070, log, e);
                }
                catch (IOException e) {
                    return_value = RepositoryStatus.createErrorStatus(Messages.Repo_CantImportP2Repository, this, 6072, log, e);
                }
            } else {
                return_value = RepositoryStatus.createErrorStatus(Messages.Repo_CantImportP2RepositoryReadOnly, this, 6071, log);
            }
        }
        if (return_value == null) {
            return_value = RepositoryStatus.createErrorStatus(Messages.Repo_CantImportP2Repository, this, 6072, log);
        }
        return return_value;
    }

    private ArrayList createTocEntryList(String fileName, IContentRepository subRepository) {
        ArrayList<TableOfContents.TocEntry> list = new ArrayList<TableOfContents.TocEntry>(1);
        IContentInfo contentInfo = subRepository.getElementContentInfo();
        HashMap secondary = subRepository.getSecondaryContentInfoMap();
        if (secondary.isEmpty()) {
            list.add(new TableOfContents.TocEntry(fileName, null, contentInfo));
        } else {
            list.add(new TableOfContents.TocEntry(fileName, null, contentInfo, (String)secondary.keySet().iterator().next(), (IContentInfo)secondary.values().iterator().next()));
        }
        return list;
    }

    private void addOfferingChildrenToCer(IOffering offering, IRepository subRepo) {
        IAssembly assembly = offering.getAssembly();
        if (assembly != null) {
            if (assembly.getLocation() != null) {
                String dirName = Writer.getName(offering);
                String path = assembly.getLocation().toString();
                if (path.startsWith(dirName) && CicFileLocation.isSeparator(path.charAt(dirName.length()))) {
                    return;
                }
            }
            ArrayList<IContent> contentList = new ArrayList<IContent>();
            ContentCollection contentCollection = new ContentCollection(assembly, offering.getProperties(), false, null);
            for (IContent content : contentCollection) {
                contentList.add(content);
            }
            try {
                subRepo.addContent(contentList);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private IStatus saveOfferingChildrenToCer(IOffering offering, IRepository subRepo) {
        Object return_value = Status.OK_STATUS;
        IAssembly assembly = offering.getAssembly();
        if (assembly != null) {
            ContentCollection contentCollection = new ContentCollection(assembly, offering.getProperties(), false, null);
            for (IContent content : contentCollection) {
                try {
                    return_value = subRepo.saveContent(content);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return_value = RepositoryStatus.ST_ERROR_CONTENT_ELEMENT_CANT_BE_SAVED;
                }
            }
        }
        return return_value;
    }

    @Override
    public IStatus doDeleteContent(IContent content) throws IOException {
        IContentRepository rep;
        if (this.getStatus(false, null).isOK() && (rep = this.getContentRepository(content)) != null && rep.delete(true).isOK()) {
            ArrayList<String> list = new ArrayList<String>(1);
            list.add(content.getLocation().getName());
            TableOfContents.removeTocEntries(this.m_session, this.getLP().getCalculatedFQDirPath(content), this.m_contentInfoBeforeUpdate, list, this.m_onSaved, this.m_NullProgressMonitor);
            if (UpdateOfferingUtils.isUpdate(content)) {
                this.getUpdatesHandler().unsetUpdateOffering((IOffering)content);
            }
            if (content instanceof IOfferingReference) {
                IOfferingOrFixReference ref = (IOfferingOrFixReference)content;
                ref.removeFromSiteProperties(this.getSiteProperties());
            }
        }
        return this.getStatus(false, null);
    }

    @Override
    public IStatus doSaveContent(IContent content) throws IOException {
        ICicLocation contLocation;
        IContentRepository subRepository;
        IStatus return_value = this.getStatus(false, null);
        if (return_value.isOK() && (subRepository = this.createSubRepository(content, (contLocation = this.getLocation().append(content.getLocation())).getName(), content.getLocation().removeLastSegment())) != null) {
            return_value = subRepository.saveElement(content);
            if (return_value.isOK() && content instanceof IOffering) {
                return_value = this.saveOfferingChildrenToCer((IOffering)content, subRepository);
            }
            return return_value;
        }
        return RepositoryStatus.ST_ERROR_CONTENT_ELEMENT_CANT_BE_SAVED;
    }

    @Override
    public void doDelete() {
        File path = new File(this.getLocationStr());
        if (path.exists()) {
            File[] subFiles;
            File[] fileArray = subFiles = path.isDirectory() ? path.listFiles() : new File[]{};
            int n = subFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File subFile = fileArray[n2];
                String name = subFile.getName();
                if (this.getSiteProperties().isSitePropertyFile(name) || name.equals("")) {
                    FileUtil.delete(subFile);
                }
                ++n2;
            }
            this.getWriteArtifactRepository().deleteArtifactRepository();
            FileUtil.deleteEmptyDirsLogIOE(path);
        }
    }

    @Override
    public IStatus clear() {
        if (this.getStatus(false, null).isOK()) {
            this.clearElements(this.getLocationStr());
        }
        return super.clear();
    }

    private void clearElements(String a_fileName) {
        File[] subFiles;
        File path = new File(a_fileName);
        if (!path.exists()) {
            return;
        }
        File[] fileArray = subFiles = path.isDirectory() ? path.listFiles() : new File[]{};
        int n = subFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File subFile = fileArray[n2];
            if (!this.getSiteProperties().isSitePropertyFile(subFile.getName())) {
                if (subFile.isDirectory()) {
                    this.clearElements(subFile.getPath());
                } else {
                    FileUtil.delete(subFile);
                }
            }
            ++n2;
        }
        if (!path.toString().equals(this.getLocationStr())) {
            FileUtil.delete(path);
        }
    }

    @Override
    public void repositoryPropertyEventOccurred(RepositoryEventProperty event) {
        IRepository rep;
        log.debug("Received RepositoryEventProperty event in {0}: {1}", this, event);
        if ((event instanceof RepositoryEventContentAddRemove || event instanceof RepositoryEventContentElementChanged || event instanceof RepositoryEventClear || event instanceof RepositoryEventContentChanged || event instanceof RepositoryEventContentListAdd || event instanceof RepositoryEventFileAdded || event instanceof RepositoryEventFileRemoved) && (rep = event.getRepository()) instanceof ContentZip2Repository) {
            IContentRepository contentRep = (IContentRepository)event.getRepository();
            ArrayList list = this.createTocEntryList(contentRep.getLocation().getName(), contentRep);
            IContent contentElement = contentRep.getElement();
            ICicLocation contentFolderPath = this.getLP().getCalculatedFQDirPath(contentElement);
            try {
                TableOfContents.addTocEntries(this.m_session, contentFolderPath, this.m_contentInfoBeforeUpdate, list, this.m_onSaved, this.m_NullProgressMonitor);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private class RevealFileLocations
    implements IRevealFileLocations {
        private final IRevealArtifactFileLocations ral;

        public RevealFileLocations(IRevealArtifactFileLocations ral) {
            this.ral = ral;
        }

        @Override
        public File[] revealUsedArtifactRoots() {
            return this.ral.revealUsedArtifactRoots();
        }

        @Override
        public String[] revealArtifactRootNames() {
            return this.ral.revealArtifactRootNames();
        }

        @Override
        public File getTempDir() {
            return DirectoryRepository.this.getLocation().append("tmp").toFile();
        }

        @Override
        public File getExtraDir() {
            return DirectoryRepository.this.getLocation().append("extra").toFile();
        }

        @Override
        public IRepository getRepository() {
            return DirectoryRepository.this;
        }
    }
}

