/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.repository;

import com.ibm.cic.common.core.repository.ContentZip2Repository;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.repository.IZipFileHandler;
import com.ibm.cic.common.downloads.IDownloader;
import com.ibm.cic.common.downloads.IFileContentInfo;
import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;

public class ArchDownloader
implements IDownloader {
    ContentZip2Repository m_repository;
    IDownloader m_alternativeDownloader;

    public ArchDownloader(ContentZip2Repository a_repository, IDownloader alternativeDownloader) {
        this.m_repository = a_repository;
        this.m_alternativeDownloader = alternativeDownloader;
    }

    @Override
    public IStatus downloadToFile(IFileContentInfo sourceContentInfo, File destination, IProgressMonitor pm) {
        IZipFileHandler handler = this.m_repository.getArcParentHandler();
        IStatus return_value = handler == null ? this.m_alternativeDownloader.downloadToFile(sourceContentInfo, destination, pm) : handler.export(sourceContentInfo.getFileName().toString(), destination);
        return return_value;
    }

    @Override
    public boolean locationShouldBeCached(ICicLocation l) {
        if (this.m_repository.getArcParentHandler() == null) {
            return this.m_alternativeDownloader.locationShouldBeCached(l);
        }
        return true;
    }
}

