/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.repository;

import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.repository.AbstractFileBasedRepository;
import com.ibm.cic.common.core.repository.IContentRepository;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.RepositoryStatus;
import com.ibm.cic.common.core.repository.listeners.RepositoryEventContentAddRemove;
import com.ibm.cic.common.core.repository.listeners.RepositoryEventContentElementChanged;
import com.ibm.cic.common.downloads.IContentInfo;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.osgi.framework.Version;

public abstract class AbstractContentElementRepository
extends AbstractFileBasedRepository
implements IContentRepository {
    public static final String REPOSITORY_ELEMENT = "RepositoryElement";

    protected AbstractContentElementRepository(String type, String version) {
        super(type, version);
    }

    protected abstract IStatus doAddElement(IContent var1) throws IOException;

    @Override
    protected IStatus doCreateRepository() {
        Object return_value = super.doCreateRepository();
        if (return_value.isOK()) {
            try {
                return_value = this.doAddElement((IContent)this.getRepositoryInfo().getProperty(REPOSITORY_ELEMENT));
            }
            catch (IOException e) {
                e.printStackTrace();
                return_value = RepositoryStatus.ST_ERROR_CANT_CREATE_REPOSITORY;
                ((RepositoryStatus)return_value).setException(e);
            }
        }
        return return_value;
    }

    protected abstract IStatus doSaveElement(IContent var1) throws IOException;

    @Override
    public IStatus saveElement(IContent element) throws IOException {
        IContent modifiedElement;
        IStatus return_value = this.doSaveElement(element);
        if (return_value.isOK() && (modifiedElement = this.getElement()) != null) {
            this.publishEvent(new RepositoryEventContentElementChanged(this, modifiedElement));
        }
        return return_value;
    }

    @Override
    public abstract IContent getElement();

    @Override
    public IContentInfo getElementContentInfo() {
        return null;
    }

    protected abstract IContent doAddContent(IContent var1, IRepository var2) throws IOException;

    @Override
    public IContent addContent(IContent content) throws IOException {
        IContent return_value = null;
        if (content != null && this.isOpen() && this.isWritable() && (return_value = this.doAddContent(content, content.getRepository())) != null) {
            this.publishEvent(new RepositoryEventContentAddRemove(this, return_value, true));
        }
        return return_value;
    }

    public IStatus setUpdateOffering(IOffering updateOffering, IOffering baseOffering) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IStatus unsetUpdateOffering(IOffering updateOffering) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List getAllFixes(boolean includeUnavailable, IProgressMonitor progressMonitor) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public List getAllOfferings(boolean includeUnavailable, IProgressMonitor progressMonitor) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public List getAllUpdates(boolean includeUnavailable, IIdentity offeringId, Version offeringVersion, IProgressMonitor progressMonitor) {
        return Collections.EMPTY_LIST;
    }
}

