/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.repository;

import com.ibm.cic.common.core.downloads.DefaultDownloader;
import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.internal.repository.RepositoryInfo;
import com.ibm.cic.common.core.internal.repository.RepositoryRef;
import com.ibm.cic.common.core.internal.utils.CicCommonCoreDebugOptions;
import com.ibm.cic.common.core.internal.utils.CicCommonCoreTrace;
import com.ibm.cic.common.core.internal.utils.CicParserUtils;
import com.ibm.cic.common.core.model.CicFactory;
import com.ibm.cic.common.core.model.IAssembly;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.IShareableEntity;
import com.ibm.cic.common.core.model.IShareableUnit;
import com.ibm.cic.common.core.model.ISuFragment;
import com.ibm.cic.common.core.model.SimpleIdentity;
import com.ibm.cic.common.core.model.Walker;
import com.ibm.cic.common.core.model.internal.CicResolver;
import com.ibm.cic.common.core.model.internal.IFixInternal;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.repository.IContentRepository;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.IRepositoryIdentity;
import com.ibm.cic.common.core.repository.IRepositoryInfo;
import com.ibm.cic.common.core.repository.RepositoryContext;
import com.ibm.cic.common.core.repository.RepositorySiteProperties;
import com.ibm.cic.common.core.repository.RepositoryStatus;
import com.ibm.cic.common.core.repository.UpdateOfferingUtils;
import com.ibm.cic.common.core.repository.digest.RepositoryDigest;
import com.ibm.cic.common.core.repository.digest.RepositoryDigestRepositoryData;
import com.ibm.cic.common.core.repository.listeners.IRepositoryPropertyEventListener;
import com.ibm.cic.common.core.repository.listeners.RepositoryEventClear;
import com.ibm.cic.common.core.repository.listeners.RepositoryEventContentAddRemove;
import com.ibm.cic.common.core.repository.listeners.RepositoryEventContentChanged;
import com.ibm.cic.common.core.repository.listeners.RepositoryEventContentListAdd;
import com.ibm.cic.common.core.repository.listeners.RepositoryEventFileAdded;
import com.ibm.cic.common.core.repository.listeners.RepositoryEventName;
import com.ibm.cic.common.core.repository.listeners.RepositoryEventOpen;
import com.ibm.cic.common.core.repository.listeners.RepositoryEventProperty;
import com.ibm.cic.common.core.repository.listeners.RepositoryEventRepositoryCreated;
import com.ibm.cic.common.core.repository.listeners.RepositoryEventWritable;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.UserNames;
import com.ibm.cic.common.downloads.IDownloader;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

public abstract class AbstractBaseRepository
implements IRepository,
IRepositoryPropertyEventListener {
    private IRepositoryInfo m_repositoryInfo;
    private IRepositoryIdentity m_identityWrapper;
    private final Set<IRepositoryPropertyEventListener> m_listeners = new HashSet<IRepositoryPropertyEventListener>();
    private IRepository m_repositoryRef = null;
    private final String m_repositoryType;
    private final String m_repositoryVersion;
    private IStatus m_repositoryStatus = Status.OK_STATUS;
    private static final CicCommonCoreTrace m_sendEventTrace = new CicCommonCoreTrace(ComIbmCicCommonCorePlugin.getDefault(), CicCommonCoreDebugOptions.REPOSITORY_EVENT_SEND);
    private static final CicCommonCoreTrace m_recvEventTrace = new CicCommonCoreTrace(ComIbmCicCommonCorePlugin.getDefault(), CicCommonCoreDebugOptions.REPOSITORY_EVENT_RECEIVE);
    private RepositorySiteProperties m_siteProperties;
    private IDownloader m_downloader = null;
    private boolean m_writeable = true;
    private static final Logger log = Logger.getLogger(AbstractBaseRepository.class);

    public AbstractBaseRepository(String repType, String repVersion) {
        this.m_repositoryType = repType;
        this.m_repositoryVersion = repVersion;
        this.m_siteProperties = new RepositorySiteProperties();
    }

    public IStatus initializeRepository(IRepositoryInfo repInfo, IProgressMonitor progressMonitor) {
        String requestedType = repInfo.getType();
        if (requestedType != null && !requestedType.equals(this.m_repositoryType)) {
            return RepositoryStatus.ST_ERROR_UNSUPPORTED_REPOSITORY_TYPE;
        }
        String requestedVer = repInfo.getVersion();
        if (requestedVer != null && !requestedVer.equals(this.m_repositoryVersion)) {
            return RepositoryStatus.ST_ERROR_UNSUPPORTED_REPOSITORY_TYPE_VERSION;
        }
        if (repInfo.getLocation() == null || repInfo.getLocation().toString().length() == 0) {
            return RepositoryStatus.ST_ERROR_REPOSITORY_LOCATION_IS_NOT_PROVIDED;
        }
        this.m_repositoryInfo = repInfo;
        if (this.m_repositoryInfo.isReadOnlyRepositoryRequested()) {
            this.setWritable(false);
        }
        this.setDownloader();
        return Status.OK_STATUS;
    }

    protected void setDownloader() {
        this.setDownloader(new DefaultDownloader(this.m_repositoryInfo.isReadOnlyRepositoryRequested()));
    }

    @Override
    public IRepositoryInfo getRepositoryInfo() {
        return this.m_repositoryInfo;
    }

    @Override
    public String serializeRepositoryInfo() {
        RepositoryInfo repoInfo = (RepositoryInfo)this.m_repositoryInfo;
        HashMap customMap = new HashMap();
        this.setSerializeRepositoryInfoCustomMap(customMap);
        return repoInfo.serializeCustom(customMap);
    }

    protected void setSerializeRepositoryInfoCustomMap(Map customMap) {
        RepositoryContext.getInstance().setSerializeRepositoryInfoCustomMap(customMap);
    }

    @Override
    public String getLocationStr() {
        ICicLocation cicloc = this.getLocation();
        String loc = cicloc != null ? cicloc.toString() : null;
        return loc;
    }

    @Override
    public ICicLocation getLocation() {
        if (this.getRepositoryInfo() != null) {
            return this.getRepositoryInfo().getLocation();
        }
        return null;
    }

    @Override
    public UserNames getUserNames() {
        return new UserNames(this.getName(), this.getLocationStr());
    }

    protected void updateRepositoryInfo(IRepositoryInfo repInfo) throws CoreException, IOException {
        if (this.m_repositoryInfo.getType() == null) {
            this.m_repositoryInfo.setType(this.m_repositoryType);
        }
        if (this.m_repositoryInfo.getVersion() == null) {
            this.m_repositoryInfo.setVersion(this.m_repositoryVersion);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof IRepository && this.getRepositoryInfo() != null) {
            return this.getRepositoryInfo().equals(((IRepository)obj).getRepositoryInfo());
        }
        return false;
    }

    public int hashCode() {
        return this.getRepositoryInfo().hashCode();
    }

    IStatus createRepository() throws CoreException, IOException {
        IStatus return_value = this.canCreateRepository();
        if (return_value.isOK()) {
            this.setStatus(this.doCreateRepository());
            return_value = this.getStatus(false, null);
            if (return_value.isOK()) {
                this.updateRepositoryInfo(this.getRepositoryInfo());
                this.publishEvent(new RepositoryEventRepositoryCreated(this));
            }
        }
        return return_value;
    }

    IStatus addExistingRepository() throws CoreException, IOException {
        IStatus return_value = this.canAddExistingRepository(null);
        if (return_value.isOK()) {
            this.setStatus(return_value);
            this.updateRepositoryInfo(this.getRepositoryInfo());
        }
        return return_value;
    }

    protected IRepository setUniqueRepositoryInfo(IRepository masterRepository) throws IOException, CoreException {
        IRepository return_value = null;
        return return_value;
    }

    @Override
    public IStatus canAddExistingRepository(IProgressMonitor progressMonitor) {
        return this.getStatus(false, progressMonitor);
    }

    @Override
    public IStatus isRepInfoMatchingRepositoryObject(IRepositoryInfo repInfo) {
        if (repInfo.getType() != null && !repInfo.getType().equals(this.m_repositoryType)) {
            return Statuses.ERROR.get(6001, Messages.Repo_CantAddExistingRepository, new Object[0]);
        }
        if (repInfo.getVersion() != null && !repInfo.getVersion().equals(this.m_repositoryVersion)) {
            return Statuses.ERROR.get(6001, Messages.Repo_CantAddExistingRepository, new Object[0]);
        }
        if (repInfo.getLocation() == null || !repInfo.getLocation().equals(this.getLocation())) {
            return Statuses.ERROR.get(6001, Messages.Repo_CantAddExistingRepository, new Object[0]);
        }
        return Status.OK_STATUS;
    }

    protected IStatus doCreateRepository() {
        return RepositoryStatus.ST_ERROR_CANT_CREATE_REPOSITORY;
    }

    @Override
    public boolean isOpen() {
        if (this.getRepositoryInfo() != null) {
            return this.getRepositoryInfo().isOpen();
        }
        return false;
    }

    @Override
    public IStatus getStatus(boolean reEvaluate, IProgressMonitor progressMonitor) {
        return this.m_repositoryStatus;
    }

    protected void setStatus(IStatus a_status) {
        this.m_repositoryStatus = a_status;
    }

    @Override
    public List getAllContentElements(IProgressMonitor monitor) {
        ArrayList return_value = new ArrayList();
        if (this.isOpen()) {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            monitor.beginTask("", 7);
            try {
                List repElements = this.getRepositoryReference().getAllOfferings((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                if (repElements != null) {
                    return_value.addAll(repElements);
                }
                if ((repElements = this.getRepositoryReference().getAllUpdates(null, null, (IProgressMonitor)new SubProgressMonitor(monitor, 1))) != null) {
                    return_value.addAll(repElements);
                }
                if ((repElements = this.getRepositoryReference().getAllFixes((IProgressMonitor)new SubProgressMonitor(monitor, 1))) != null) {
                    return_value.addAll(repElements);
                }
                if ((repElements = this.getRepositoryReference().getAllShareableEntities((IProgressMonitor)new SubProgressMonitor(monitor, 2))) != null) {
                    return_value.addAll(repElements);
                }
                if ((repElements = this.getRepositoryReference().getAllSuFragments((IProgressMonitor)new SubProgressMonitor(monitor, 1))) != null) {
                    return_value.addAll(repElements);
                }
                if ((repElements = this.getRepositoryReference().getAllIus((IProgressMonitor)new SubProgressMonitor(monitor, 1))) != null) {
                    return_value.addAll(repElements);
                }
            }
            finally {
                monitor.done();
            }
        }
        return return_value;
    }

    @Override
    public void setOpen(boolean isOpen) {
        if (isOpen != this.getRepositoryInfo().isOpen()) {
            this.getRepositoryInfo().setOpen(isOpen);
            this.publishEvent(new RepositoryEventOpen(this, isOpen));
        }
    }

    @Override
    public IInstallableUnit findInstallableUnit(IIdentity id, Version version, IProgressMonitor progressMonitor) {
        List ius = this.getAllIus(progressMonitor);
        for (IInstallableUnit iu : ius) {
            if (!iu.getIdentity().equals(id) || !iu.getVersion().equals((Object)version)) continue;
            return iu;
        }
        return null;
    }

    @Override
    public IOffering findOffering(IIdentity id, Version version, IProgressMonitor progressMonitor) {
        return this.findOffering(false, id, version, progressMonitor);
    }

    @Override
    public IOffering findOffering(boolean includeUnavailable, IIdentity id, Version version, IProgressMonitor progressMonitor) {
        List offerings = this.getAllOfferings(includeUnavailable, progressMonitor);
        for (IOffering offering : offerings) {
            if (!offering.getIdentity().equals(id) || !offering.getVersion().equals((Object)version)) continue;
            return offering;
        }
        return null;
    }

    @Override
    public IOffering findUpdate(IIdentity id, Version version, IProgressMonitor progressMonitor) {
        return this.findUpdate(false, id, version, progressMonitor);
    }

    @Override
    public IOffering findUpdate(boolean includeUnavailable, IIdentity id, Version version, IProgressMonitor progressMonitor) {
        List updates = this.getAllUpdates(includeUnavailable, null, null, progressMonitor);
        for (IOffering update : updates) {
            if (!update.getIdentity().equals(id) || !update.getVersion().equals((Object)version)) continue;
            return update;
        }
        return null;
    }

    @Override
    public IFix findFix(IIdentity id, Version version, IProgressMonitor progressMonitor) {
        return this.findFix(false, id, version, progressMonitor);
    }

    @Override
    public IFix findFix(boolean includeUnavailable, IIdentity id, Version version, IProgressMonitor progressMonitor) {
        List fixes = this.getAllFixes(includeUnavailable, progressMonitor);
        for (IFix fix : fixes) {
            if (!fix.getIdentity().equals(id) || !fix.getVersion().equals((Object)version)) continue;
            return fix;
        }
        return null;
    }

    @Override
    public IShareableEntity findShareableEntity(IIdentity id, Version version, IProgressMonitor progressMonitor) {
        List sEntities = this.getShareableEntities(id, version, null, progressMonitor);
        if (!sEntities.isEmpty()) {
            return (IShareableEntity)sEntities.get(0);
        }
        return null;
    }

    @Override
    public List getShareableEntities(IIdentity id, Version version, VersionRange tolerance, IProgressMonitor progressMonitor) {
        ArrayList<IShareableEntity> return_value = new ArrayList<IShareableEntity>();
        List sEntities = this.getAllShareableEntities(progressMonitor);
        for (IShareableEntity se : sEntities) {
            if (id != null && !se.getIdentity().equals(id) || version != null && !se.getVersion().equals((Object)version) || tolerance != null && !tolerance.isIncluded(se.getVersion())) continue;
            return_value.add(se);
        }
        return return_value;
    }

    @Override
    public IAssembly findAssembly(IIdentity id, Version version, IProgressMonitor progressMonitor) {
        List sEntities = this.getAllAssemblies(progressMonitor);
        IAssembly return_value = null;
        Iterator I = sEntities.iterator();
        while (I.hasNext() && return_value == null) {
            return_value = (IAssembly)I.next();
            if (return_value.getIdentity().equals(id) && return_value.getVersion().equals((Object)version)) continue;
            return_value = null;
        }
        return return_value;
    }

    @Override
    public IShareableUnit findShareableUnit(IIdentity id, Version version, IProgressMonitor progressMonitor) {
        List sEntities = this.getAllSus(progressMonitor);
        IShareableUnit return_value = null;
        Iterator I = sEntities.iterator();
        while (I.hasNext() && return_value == null) {
            return_value = (IShareableUnit)I.next();
            if (return_value.getIdentity().equals(id) && return_value.getVersion().equals((Object)version)) continue;
            return_value = null;
        }
        return return_value;
    }

    @Override
    public ISuFragment findSuFragment(IIdentity id, Version version, IProgressMonitor progressMonitor) {
        List fragments = this.getAllSuFragments(progressMonitor);
        for (ISuFragment fragment : fragments) {
            if (!fragment.getIdentity().equals(id) || version != null && !fragment.getVersion().equals((Object)version)) continue;
            return fragment;
        }
        return null;
    }

    @Override
    public List getAllShareableEntities(IProgressMonitor progressMonitor) {
        List sEntities = this.getAllAssemblies(progressMonitor);
        sEntities.addAll(this.getAllSus(progressMonitor));
        return sEntities;
    }

    protected void initializeExtModel(IContent contElement, ICicLocation a_relativeLocation) {
        if (contElement != null) {
            if (contElement.getLocation() == null) {
                contElement.setLocation(a_relativeLocation);
            }
            if (contElement.getRepository() == null) {
                this.setRepository(contElement);
            }
        }
    }

    private void setRepository(IContent elem) {
        if (elem != null) {
            Walker walker = new Walker(){

                @Override
                public void doUnit(IContent element) throws Exception {
                    element.setRepository(AbstractBaseRepository.this.getRepositoryReference());
                }

                @Override
                protected boolean canHaveUnresolvedIncludes() {
                    return true;
                }
            };
            try {
                walker.walkIncludes(elem);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public String getName() {
        return this.getRepositoryInfo().getName();
    }

    @Override
    public boolean isWritable() {
        return this.m_writeable;
    }

    @Override
    public void setName(String name) {
        if (!name.equals(this.getName())) {
            this.getRepositoryInfo().setName(name);
            this.publishEvent(new RepositoryEventName(this, name));
        }
    }

    protected final void setWritable(boolean writable) {
        if (writable != this.m_writeable) {
            this.m_writeable = writable;
            this.publishEvent(new RepositoryEventWritable(this, this.m_writeable));
        }
    }

    protected void publishEvent(RepositoryEventProperty event) {
        if (AbstractBaseRepository.m_sendEventTrace.enabled) {
            m_sendEventTrace.println("SENT:" + event.toString());
        }
        for (IRepositoryPropertyEventListener listener : this.m_listeners) {
            if (AbstractBaseRepository.m_recvEventTrace.enabled) {
                m_sendEventTrace.println("DELIVERING " + event.toString() + " TO:'" + listener.getClass().getName() + "#repositoryPropertyEventOccurred()'");
            }
            listener.repositoryPropertyEventOccurred(event);
        }
    }

    @Override
    public void refresh() {
        this.getSiteProperties().clear();
        this.getStatus(true, null);
    }

    @Override
    public IContent refreshContent(IContent content) {
        IContent return_value = content;
        if (content != null && this.isOpen() && this.getStatus(false, null).isOK()) {
            return_value = this.findContent(content);
            if (return_value == null) {
                this.publishEvent(new RepositoryEventContentAddRemove(this, content, false));
            } else {
                this.publishEvent(new RepositoryEventContentChanged(this, return_value));
            }
        }
        return return_value;
    }

    @Override
    public void registerListener(IRepositoryPropertyEventListener listener) {
        this.m_listeners.add(listener);
    }

    @Override
    public void unregisterListener(IRepositoryPropertyEventListener listener) {
        this.m_listeners.remove(listener);
    }

    @Override
    public IContent addContent(IContent content) throws IOException {
        IContent return_value = null;
        if (content != null && this.canAddContent() && this.findContent(content) == null && this.doAddContent(content).isOK() && (return_value = this.findContent(content)) != null) {
            this.publishEvent(new RepositoryEventContentAddRemove(this, return_value, true));
        }
        return return_value;
    }

    protected IStatus doAddContent(IContent content) throws IOException {
        return RepositoryStatus.ST_ERROR_CONTENT_ELEMENT_CANT_BE_ADDED;
    }

    protected IContent findContent(IContent content) {
        if (content instanceof IOffering) {
            if (UpdateOfferingUtils.isUpdate(content)) {
                return this.findUpdate(content.getIdentity(), content.getVersion(), null);
            }
            return this.findOffering(content.getIdentity(), content.getVersion(), null);
        }
        if (content instanceof IFix) {
            return this.findFix(content.getIdentity(), content.getVersion(), null);
        }
        if (content instanceof IAssembly) {
            return this.findAssembly(content.getIdentity(), content.getVersion(), null);
        }
        if (content instanceof IShareableUnit) {
            return this.findShareableUnit(content.getIdentity(), content.getVersion(), null);
        }
        if (content instanceof ISuFragment) {
            return this.findSuFragment(content.getIdentity(), content.getVersion(), null);
        }
        if (content instanceof IInstallableUnit) {
            return this.findInstallableUnit(content.getIdentity(), content.getVersion(), null);
        }
        return null;
    }

    private boolean canAddContent() {
        return this.isOpen() && this.isWritable() && this.getStatus(true, null).isOK() && this.canStoreMetadata();
    }

    private boolean belongsToThis(IContent content) {
        IRepository repo = content.getRepository();
        return repo != null && repo.getRepositoryReference() == this.getRepositoryReference();
    }

    @Override
    public IStatus saveContent(IContent content) throws IOException {
        RepositoryStatus return_value = RepositoryStatus.ST_ERROR_CONTENT_ELEMENT_CANT_BE_SAVED;
        if (content != null && this.canAddContent() && this.belongsToThis(content)) {
            return_value = this.doSaveContent(content);
        }
        return return_value;
    }

    protected IStatus doSaveContent(IContent content) throws IOException {
        return RepositoryStatus.ST_ERROR_CONTENT_ELEMENT_CANT_BE_SAVED;
    }

    @Override
    public IStatus addContent(List contentList) throws IOException {
        if (contentList == null) {
            return RepositoryStatus.ST_ERROR_CONTENT_ELEMENT_CANT_BE_ADDED;
        }
        if (!contentList.isEmpty()) {
            for (IContent element : contentList) {
                if (this.addContent(element) != null) continue;
                return RepositoryStatus.ST_ERROR_CONTENT_ELEMENT_CANT_BE_ADDED;
            }
            this.publishEvent(new RepositoryEventContentListAdd(this, contentList.size()));
        }
        return Status.OK_STATUS;
    }

    @Override
    public IContent moveContent(IContent content) throws IOException {
        IContent return_value = null;
        if (content != null && content.getRepository() != null && (return_value = this.addContent(content)) != null) {
            content.getRepository().deleteContent(content);
        }
        return return_value;
    }

    @Override
    public IStatus deleteContent(IContent content) throws IOException {
        RepositoryStatus return_value = RepositoryStatus.ST_ERROR_CONTENT_ELEMENT_NOT_FROM_REPOSITORY;
        if (content != null && this.canAddContent() && this.belongsToThis(content) && (return_value = this.doDeleteContent(content)).isOK()) {
            this.publishEvent(new RepositoryEventContentAddRemove(this, content, false));
        }
        return return_value;
    }

    protected IStatus doDeleteContent(IContent content) throws IOException {
        return Status.CANCEL_STATUS;
    }

    @Override
    public IAssembly createAssembly(IIdentity id, Version version) throws IOException {
        IAssembly assembly = CicFactory.getInstance().createAssembly(id, version);
        return (IAssembly)this.addContent(assembly);
    }

    @Override
    public IFix createFix(IIdentity id, Version version) throws IOException {
        IFix fix = CicFactory.getInstance().createFix(id, version);
        ((IFixInternal)((Object)fix)).setInternalOfferingId(new SimpleIdentity(String.valueOf(id.getId()) + "_offering"));
        ((IFixInternal)((Object)fix)).setInternalOfferingVersion(version);
        fix.setAssemblyId(new SimpleIdentity(String.valueOf(id.getId()) + "_assembly"));
        fix.setAssemblyVersion(version);
        return (IFix)this.addContent(fix);
    }

    @Override
    public IOffering createOffering(IIdentity id, Version version) throws IOException {
        IOffering offering = CicFactory.getInstance().createOffering(id, version);
        offering.setAssemblyId(new SimpleIdentity(String.valueOf(id.getId()) + "_assembly"));
        offering.setAssemblyVersion(version);
        return (IOffering)this.addContent(offering);
    }

    @Override
    public IShareableUnit createSu(IIdentity id, Version version) throws IOException {
        IShareableUnit su = CicFactory.getInstance().createShareableUnit(id, version);
        return (IShareableUnit)this.addContent(su);
    }

    @Override
    public ISuFragment createSuFragment(IIdentity id, Version version) throws IOException {
        ISuFragment suFragment = CicFactory.getInstance().createSuFragment(id, version);
        return (ISuFragment)this.addContent(suFragment);
    }

    @Override
    public IInstallableUnit createIu(IIdentity id, Version version) throws IOException {
        IInstallableUnit iu = CicFactory.getInstance().createInstallableUnit(id, version);
        return (IInstallableUnit)this.addContent(iu);
    }

    @Override
    public IStatus clear() {
        IStatus return_value = this.getStatus(false, null);
        if (return_value.isOK()) {
            this.publishEvent(new RepositoryEventClear(this));
        }
        return return_value;
    }

    @Override
    public IStatus delete(boolean mustClear) {
        if (mustClear) {
            this.clear();
        }
        if (this.getStatus(false, null).isOK()) {
            this.doDelete();
        }
        if (this.getStatus(false, null).isOK()) {
            this.dispose();
        }
        return this.getStatus(false, null);
    }

    @Override
    public void dispose() {
    }

    protected void doDelete() {
    }

    @Override
    public boolean containsMetadata() {
        return !this.getAllContentElements(null).isEmpty();
    }

    @Override
    public boolean containsArtifacts() {
        return true;
    }

    @Override
    public InputStream getContentInputStream(IContent content) throws IOException {
        return this.getInputStream(content.getLocation().toString());
    }

    @Override
    public InputStream getInputStream(String relativePath) throws IOException {
        URL contentURL = this.getLocation().append(relativePath).toURL();
        return CicParserUtils.getStreamForURL(contentURL);
    }

    @Override
    public IRepository getRepositoryReference() {
        if (this.m_repositoryRef == null) {
            this.m_repositoryRef = new RepositoryRef(this);
        }
        return this.m_repositoryRef;
    }

    @Override
    public void setRepositoryReference(IRepository repository) {
        this.m_repositoryRef = repository;
    }

    @Override
    public boolean canStoreArtifacts() {
        return true;
    }

    @Override
    public boolean canStoreMetadata() {
        return true;
    }

    @Override
    public List getAllAssemblies(IProgressMonitor progressMonitor) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public List getAllFixes(IProgressMonitor progressMonitor) {
        return this.getAllFixes(false, progressMonitor);
    }

    @Override
    public List getAllFixes(boolean includeUnavailable, IProgressMonitor progressMonitor) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public List getAllIus(IProgressMonitor progressMonitor) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public List getAllOfferings(IProgressMonitor progressMonitor) {
        return this.getAllOfferings(false, progressMonitor);
    }

    @Override
    public List getAllOfferings(boolean includeUnavailable, IProgressMonitor progressMonitor) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public List getAllUpdates(IIdentity offeringId, Version offeringVersion, IProgressMonitor progressMonitor) {
        return this.getAllUpdates(false, offeringId, offeringVersion, progressMonitor);
    }

    @Override
    public List getAllUpdates(boolean includeUnavailable, IIdentity offeringId, Version offeringVersion, IProgressMonitor progressMonitor) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public IStatus canCreateRepository() {
        if (this.canAddExistingRepository(null).isOK()) {
            return new RepositoryStatus(RepositoryStatus.ST_ERROR_CANT_CREATE_REPOSITORY_ALREADY_EXISTS, this.getLocationStr());
        }
        return Status.OK_STATUS;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getType());
        sb.append(' ');
        sb.append(this.getVersion());
        sb.append("\n name:");
        sb.append(this.getName());
        sb.append("\n loc :");
        sb.append(this.getLocationStr());
        sb.append("\n writeable: ");
        sb.append(this.isWritable());
        sb.append("; open: ");
        sb.append(this.isOpen());
        return sb.toString();
    }

    @Override
    public IContentRepository getContentRepository(IContent element) {
        return null;
    }

    @Override
    public IStatus resolve(IOfferingOrFix element, IProgressMonitor progressMonitor) {
        List ses = this.getAllShareableEntities(progressMonitor);
        if (ses.size() > 0) {
            return CicResolver.resolve(element, ses);
        }
        return RepositoryStatus.ST_ERROR_CONTENT_ELEMENT_CANT_BE_RESOLVED;
    }

    protected void setSiteProperties(RepositorySiteProperties siteProperties) {
        this.m_siteProperties = siteProperties;
    }

    protected void setDownloader(IDownloader a_downloader) {
        this.m_downloader = a_downloader;
    }

    @Override
    public RepositorySiteProperties getSiteProperties() {
        return this.m_siteProperties;
    }

    public IDownloader getDownloader() {
        return this.m_downloader;
    }

    @Override
    public String getType() {
        return this.m_repositoryType;
    }

    @Override
    public String getVersion() {
        return this.m_repositoryVersion;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IRepositoryIdentity.class) {
            if (this.m_identityWrapper == null) {
                this.m_identityWrapper = new IRepositoryIdentity(){

                    @Override
                    public boolean equals(Object o) {
                        return o == this;
                    }

                    @Override
                    public int hashCode() {
                        return System.identityHashCode(AbstractBaseRepository.this);
                    }
                };
            }
            return this.m_identityWrapper;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    @Override
    public IStatus updateRepositoryDigest(int a_request, IProgressMonitor progressMonitor) {
        Object return_value = Status.OK_STATUS;
        RepositoryDigest rd = this.getSiteProperties().getRepositoryDigest();
        switch (a_request) {
            case 2: {
                if (this.isWritable() && this.getStatus(true, null).isOK()) {
                    RepositoryDigestRepositoryData rdd = rd.getThisRepositoryData();
                    if (rdd == null) break;
                    rdd.clearDigestInfo();
                    return_value = this.getSiteProperties().deleteRepositoryDigest();
                    break;
                }
                return_value = RepositoryStatus.ST_ERROR_REPOSITORY_IS_NOT_WRITABLE;
                break;
            }
            case 4: {
                RepositoryDigestRepositoryData rdd = rd.getThisRepositoryData();
                break;
            }
            case 8: {
                if (this.isWritable()) break;
                return_value = RepositoryStatus.ST_ERROR_REPOSITORY_IS_NOT_WRITABLE;
                break;
            }
            case 1: {
                if (this.isWritable()) {
                    CicMultiStatus result = Statuses.ST.createMultiStatus();
                    this.generateRepositoryDigestData(result, progressMonitor);
                    if (result.isOK()) {
                        return_value = this.getSiteProperties().saveRepositoryDigest(null);
                        break;
                    }
                    return_value = result;
                    break;
                }
                return_value = RepositoryStatus.ST_ERROR_REPOSITORY_IS_NOT_WRITABLE;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return return_value;
    }

    @Override
    public RepositoryDigestRepositoryData getRepositoryDigestData() {
        return this.getSiteProperties().getRepositoryDigest().getThisRepositoryData();
    }

    @Override
    public RepositoryDigestRepositoryData generateRepositoryDigestData(CicMultiStatus status, IProgressMonitor pm) {
        IOffering of;
        RepositoryDigestRepositoryData return_value = this.getRepositoryDigestData();
        SplitProgressMonitor spm = new SplitProgressMonitor(pm, 6);
        IStatus op_status = Status.OK_STATUS;
        return_value.addRepositoryDigestDictionaryList(this);
        List offerings = this.getRepositoryReference().getAllOfferings(spm.next());
        SplitProgressMonitor spm2 = new SplitProgressMonitor(spm.next(), offerings.size());
        Iterator I = offerings.iterator();
        while (I.hasNext() && op_status.isOK()) {
            of = (IOffering)I.next();
            op_status = return_value.addOfferingDigestData(of, spm2.next());
        }
        List updates = this.getRepositoryReference().getAllUpdates(null, null, spm.next());
        spm2 = new SplitProgressMonitor(spm.next(), updates.size());
        I = updates.iterator();
        while (I.hasNext() && op_status.isOK()) {
            of = (IOffering)I.next();
            op_status = return_value.addOfferingDigestData(of, spm2.next());
        }
        List fixes = this.getRepositoryReference().getAllFixes(spm.next());
        spm2 = new SplitProgressMonitor(spm.next(), fixes.size());
        I = fixes.iterator();
        while (I.hasNext() && op_status.isOK()) {
            IFix fix = (IFix)I.next();
            op_status = return_value.addFixDigestData(fix, spm2.next());
        }
        if (!op_status.isOK()) {
            status.add(op_status);
        } else {
            return_value.setUseContentData(true);
        }
        return return_value;
    }

    protected abstract IStatus doImportP2Repository(File var1, IProgressMonitor var2);

    @Override
    public IStatus importP2Repository(File sourceP2RepositoryFile, IProgressMonitor monitor) {
        IStatus return_value = this.doImportP2Repository(sourceP2RepositoryFile, monitor);
        if (return_value != null && return_value.isOK()) {
            this.publishEvent(new RepositoryEventFileAdded(this, sourceP2RepositoryFile.getAbsolutePath()));
        }
        return return_value;
    }

    @Override
    public void repositoryPropertyEventOccurred(RepositoryEventProperty event) {
        log.debug("Received RepositoryEventProperty event in {0}: {1}", this, event);
    }
}

