/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.repository;

import com.ibm.cic.common.core.artifactrepo.IArtifactLocator;
import com.ibm.cic.common.core.artifactrepo.IArtifactSession;
import com.ibm.cic.common.core.artifactrepo.IReadArtifactRepo;
import com.ibm.cic.common.core.artifactrepo.impl.AbstractReadArtifactRepo;
import com.ibm.cic.common.core.artifactrepo.impl.RepoAs;
import com.ibm.cic.common.core.internal.artifactrepo.ArtifactGroupUtil;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.StatusCodes;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.downloads.IContentInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;

public abstract class AbstractArtifactRepositoryGroup
extends AbstractReadArtifactRepo {
    protected abstract Collection getRepositories();

    private IStatus doRepositories(IArtifactSession session, IArtifact artifact, IExistsOrGetLocatorOperation op, IProgressMonitor monitor) {
        ArrayList<IStatus> listStatus = new ArrayList<IStatus>();
        boolean hasErrors = false;
        Collection repositories = this.getRepositories();
        SplitProgressMonitor spm = new SplitProgressMonitor(monitor, repositories.size());
        try {
            for (IRepository rep : repositories) {
                IStatus status;
                if (!rep.isOpen() || !rep.getStatus(false, (IProgressMonitor)new SubProgressMonitor(monitor, 0)).isOK() || StatusCodes.isContentNotFound(status = op.execute(rep, spm.next()))) continue;
                if (status.isOK() || status.matches(8)) {
                    AbstractArtifactRepositoryGroup.logGetArtifactIntermediateIssues(artifact, listStatus);
                    IStatus iStatus = status;
                    return iStatus;
                }
                if (status.matches(4)) {
                    listStatus.add(status);
                    hasErrors = true;
                    continue;
                }
                if (!status.matches(2)) continue;
                listStatus.add(status);
            }
            if (hasErrors) {
                IStatus iStatus = AbstractArtifactRepositoryGroup.createGetArtifactLocatorError(artifact, listStatus.toArray(new IStatus[listStatus.size()]), null);
                return iStatus;
            }
            AbstractArtifactRepositoryGroup.logGetArtifactIntermediateIssues(artifact, listStatus);
            IStatus iStatus = AbstractArtifactRepositoryGroup.createArtifactNotFoundStatus(0, null, artifact);
            return iStatus;
        }
        finally {
            spm.done();
        }
    }

    @Override
    public IStatus existsArtifact(final IArtifactSession session, final IArtifact artifact, IProgressMonitor monitor) {
        return this.doRepositories(session, artifact, new IExistsOrGetLocatorOperation(){

            @Override
            public IStatus execute(IRepository repo, IProgressMonitor amonitor) {
                return RepoAs.IArtifactGet(repo).existsArtifact(session, artifact, amonitor);
            }
        }, monitor);
    }

    @Override
    protected IStatus doGetArtifactLocatorChecked(final IArtifactSession session, IReadArtifactRepo.IArtifactToc atoc, final IArtifact artifact, IProgressMonitor monitor, final IArtifactLocator[] result) {
        return this.doRepositories(session, artifact, new IExistsOrGetLocatorOperation(){

            @Override
            public IStatus execute(IRepository repo, IProgressMonitor amonitor) {
                return RepoAs.IArtifactGet(repo).getArtifactLocator(session, artifact, amonitor, result);
            }
        }, monitor);
    }

    private static void logGetArtifactIntermediateIssues(IArtifact artifact, List allStatus) {
        ArtifactGroupUtil.logGetArtifactIntermediateIssues(log, artifact, allStatus);
    }

    @Override
    protected IStatus doGetArtifactLocator(IArtifactSession session, IArtifact artifact, IContentInfo tocContentInfo, IProgressMonitor monitor, IArtifactLocator[] result) {
        throw new AssertionError();
    }

    @Override
    public IReadArtifactRepo.IArtifactToc readArtifactToc(IArtifactSession session, IProgressMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IReadArtifactRepo.IArtifactToc readCachedArtifactToc(IArtifactSession session, IPath tocCache, IProgressMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    static interface IExistsOrGetLocatorOperation {
        public IStatus execute(IRepository var1, IProgressMonitor var2);
    }
}

