/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.preferences;

import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.preferences.ICicPreferenceConstants;
import com.ibm.cic.common.core.utils.Statuses;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class PreferenceUtil {
    public static final int ERRROR_CODE_UNKNOWN_PREFERENCE = 10;

    public static IStatus getUnknownPreferenceError(String key) {
        return Statuses.ERROR.get(10, Messages.PreferenceUtil_unknownPreference, key);
    }

    public static boolean isUnknownPreference(IStatus status) {
        return status.getCode() == 10 && Statuses.pluginId.equals(status.getPlugin()) && status.matches(4);
    }

    public static IStatus checkValue(ICicPreferenceConstants.PreferenceTag tag, String value) {
        if (tag.type() == 1) {
            return Status.OK_STATUS;
        }
        if (tag.type() == 2) {
            return PreferenceUtil.checkBoolean(tag.key(), value);
        }
        return Status.OK_STATUS;
    }

    public static IStatus checkInteger(String key, String value) {
        try {
            new Integer(value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Statuses.ERROR.get(Messages.PreferenceUtil_valueNotInteger, key, value);
        }
        return Status.OK_STATUS;
    }

    public static IStatus checkBoolean(String key, String value) {
        return Status.OK_STATUS;
    }

    public static IStatus checkEnumLiterals(Collection<String> enumLiterals, String key, String value) {
        if (PreferenceUtil.isValidEnumValue(enumLiterals, value)) {
            return Status.OK_STATUS;
        }
        return Statuses.ERROR.get(Messages.PreferenceUtil_valueNotEnum, key, value, enumLiterals);
    }

    private static boolean isValidEnumValue(Collection<String> enumLiterals, String value) {
        for (String e : enumLiterals) {
            if (!value.equalsIgnoreCase(e)) continue;
            return true;
        }
        return false;
    }

    public static boolean isKey(String key, ICicPreferenceConstants.PreferenceTag prefTag) {
        return PreferenceUtil.isKey(key, prefTag.key());
    }

    public static boolean isKey(String key, String otherKey) {
        return otherKey.equals(key);
    }
}

