/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.preferences;

import com.ibm.cic.common.core.preferences.CicPreferenceManager;
import com.ibm.cic.common.core.preferences.ICicPreferenceConstants;
import com.ibm.cic.common.core.preferences.ICicPreferenceHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public abstract class CicAbstractPreferenceHandler
extends ICicPreferenceConstants
implements ICicPreferenceHandler {
    private static final String ENFORCE = "_ENFORCE";
    private static final String EDITABLE = "_EDITABLE";
    private static final boolean DEFAULT_BOOLEAN = false;
    private static final String INDEX_SEPARATOR = "_";
    private IEclipsePreferences m_preferences;
    private CicPreferenceManager m_preferenceManager;
    private final Map temporaryPrefs = new HashMap();

    @Override
    public void init(CicPreferenceManager prefMan) {
        this.m_preferenceManager = prefMan;
        this.refresh();
    }

    public CicPreferenceManager getPrefMan() {
        return this.m_preferenceManager;
    }

    @Override
    public void setPreferences(IEclipsePreferences preferences) {
        this.m_preferences = preferences;
    }

    @Override
    public IEclipsePreferences getPreferences() {
        return this.m_preferences;
    }

    @Override
    public String getString(String key) {
        return this.m_preferences.get(key, "");
    }

    @Override
    public boolean isSet(String key) {
        return this.m_preferences.get(key, null) != null;
    }

    @Override
    public boolean isSetEditable(String key) {
        return this.isSet(String.valueOf(key) + EDITABLE);
    }

    @Override
    public void setValue(String key, String value) {
        this.m_preferences.put(key, value);
    }

    @Override
    public void setValue(String key, boolean value) {
        this.m_preferences.putBoolean(key, value);
    }

    @Override
    public boolean isEditable(ICicPreferenceConstants.PreferenceTag tag) {
        return this.isEditable(tag.key());
    }

    @Override
    public boolean isEditable(String tag) {
        return this.getBoolean(String.valueOf(tag) + EDITABLE);
    }

    @Override
    public boolean isEnforced(String name) {
        return this.getBoolean(String.valueOf(name) + ENFORCE);
    }

    @Override
    public void setEditable(String name, boolean isEditable) {
        this.setValue(String.valueOf(name) + EDITABLE, isEditable);
    }

    @Override
    public String[] getStringArray(String name) {
        ArrayList<String> return_value = new ArrayList<String>();
        String val = this.getString(name);
        if (val.length() > 0) {
            return_value.add(val);
            int i = 1;
            while ((val = this.getString(this.createIndexedName(name, i))).length() > 0) {
                return_value.add(val);
                ++i;
            }
        }
        return return_value.toArray(new String[return_value.size()]);
    }

    @Override
    public boolean isArray(String name) {
        return this.getString(this.createIndexedName(name, 1)).length() > 0;
    }

    @Override
    public void setValues(String name, String[] value) {
        int i = 0;
        while (i < value.length) {
            this.setValue(this.createIndexedName(name, i), value[i]);
            ++i;
        }
    }

    @Override
    public boolean getBoolean(ICicPreferenceConstants.PreferenceTag tag) {
        return this.getBoolean(tag.key());
    }

    @Override
    public boolean getBoolean(String tag) {
        return this.m_preferences.getBoolean(tag, false);
    }

    @Override
    public void addValue(String name, String value) {
        String[] vals = this.getStringArray(name);
        this.setValue(this.createIndexedName(name, vals.length), value);
    }

    @Override
    public void addFirstValue(ICicPreferenceConstants.PreferenceTag tag, String value) {
        if (value != null) {
            String[] vals = this.getStringArray(tag.key());
            this.setValue(this.createIndexedName(tag.key(), 0), value);
            int i = 0;
            while (i < vals.length) {
                this.setValue(this.createIndexedName(tag.key(), i + 1), vals[i]);
                ++i;
            }
        }
    }

    @Override
    public void addFirstValue(ICicPreferenceConstants.PreferenceTag tag, String value, boolean isTemporary) {
        if (value != null) {
            String[] vals = this.getStringArray(tag.key());
            this.setValue(this.createIndexedName(tag.key(), 0), value);
            int i = 0;
            while (i < vals.length) {
                this.setValue(this.createIndexedName(tag.key(), i + 1), vals[i]);
                ++i;
            }
            if (isTemporary) {
                HashSet<String> values = (HashSet<String>)this.temporaryPrefs.get(tag);
                if (values == null) {
                    values = new HashSet<String>();
                    this.temporaryPrefs.put(tag, values);
                }
                values.add(value);
            }
        }
    }

    @Override
    public void removeTemporaryValues() {
        for (ICicPreferenceConstants.PreferenceTag tag : this.temporaryPrefs.keySet()) {
            Set values = (Set)this.temporaryPrefs.get(tag);
            for (String value : values) {
                this.remove(tag, value);
            }
        }
        this.temporaryPrefs.clear();
    }

    @Override
    public void remove(ICicPreferenceConstants.PreferenceTag tag) {
        this.remove(tag, null);
    }

    @Override
    public void remove(String key) {
        this.m_preferences.remove(key);
    }

    @Override
    public void remove(ICicPreferenceConstants.PreferenceTag tag, String value) {
        String[] vals = this.getStringArray(tag.key());
        int lastIndex = vals.length - 1;
        int i = 0;
        while (i < vals.length) {
            ICicPreferenceConstants.ComposedPreferenceTag subTag;
            ICicPreferenceConstants.PreferenceTag subPref;
            int n;
            int n2;
            ICicPreferenceConstants.PreferenceTag[] preferenceTagArray;
            String val = vals[i];
            if (value == null || lastIndex == 0) {
                this.m_preferences.remove(this.createIndexedName(tag.key(), i));
                preferenceTagArray = tag.subPrefs();
                n2 = preferenceTagArray.length;
                n = 0;
                while (n < n2) {
                    subPref = preferenceTagArray[n];
                    subTag = new ICicPreferenceConstants.ComposedPreferenceTag(tag, val, subPref);
                    this.remove(subTag, null);
                    ++n;
                }
            } else if (val.equals(value)) {
                preferenceTagArray = tag.subPrefs();
                n2 = preferenceTagArray.length;
                n = 0;
                while (n < n2) {
                    subPref = preferenceTagArray[n];
                    subTag = new ICicPreferenceConstants.ComposedPreferenceTag(tag, val, subPref);
                    this.remove(subTag, null);
                    ++n;
                }
                int k = i;
                while (k < lastIndex) {
                    this.setValue(this.createIndexedName(tag.key(), k), vals[k + 1]);
                    ++k;
                }
                this.m_preferences.remove(this.createIndexedName(tag.key(), lastIndex));
                break;
            }
            ++i;
        }
        if (vals.length == 0) {
            this.m_preferences.remove(tag.key());
        }
    }

    @Override
    public void remove(String key, String value) {
        String[] vals = this.getStringArray(key);
        int lastIndex = vals.length - 1;
        int i = 0;
        while (i < vals.length) {
            if (value == null || lastIndex == 0 && value.equals(vals[i])) {
                this.m_preferences.remove(this.createIndexedName(key, i));
            } else if (vals[i].equals(value)) {
                int k = i;
                while (k < lastIndex) {
                    this.setValue(this.createIndexedName(key, k), vals[k + 1]);
                    ++k;
                }
                this.m_preferences.remove(this.createIndexedName(key, lastIndex));
                break;
            }
            ++i;
        }
        if (vals.length == 0) {
            this.m_preferences.remove(key);
        }
    }

    @Override
    public void moveDown(ICicPreferenceConstants.PreferenceTag tag, String value) {
        if (value != null) {
            String[] vals = this.getStringArray(tag.key());
            int i = 0;
            while (i < vals.length - 1) {
                if (vals[i].equals(value)) {
                    this.setValue(this.createIndexedName(tag.key(), i + 1), vals[i]);
                    this.setValue(this.createIndexedName(tag.key(), i), vals[i + 1]);
                }
                ++i;
            }
        }
    }

    @Override
    public void moveUp(ICicPreferenceConstants.PreferenceTag tag, String value) {
        if (value != null) {
            String[] vals = this.getStringArray(tag.key());
            int i = 1;
            while (i < vals.length) {
                if (vals[i].equals(value)) {
                    this.setValue(this.createIndexedName(tag.key(), i - 1), vals[i]);
                    this.setValue(this.createIndexedName(tag.key(), i), vals[i - 1]);
                }
                ++i;
            }
        }
    }

    protected String createIndexedName(String name, int i) {
        return i > 0 ? String.valueOf(name) + INDEX_SEPARATOR + i : name;
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public IStatus getStatus() {
        return Status.OK_STATUS;
    }

    @Override
    public boolean refresh() {
        return false;
    }

    @Override
    public void backup(ICicPreferenceHandler remoteHandler) {
    }

    @Override
    public void restoreBackup() {
    }

    @Override
    public void removeBackup() {
    }
}

