/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.validation;

import java.util.LinkedList;
import java.util.List;

public abstract class ValidationCategory {
    private static List instances = new LinkedList();
    public static final ValidationCategory BASIC = new Implementation("BASIC");
    public static final ValidationCategory ADVANCED = new Implementation("ADVANCED");

    protected ValidationCategory() {
        instances.add(this);
    }

    public static int getCount() {
        return instances.size();
    }

    public static ValidationCategory[] getAll() {
        return instances.toArray(new ValidationCategory[ValidationCategory.getCount()]);
    }

    public static ValidationCategory[] get(int fromLevel) {
        return ValidationCategory.get(fromLevel, instances.size() - 1);
    }

    public static ValidationCategory[] get(int fromLevel, int toLevel) {
        int total = instances.size();
        if (fromLevel <= toLevel && fromLevel >= 0 && toLevel < total) {
            ValidationCategory[] result = new ValidationCategory[toLevel - fromLevel + 1];
            int i = fromLevel;
            while (i <= toLevel) {
                result[i] = (ValidationCategory)instances.get(i);
                ++i;
            }
            return result;
        }
        throw new IllegalArgumentException("Insufficient levels - " + String.valueOf(total));
    }

    public static ValidationCategory getByLevelNum(int i) {
        if (i >= 0 && i < instances.size()) {
            return (ValidationCategory)instances.get(i);
        }
        return null;
    }

    public static ValidationCategory getByLevelNumStr(String s) {
        try {
            int i = Integer.parseInt(s);
            return ValidationCategory.getByLevelNum(i);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static ValidationCategory getByName(String name) {
        for (ValidationCategory result : instances) {
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public abstract int getLevel();

    public abstract String getName();

    protected static final class Implementation
    extends ValidationCategory {
        private static int count = 0;
        private final int level = count++;
        private final String name;

        public Implementation(String name) {
            this.name = name;
        }

        @Override
        public int getLevel() {
            return this.level;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.getName();
        }
    }
}

