/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class TwoTierMap<K1, K2, V> {
    private final Map<K1, Map<K2, V>> outerMap;
    private final int policy;
    public static final int POLICY_NONE = 0;
    public static final int POLICY_BOTH_MAPS_PRESERVE_ORDERING = 1;
    public static final int POLICY_INNER_MAP_PRESERVE_EXISTING = 2;
    public static final int POLICY_INNER_MAP_SORTED_ASCENDING = 4;
    public static final int POLICY_INNER_MAP_SORTED_DESCENDING = 8;
    public static final int POLICY_INNER_MAP_ENSURE_SINGLETON = 16;
    private static final int POLICY_INNER_MAP_SORTED_MASK = 12;

    public TwoTierMap() {
        this(8, 0);
    }

    public TwoTierMap(int initialCapacity) {
        this(initialCapacity, 0);
    }

    public TwoTierMap(int initialCapacity, int policy) {
        this.policy = policy;
        this.outerMap = this.shouldUseOrderedMap() ? new LinkedHashMap(initialCapacity) : new HashMap(initialCapacity);
    }

    public V put(K1 key1, K2 key2, V value) {
        V existing;
        Map<K2, V> innerMap = this.getMap(key1);
        if (innerMap == null) {
            if (this.shouldUseSingletonInnerMap()) {
                this.outerMap.put(key1, Collections.singletonMap(key2, value));
                return null;
            }
            innerMap = this.createInnerMap();
            this.outerMap.put(key1, innerMap);
        }
        if ((existing = innerMap.put(key2, value)) != null && this.shouldPreserveExisting()) {
            innerMap.put(key2, existing);
        }
        return existing;
    }

    public V get(K1 key1, K2 key2) {
        Map<K2, V> innerMap = this.getMap(key1);
        return innerMap == null ? null : (V)innerMap.get(key2);
    }

    public Collection<V> getAll(K1 key1) {
        Map<K2, V> innerMap = this.getMap(key1);
        return innerMap == null ? Collections.emptyList() : Collections.unmodifiableCollection(innerMap.values());
    }

    public V remove(K1 key1, K2 key2) {
        Map<K2, V> innerMap = this.getMap(key1);
        if (innerMap == null) {
            return null;
        }
        if (this.shouldUseSingletonInnerMap()) {
            V result = innerMap.get(key2);
            if (result != null) {
                this.outerMap.remove(key1);
            }
            return result;
        }
        V result = innerMap.remove(key2);
        if (result != null && innerMap.isEmpty()) {
            this.outerMap.remove(key1);
        }
        return result;
    }

    public boolean containsKey(K1 key1, K2 key2) {
        return this.get(key1, key2) != null;
    }

    public void clear() {
        this.outerMap.clear();
    }

    public boolean containsKey(K1 key) {
        return this.outerMap.containsKey(key);
    }

    public boolean containsValue(V value) {
        for (Map.Entry<K1, Map<K2, V>> entry : this.outerMap.entrySet()) {
            if (!entry.getValue().containsValue(value)) continue;
            return true;
        }
        return false;
    }

    public int size() {
        int result = 0;
        for (Map.Entry<K1, Map<K2, V>> entry : this.outerMap.entrySet()) {
            result += entry.getValue().size();
        }
        return result;
    }

    public boolean isEmpty() {
        return this.outerMap.isEmpty();
    }

    public Set<Map.Entry<K1, Map<K2, V>>> entrySet() {
        return Collections.unmodifiableSet(this.outerMap.entrySet());
    }

    public Collection<V> values() {
        ArrayList<V> result = new ArrayList<V>(this.size());
        for (Map.Entry<K1, Map<K2, V>> entry : this.outerMap.entrySet()) {
            result.addAll(entry.getValue().values());
        }
        return result;
    }

    public Set<K1> keySet() {
        return Collections.unmodifiableSet(this.outerMap.keySet());
    }

    public Set<K2> keySet(K1 key1) {
        Map<K2, V> innerMap = this.getMap(key1);
        return innerMap == null ? Collections.emptySet() : Collections.unmodifiableSet(innerMap.keySet());
    }

    public Collection<V> remove(K1 key1) {
        Map<K2, V> innerMap = this.outerMap.remove(key1);
        return innerMap == null ? Collections.emptyList() : Collections.unmodifiableCollection(innerMap.values());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.outerMap.isEmpty()) {
            sb.append("  (Empty)");
        } else {
            for (Map.Entry<K1, Map<K2, V>> entry : this.outerMap.entrySet()) {
                sb.append("  ").append(entry.getKey()).append(" = ").append(entry.getValue()).append('\n');
            }
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    private Map<K2, V> getMap(K1 key1) {
        return this.outerMap.get(key1);
    }

    private Map<K2, V> createInnerMap() {
        if (this.shouldUseSortedInnerMap()) {
            return new TreeMap(new ValueComparator(this.shouldSortInAscendingOrder()));
        }
        if (this.shouldUseOrderedMap()) {
            return new LinkedHashMap(2);
        }
        return new HashMap(2);
    }

    private boolean shouldPreserveExisting() {
        return (this.policy & 2) != 0;
    }

    private boolean shouldUseOrderedMap() {
        return (this.policy & 1) != 0;
    }

    private boolean shouldUseSortedInnerMap() {
        return (this.policy & 0xC) != 0;
    }

    private boolean shouldSortInAscendingOrder() {
        return (this.policy & 0xC) == 4;
    }

    private boolean shouldUseSingletonInnerMap() {
        return (this.policy & 0x10) != 0;
    }

    private static class ValueComparator<T>
    implements Comparator<T> {
        private final boolean ascending;

        public ValueComparator(boolean ascending) {
            this.ascending = ascending;
        }

        @Override
        public int compare(T o1, T o2) {
            try {
                if (o1 instanceof Comparable) {
                    int cmp = ((Comparable)o1).compareTo(o2);
                    return this.ascending ? cmp : 0 - cmp;
                }
            }
            catch (Exception exception) {}
            return 1;
        }
    }
}

