/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.utils;

import com.ibm.cic.common.core.model.ISelectionExpression;

public class SelectionExpressionVisitor {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void visit(ISelectionExpression expr, ISelectionExpressionVisitor visitor) {
        if (expr instanceof ISelectionExpression.ISelectedById) {
            visitor.visit((ISelectionExpression.ISelectedById)expr);
            return;
        } else if (expr instanceof ISelectionExpression.ISelectedByPredefinedId) {
            visitor.visit((ISelectionExpression.ISelectedByPredefinedId)expr);
            return;
        } else if (expr instanceof ISelectionExpression.ISelectedByBundle) {
            visitor.visit((ISelectionExpression.ISelectedByBundle)expr);
            return;
        } else {
            if (!(expr instanceof ISelectionExpression.ISelectedByOperator)) throw new AssertionError((Object)("Unexpected ISelectionExpression: " + expr));
            ISelectionExpression.ISelectedByOperator e = (ISelectionExpression.ISelectedByOperator)expr;
            ISelectionExpression.ISelectionOperator op = e.getOperator();
            if (op instanceof ISelectionExpression.IUnarySelectionOperator) {
                SelectionExpressionVisitor.visit(((ISelectionExpression.IUnarySelectionOperator)op).getOperand(), visitor);
                return;
            } else {
                ISelectionExpression[] operands;
                if (!(op instanceof ISelectionExpression.IBinarySelectionOperator)) throw new AssertionError(op);
                ISelectionExpression[] iSelectionExpressionArray = operands = ((ISelectionExpression.IBinarySelectionOperator)op).getOperands();
                int n = operands.length;
                int n2 = 0;
                while (n2 < n) {
                    ISelectionExpression operand = iSelectionExpressionArray[n2];
                    SelectionExpressionVisitor.visit(operand, visitor);
                    ++n2;
                }
            }
        }
    }

    public static interface ISelectionExpressionVisitor {
        public void visit(ISelectionExpression.ISelectedById var1);

        public void visit(ISelectionExpression.ISelectedByPredefinedId var1);

        public void visit(ISelectionExpression.ISelectedByBundle var1);
    }
}

