/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.utils;

import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.utils.Statuses;
import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;

public class PlatformFilter {
    private final String filterText;
    private Filter filter = null;

    public PlatformFilter(String filter) {
        this.filterText = filter;
    }

    public IStatus matchesPlatform(String os, String arch) {
        return this.matchesPlatform(null, os, arch);
    }

    public IStatus matchesPlatform(String ws, String os, String arch) {
        IStatus result = this.init();
        if (!result.isOK()) {
            return result;
        }
        Dictionary props = this.createPlatformProperties(ws, os, arch);
        try {
            if (!this.filter.matchCase(props)) {
                return Statuses.ERROR.get(Messages.PlatformFilter_doesNotMatch, this.toPlatformString(ws, os, arch), this.filter.toString());
            }
        }
        catch (Throwable t) {
            return Statuses.ERROR.get(999, t, t.toString(), new Object[0]);
        }
        return result;
    }

    public String toString() {
        if (this.filter != null) {
            return this.filter.toString();
        }
        if (this.filterText != null) {
            return this.filterText.toString();
        }
        return super.toString();
    }

    public String toPlatformString(String ws, String os, String arch) {
        StringBuffer sb = new StringBuffer();
        sb.append('{');
        if (ws != null) {
            sb.append("ws").append('=').append(ws);
            sb.append(", ");
        }
        sb.append("os").append('=').append(os);
        sb.append(", ");
        sb.append("arch").append('=').append(arch);
        sb.append('}');
        return sb.toString();
    }

    private IStatus init() {
        if (this.filter == null) {
            try {
                this.filter = FrameworkUtil.createFilter((String)this.filterText);
            }
            catch (Throwable t) {
                return Statuses.ERROR.get(999, t, t.toString(), new Object[0]);
            }
        }
        return Status.OK_STATUS;
    }

    private Dictionary createPlatformProperties(String ws, String os, String arch) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        if (ws != null) {
            props.put("ws", ws);
        }
        props.put("os", os);
        props.put("arch", arch);
        return props;
    }
}

