/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.utils;

import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IInstallableUnitContainer;
import com.ibm.cic.common.core.utils.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class InstallableUnitUtil {
    public static final String CATEGORY_PREFIX = "category:";
    public static final String DEPENDENCIES_SEPARATOR = ",";
    public static final String DEPENDENCY_RELATIVE_SEPARATOR = "..";

    public static List getOrderDependenciesCategories(IInstallableUnit unit, boolean includeParent) {
        String parentOrderDependenciesCategoriesValue;
        String orderDependenciesCategoriesValue = unit.getProperty("order.dependencies.categories");
        if (includeParent && (parentOrderDependenciesCategoriesValue = unit.getParent().getProperty("order.dependencies.categories")) != null && parentOrderDependenciesCategoriesValue.length() > 0) {
            if (orderDependenciesCategoriesValue == null) {
                orderDependenciesCategoriesValue = parentOrderDependenciesCategoriesValue;
            } else {
                orderDependenciesCategoriesValue = String.valueOf(orderDependenciesCategoriesValue) + DEPENDENCIES_SEPARATOR;
                orderDependenciesCategoriesValue = String.valueOf(orderDependenciesCategoriesValue) + parentOrderDependenciesCategoriesValue;
            }
        }
        if (orderDependenciesCategoriesValue != null && orderDependenciesCategoriesValue.length() > 0) {
            return Util.splitStringAsList(orderDependenciesCategoriesValue, DEPENDENCIES_SEPARATOR);
        }
        return Collections.EMPTY_LIST;
    }

    public static List getOrderDependencies(IInstallableUnit unit) {
        String orderDependenciesValue = unit.getProperty("order.dependencies");
        ArrayList orderDependenciesList = new ArrayList();
        if (orderDependenciesValue != null) {
            orderDependenciesList.addAll(Util.splitStringAsList(orderDependenciesValue, DEPENDENCIES_SEPARATOR));
        }
        orderDependenciesList.addAll(InstallableUnitUtil.getParentOrderDependencies(unit, "order.dependencies"));
        return orderDependenciesList;
    }

    public static String getOrderDependenciesValue(IInstallableUnit unit) {
        List orderDependenciesList = InstallableUnitUtil.getOrderDependencies(unit);
        StringBuffer sb = new StringBuffer(orderDependenciesList.size() * 64);
        int i = 0;
        while (i < orderDependenciesList.size()) {
            if (i > 0) {
                sb.append(DEPENDENCIES_SEPARATOR);
            }
            sb.append((String)orderDependenciesList.get(i));
            ++i;
        }
        return sb.toString();
    }

    public static List getPassiveOrderDependencies(IInstallableUnit unit) {
        String orderDependenciesValue = unit.getProperty("passive.order.dependencies");
        ArrayList orderDependenciesList = new ArrayList();
        if (orderDependenciesValue != null) {
            orderDependenciesList.addAll(Util.splitStringAsList(orderDependenciesValue, DEPENDENCIES_SEPARATOR));
        }
        orderDependenciesList.addAll(InstallableUnitUtil.getParentOrderDependencies(unit, "passive.order.dependencies"));
        return orderDependenciesList;
    }

    public static List getSimpleDependencies(IInstallableUnitContainer container, String dependenciesProperty) {
        String orderDependenciesValue = container.getProperty(dependenciesProperty);
        if (orderDependenciesValue != null && orderDependenciesValue.length() > 0) {
            String[] orderDependencies = Util.splitString(orderDependenciesValue, DEPENDENCIES_SEPARATOR);
            ArrayList<String> orderDependenciesList = new ArrayList<String>(orderDependencies.length);
            String[] stringArray = orderDependencies;
            int n = orderDependencies.length;
            int n2 = 0;
            while (n2 < n) {
                String orderDependencie = stringArray[n2];
                if (InstallableUnitUtil.isSimpleDependency(orderDependencie)) {
                    orderDependenciesList.add(orderDependencie);
                }
                ++n2;
            }
            return orderDependenciesList;
        }
        return Collections.EMPTY_LIST;
    }

    private static boolean isSimpleDependency(String dependency) {
        return dependency.indexOf(DEPENDENCY_RELATIVE_SEPARATOR) < 0 && !dependency.startsWith(CATEGORY_PREFIX);
    }

    private static List getParentOrderDependencies(IInstallableUnit unit, String dependenciesProperty) {
        String orderDependenciesValue = unit.getParent().getProperty(dependenciesProperty);
        if (orderDependenciesValue != null && orderDependenciesValue.length() > 0) {
            String[] orderDependencies = Util.splitString(orderDependenciesValue, DEPENDENCIES_SEPARATOR);
            ArrayList<String> orderDependenciesList = new ArrayList<String>(orderDependencies.length);
            int i = 0;
            while (i < orderDependencies.length) {
                if (!InstallableUnitUtil.isSimpleDependency(orderDependencies[i])) {
                    orderDependenciesList.add(orderDependencies[i]);
                }
                ++i;
            }
            return orderDependenciesList;
        }
        return Collections.EMPTY_LIST;
    }
}

